/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-06-21: ChangeLog started
*/

#if !defined(oagFuncModRef_P)
#define oagFuncModRef_P

#include <stdlib.h>

#include "oaDesignDB.h"
#include "oagAiRef.h"

namespace oagFunc {

// *****************************************************************************
// ModRef
//
/// \brief A reference into an and/inverter graph in a particular Module.
///
/// The reference may refer to the function implemented by a node or its
/// inverse.
//
// *****************************************************************************

class ModRef {
  public:
                      ModRef() {
                          ref = 0; module = NULL;
                      }
                      ModRef(const ModRef &copy) {
                          ref = copy.ref; module = copy.module;
                      }
                      ModRef(oagAi::Ref a, oa::oaModule *o) {
                          ref = a; module = o;
                      }
  
    oagAi::Ref        ref;
    oa::oaModule     *module;

    bool              operator<(const ModRef &comp) const { 
                          /// This operator involves a pointer comparison
                          /// and will not produce the same ordering
                          /// if the memory locations of modules
                          /// change.  This may be the case in two different
                          /// executions, or if portions of the
                          /// database are purged and reloaded.
        
                          if (module != comp.module) 
                              return module<comp.module; 
                          else 
                              return ref<comp.ref; 
                      }
    bool              operator==(const ModRef &comp) const {
                          return module == comp.module && ref == comp.ref;
                      }
    bool              operator!=(const ModRef &comp) const {
                          return module != comp.module || ref != comp.ref;
                      }

    void              printName(bool lineFeed = true);
    void              print(bool lineFeed = true);
};

}

#endif
