/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-05-31: ChangeLog started
*/

#if !defined(oagFunc_P)
#define oagFunc_P

#include "oaDesignDB.h"
#include "oagAiGraph.h"
#include "oagFuncObserver.h"

namespace oagFunc {

class ModRef;
class OccRef;

// *****************************************************************************
// functional AppDefs
//
// *****************************************************************************

extern oa::oaVarDataAppDef<oa::oaDesign>        *streamAppDef;
extern oa::oaVoidPointerAppDef<oa::oaDesign>    *managerAppDef;
extern oa::oaIntAppDef<oa::oaModBitNet>         *AiRefAppDef;


// *****************************************************************************
// oagFunc
//
// \brief Global/utility operations on functional information.
//
// Before any operations on functional information are attempted, 
// the initialize() function must first be called.
//
// *****************************************************************************
  
    void                  initialize();

    /// \name Reading and writing functional descriptions from other formats
    /// @{
    
    void                  readVerilog(oa::oaLib *library, 
                                      const char *filename );
    void                  readVerilog(oa::oaLib *library,
                                      const oa::oaScalarName &viewName,
                                      const char *filename );
    void                  writeVerilog(oa::oaLib *library, oa::oaView *view,
                                       const char *filename );
    void                  writeVerilog(oa::oaDesign *design,
                                       const char *filename );
    void                  readLiberty(oa::oaLib *library,
                                      const char *filename ); 
    void                  readLiberty(oa::oaLib *library,
                                      const oa::oaScalarName &viewName,
                                      const char *filename
                                     ); 

    /// @}
    /// \name Manipulating bits and busses
    /// @{

    oa::oaOccBusTerm*     findBusTerm(oa::oaOccBusTermBit *bitTerm);
    oa::oaModBusNet*      findBusNet(oa::oaModBitNet *bitNet);

    inline oa::oaOccBitNet* toBitNet(oa::oaOccNet *net) {
        /// \brief Safely casts an oaOccNet* to an oaOccBitNet*.
        ///
        /// If the given net has multiple bits, an assertion will
        /// be generated.    
        assert(net);
        assert(net->getSingleBitMembers().getCount() == 1);
        return net->getBit(0);
    }
    inline oa::oaModBitNet* toBitNet(oa::oaModNet *net) {
        /// \brief Safely casts an oaModNet* to an oaModBitNet*.
        ///
        /// If the given net has multiple bits, an assertion will
        /// be generated.
        assert(net);
        assert(net->getSingleBitMembers().getCount() == 1);
        return net->getBit(0);
    }

    /// @} 
    /// \name Hierarchy collapsing and unfolding
    /// @{
    
    void                 collapseOneInstanceOneLevel(oa::oaModInst *inst);
    void                 collapseOneInstanceAllLevels(oa::oaModInst *inst,
                                                      bool preserveStateNets = true,
                                                      bool preserveAllNets = false);
    void                 collapseAllInstancesOneLevel(oa::oaModule *module);
    void                 collapseAllInstancesAllLevels(oa::oaModule *module,
                                                      bool preserveStateNets = true,
                                                      bool preserveAllNets = false);
    oa::oaOccurrence *   uniquify(oa::oaOccurrence *occurrence);
        bool                             isUnique(oa::oaOccurrence *occurrence);
      
    /// @} 
    /// \name Copying and extracting functionality
    /// @{
   
    oa::oaModule *       copy(oa::oaModule *source, bool makeNewDesign = true);
    oa::oaModule *       extract(oa::oaModule *source, bool makeNewDesign = true);

    ModRef               partialCopyNode(ModRef original, oa::oaModule *destModule);
    ModRef               partialCopyNode(OccRef original, oa::oaModule *destModule);

    /// @}
   
    extern Observer     *observer;
  
}

#endif
