/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron Hurst <ahurst@eecs.berkeley.edu>

ChangeLog:
2005-07-20: ChangeLog started
*/

#if !defined(oagDdCuddManager_P)
#define oagDdCuddManager_P

class DdNode;
class DdManager;

#include "oagDdAbstractManager.h"

namespace oagDd {

/// \brief A wrapper for the Colorado University Decision Diagram package.

class CuddManager : public AbstractManager<DdNode*> {

  public:
    
    CuddManager();
    ~CuddManager();
    
    /// Computes the conjunction of two functions.
    /// \param x
    /// \param y
    /// \return x * y
    DdNode* andOf(DdNode* x, DdNode* y);

    /// Computes the disjunction of two functions.
    /// \param x
    /// \param y
    /// \return x + y
    DdNode* orOf(DdNode* x, DdNode* y);
 
    /// Computes the exclusive-OR of two functions.
    /// \param x
    /// \param y
    /// \return x ^ y
    DdNode* xorOf(DdNode* x, DdNode* y);

    /// Computes the complement of a function.
    /// \param x
    /// \return !x
    DdNode* notOf(DdNode* x);
    
    /// Returns a new variable.
    /// \return a new variable
    DdNode* newVariable( );

    /// Returns the function that is always false.
    /// \return false
    DdNode* getZero( );
  
    /// Prints an orthogonal cubelist cover of a function.
    /// \param x
    void    print( DdNode *x );
  
  protected:

    DdManager *mgr;  
};

}

#endif
