/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#ifndef _PLACER_INTERNALS_H_
#define _PLACER_INTERNALS_H_

#include <string>
#include "capoExposedInterface.h"
#include "RBPlace/RBPlacement.h"

//Create wrappers for additional placers and declare them here

void 
buildCapoRBPlacementFromOA(RBPlacement*& rb,
                           capoExposedInterface& capo, 
                           int argc,
                           const char** argv);

void buildCapoRBPlacementFromOARegionQuery(RBPlacement*& rb,
                                          capoExposedInterface& capo, 
                                          const oa::oaBox&  bbox, 
                                          int argc,
                                          char** argv);

void
writeCapoPlacementToOA(const RBPlacement& rb,
                       capoExposedInterface& capo); 

#endif
