/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2005-06-22: ChangeLog started
*/

#include <iostream>

#include "placementCommon.h"


oa::oaBox getPlacementBBox(const oa::oaInst * const inst)
{
  assert(inst && "Attempt to get placement BBox of NULL inst");
  oa::oaDesign* master = inst->getMaster();
  oa::oaBlock* topBlock = master->getTopBlock();
  oa::oaSnapBoundary *sb = oa::oaSnapBoundary::find(topBlock);
  oa::oaBox returnVal;
  sb->getBBox(returnVal);
  return returnVal;
}


