/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#ifndef _OPENACCESS_INPUT_OUTPUT_H_
#define _OPENACCESS_INPUT_OUTPUT_H_

#include <string>
#include "oaDesignDB.h"
#include "HGraphWDims/hgWDims.h"
#include "Placement/placement.h"


void openOADesignBlock(oa::oaDesign*& des, 
                     oa::oaBlock*& block,
                     const std::string& Lib, 
                     const std::string& Cell, 
                     const std::string& View);

void writePlacement(oa::oaDesign *des, 
                    const HGraphWDimensions& hgraph, 
                    const Placement& pl);

struct singletonCurrDes
{
  static oa::oaDesign* getCurrDesign(void);
  static void setCurrDesign(oa::oaDesign* des);
  static oa::oaDesign* _des;
};

   
#endif

