/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <iostream>
using std::cerr;
using std::endl;
using std::cin;
using std::cout;
#include "oaIO.h"
#include "oaDM.h"
using oa::oaNativeNS;
using oa::oaString;
using oa::oaScalarName;
using oa::oaException;
using oa::oaCellView;
using oa::oaLibDef;
using oa::oaLib;
using oa::oaDesign;
using oa::oaBlock;
using oa::oaPoint;
using oa::oaInstHeader;
using oa::oaInst;
using oa::oaIter;
using oa::oaCollection;
using oa::oaUInt4;
using oa::oacFixedPlacementStatus;
using oa::oacLockedPlacementStatus;

void openOADesignBlock(oa::oaDesign*& des, oa::oaBlock*& block,
                     const std::string& Lib, 
                     const std::string& Cell, 
                     const std::string& View)
{
  try
  {
    oaString        libstr(Lib.c_str());
    oaString        cellstr(Cell.c_str());
    oaString        viewstr(View.c_str());
    
    // Treat the names in parameter list as belonging to the Native
    // namespace and convert them to oaNames.
    oaNativeNS      ns;
    oaScalarName    libName(ns, libstr);
    oaScalarName    cellName(ns, cellstr);
    oaScalarName    viewName(ns, viewstr);
   

    des = oaDesign::open(libName, cellName, viewName,'a');

    // FIXME workaround net connectivity bug TODO
    for(oaIter<oaInstHeader> i = des->getTopBlock()->getInstHeaders();
    oaInstHeader* instHeader = i.getNext(); /**/) {
      oaCollection<oaInst, oaInstHeader> coll = instHeader->getInsts();
    }
    block = des->getTopBlock();
  }
  catch (oaException &excp)
  {
    printf("Error: %s\n", (const char *)excp.getMsg());
    exit(1);
  }

  if(!des)
  {
    cerr<<"Unable to get design pointer, but no exception thrown"<<endl;
    exit(1);
  }
  if(!block)
  {
    cerr<<"Unable to get block pointer, but no exception thrown"<<endl;
    exit(1);
  }
  singletonCurrDes::setCurrDesign(des);
}

void writePlacement(oaDesign *des, 
                    const HGraphWDimensions& hgraph, 
                    const Placement& pl)
{
  try
  {
    oaBlock* block = des->getTopBlock();
    oaNativeNS ns;
                                                                            
    printf("Writing pl locations to oaDesign\n");
                                                                              
    oaIter<oaInst> iIter(block->getInsts());
    while (oaInst   *inst = iIter.getNext())
    {
      bool isFixed=false;
      switch (inst->getPlacementStatus())
      {
        case oacLockedPlacementStatus:
        case oacFixedPlacementStatus:
          isFixed = true;
          cout<<"DPDEBUG: found a fixed inst"<<endl;
          break;
        default:
          isFixed = false;
      }
      if(!isFixed)
      {
        oaString        iStr;
        inst->getName(ns, iStr);
        int i = hgraph.getNodeByName(static_cast<const char *>(iStr)).getIndex();
        Point p = pl[i];
        oaPoint oap(static_cast<int>(p.x),static_cast<int>(p.y));
        inst->setOrigin(oap);
      }
    }
  
    //des->save();
  }
  catch (oaException &excp)
  {
    printf("Error: %s\n", (const char *)excp.getMsg());
    exit(1);
  }
                                                                          
}


  oa::oaDesign* singletonCurrDes::getCurrDesign(void)
  {
    return _des;
  }
  void singletonCurrDes::setCurrDesign(oa::oaDesign* des)
  {
     _des = des;
  }
  oa::oaDesign* singletonCurrDes::_des=0;


