/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <assert.h>
#include <iostream>
#include <map>
#include<string>

#include "ABKCommon/uofm_alloc.h"

#include "capoExposedInterface.h"
#include "placementCommon.h"
#include "PlacerInterface.h"
#include "Placement/placeWOri.h"
#include "oaDesignDB.h"
#include "oaRegionQuery.h"
#include "Bazaar/oagException.h"

using std::cout;
using std::endl;
using std::cerr;
using std::map;

using uofm::vector;
using uofm::string;

using oa::oaInstQuery;
using oa::oaRowQuery;
//using oa::oaTermQuery;
using oa::oaTerm;
using oa::oaTermType;
using oa::oaInst;
using oa::oaInstTerm;
using oa::oaNet;
using oa::oaBox;
using oa::oaNativeNS;
using oa::oaIter;
using oa::oaString;
using oa::oacLockedPlacementStatus;
using oa::oacFixedPlacementStatus;
using oa::oacInputTermType;
using oa::oacOutputTermType;
using oa::oacInputOutputTermType;
using oa::oaBoolean;
using oa::oaSigType;
using oa::oaUInt4;
using oa::oaException;
using oa::oaBlock;
using oa::oaCoreBoxSpec;
using oa::oaPRBoundary;
using oa::oaPin;
using oa::oaPinFig;
using oa::oaRow;
using oa::oaBlockObject;
using oa::oaPoint;

            std::string getNameFromOA(oa::oaInst* i)
            {
                oa::oaNativeNS ns;
                oa::oaString name;
                i->getName(ns,name);
                return std::string(static_cast<const char*>(name) );
            }


bool checkIfAllPinsOnSameCell(oaNet* net, const map<oaInst*,unsigned>&  oaInst_ptr_to_node_idx)
{
    bool allthesame = true;
    oaIter<oaInstTerm>      tiIter(net->getInstTerms());
    oaInstTerm   *checkTerm = tiIter.getNext();
    if(checkTerm)
    {
      oaInst* inst = checkTerm->getInst();
      if(oaInst_ptr_to_node_idx.find(inst) != oaInst_ptr_to_node_idx.end())
      {
        unsigned node_idx = oaInst_ptr_to_node_idx.find(inst)->second;
        while ( (checkTerm = tiIter.getNext()) )
        {
          oaInst* inst = checkTerm->getInst();
          if(oaInst_ptr_to_node_idx.find(inst) != oaInst_ptr_to_node_idx.end())
          {
            unsigned new_node_idx = oaInst_ptr_to_node_idx.find(inst)->second;
            allthesame = allthesame && (node_idx == new_node_idx);
          }
        }
      }
    }
    return allthesame;
}

//manually construct the HGraphWDimensions according
//to the "exposed interface" see ~/UCLApack/HGraphWDims/hgWDims.h
//for more information.
void
capoExposedInterface::buildCapoHGraphWDimensions(HGraphWDimensions*& hg)
{
  oaNativeNS     ns;
  //TODO:  This isnt the exact number of terminals
  // here i am assuming that there are 0 Fixed and Locked insts
  unsigned numNodes = _node_idx_to_ptr.size();
  map<oaTerm*,unsigned> oaTerm_ptr_to_node_idx;
  map<oaInst*,unsigned> oaInst_ptr_to_node_idx;

  hg = HGraphWDimensions::createNewManualHGraphWDimensions(numNodes);

  oaIter<oaInst> ifixedIter(_block->getInsts());
  oaIter<oaInst> iIter(_block->getInsts());
  oaIter<oaTerm> itIter(_block->getTerms());
  while (oaTerm   *term = itIter.getNext()) 
  {
    oaString        iStr;
    term->getName(ns, iStr);
    string newTermName(static_cast<const char*>(iStr));
    //cerr<<"DPDEBUG: creating a new term named: "<<newTermName<<endl;
    unsigned node_idx = hg->create_node(newTermName,0,0,true);
    //cerr<<"DPDEBUG:  the index of the new term is: "<< node_idx << endl;
    //cerr<<"DPDEBUG: CREATING TERM "<<newTermName<<endl;
    assert(term);
    _node_idx_to_ptr[node_idx]=term;
    assert(term);

    _is_term[node_idx]=true;
    _is_fixed_inst[node_idx]=false;
    oaTerm_ptr_to_node_idx[term]=node_idx;
    //specify terminal?
  } //for each term

  //for each fixed inst -- DAP, fix for Kai-Hui Chang
  //Until capo better supports distinctions between terminals and fixed objects
  //we will consider all fixed objects terminals for convenience
  //This means we have to add them to the hypergraph first
  while (oaInst   *inst = ifixedIter.getNext()) 
  {
    oaString        iStr;
    //oaOrient        orient = inst->getOrient();
    oaBox           bbox = getPlacementBBox(inst);
    inst->getName(ns, iStr);
    oaBoolean isFixed;
    switch (inst->getPlacementStatus())
    {
      case oacLockedPlacementStatus:
      case oacFixedPlacementStatus:
        isFixed = true;
        break;
      default:
        isFixed = false;
    }
    if(isFixed)
    {
      string newNodeName(static_cast<const char*>(iStr));
      unsigned node_idx = 
        hg->create_node(newNodeName, bbox.getWidth(), bbox.getHeight(), isFixed==1);
      //cerr<<"DPDEBUG:  the index of the new fixed cell is: "<< node_idx << endl;
      //cerr<<"DPDEBUG: CREATING FIXED CELL AS A TERM "<<newNodeName<<endl;
      assert(inst);
      _node_idx_to_ptr[node_idx]=inst; 
      assert(inst);
      _is_term[node_idx]=false;
      _is_fixed_inst[node_idx]=true;
      oaInst_ptr_to_node_idx[inst]=node_idx;
    }
  }//for each inst


  while (oaInst   *inst = iIter.getNext()) 
  {
    oaString        iStr;
    //oaOrient        orient = inst->getOrient();
    oaBox           bbox = getPlacementBBox(inst);
    inst->getName(ns, iStr);
    oaBoolean isFixed;
    switch (inst->getPlacementStatus())
    {
      case oacLockedPlacementStatus:
      case oacFixedPlacementStatus:
        isFixed = true;
        break;
      default:
        isFixed = false;
    }
    if(!isFixed)
    {
      string newNodeName(static_cast<const char*>(iStr));
      unsigned node_idx = 
        hg->create_node(newNodeName, bbox.getWidth(), bbox.getHeight(), isFixed==1);
      //cerr<<"DPDEBUG:  the index of the new cell is: "<< node_idx << endl;
      //cerr<<"DPDEBUG: CREATING NODE "<<newNodeName<<endl;
      assert(inst);
      _node_idx_to_ptr[node_idx]=inst; 
      assert(inst);
      _is_term[node_idx]=false;
      _is_fixed_inst[node_idx]=false;
      oaInst_ptr_to_node_idx[inst]=node_idx;
    }
  }//for each inst

  //cerr<<"DPDEBUG: HG SIZE: "<<hg->getNumNodes()<<endl; 
  ///TODO:  need to store indicies to oaInst* or oaNet*
  ///Finished creating all nodes

  // Print the Nets in the CellView and Terms on each Net.
  vector<oaNet*> net_idx_to_oaNet_ptr(_block->getNets().getCount());
  oaIter<oaNet>   nIter(_block ->getNets());

  nIter.reset();
  while (oaNet   *net = nIter.getNext()) 
  {
    //A net must have at least 2 pins
    if(net->getTerms().getCount() + net->getInstTerms().getCount() < 2 ) continue;

    //The two pins must be on at least 2 distinct cells
    if(checkIfAllPinsOnSameCell(net, oaInst_ptr_to_node_idx)) continue;

    oaString        nStr;
    oaSigType       stype = net->getSigType();
    net->getName(ns, nStr);
    string netName(nStr);
    unsigned e_idx = hg->create_edge(netName);
    net_idx_to_oaNet_ptr[e_idx]=net;
    map<unsigned, bool> node_seen;

    // add each Term on this Net
    oaIter<oaTerm>      tIter(net->getTerms());
    while (oaTerm   *term = tIter.getNext()) 
    {
      oaString    tStr;
      oaTermType  ttype = term->getTermType();

      term->getName(ns, tStr);
      unsigned node_idx = oaTerm_ptr_to_node_idx[term];
      //cerr <<"trying to add "<<tStr<<" (# "<<node_idx<<") to net... "<<endl;
      if(!node_seen[node_idx])
      {
        //cerr<<"Successful."<<endl;
        node_seen[node_idx] = true;
        switch (ttype)
        {
          case oacInputTermType :   
            hg->add_node_to_edge(node_idx,e_idx,'I');
            break;
          case oacOutputTermType :  
            hg->add_node_to_edge(node_idx,e_idx,'O');
            break;
          case oacInputOutputTermType : 
          default :
            hg->add_node_to_edge(node_idx,e_idx,'B');
            break;
        }
      }
      else
      {
        //cerr<<" already added!"<<endl;
        ;
      }
    }//for each Term

    // add each instTerm on this Net
    oaIter<oaInstTerm>      tiIter(net->getInstTerms());
    while (oaInstTerm   *term = tiIter.getNext()) 
    {

      oaString    tStr;
      oaInst* inst = term->getInst();
      inst->getName(ns, tStr);
      oaTerm* t = term->getTerm();
      if(!t) 
      {
        //TODO it is an ugly hack to skip over missing terms
        //but this can occur if the library containing the master cannot be opened
        continue; 
        cerr << "Coult not find term: "<<tStr<<endl;
        assert(0 && "Unable to find an oaTerm");
      }
      oaTermType  ttype = t->getTermType();
      unsigned node_idx = oaInst_ptr_to_node_idx[inst];
      //cerr <<"trying to add "<<tStr<<" (# "<<node_idx<<") to net... "<<std::flush;
      if(!node_seen[node_idx])
      {
        //cerr<<"Successful."<<endl;
        node_seen[node_idx]=true;
        switch (ttype)
        {
          case oacInputTermType :   
            hg->add_node_to_edge(node_idx,e_idx,'I');
            break;
          case oacOutputTermType :  
            hg->add_node_to_edge(node_idx,e_idx,'O');
            break;
          case oacInputOutputTermType : 
          default :
            hg->add_node_to_edge(node_idx,e_idx,'B');
            break;
        }
      }
      else
      {
        //cerr<<" already added!"<<endl;
        ;
      }
    }//for each instTerm

  }//for each Net
  //cerr<<"DPDEBUG: HG SIZE: "<<hg->getNumNodes()<<endl; 
  //cerr<<"DPDEBUG: HG SIZE NETS: "<<hg->getNumEdges()<<endl; 

  hg->done();
}


void 
capoExposedInterface::readOAPlLocations(vector<Point>& loc)
{
    try
    {
        oaNativeNS     ns;
        oaTerm* term = 0;
        oaInst* inst = 0;
        loc.clear();
        loc.resize(_node_idx_to_ptr.size(), Point(0,0));
        assert(loc.size() == _is_term.size());
        for(size_t node_idx = 0; node_idx < loc.size(); ++node_idx)
        {
            //look up pointer of correct type of 
            //oaBox           bbox;
            oaPoint place_origin;
            if(_is_term[node_idx])
            {
              //assert(_node_idx_to_ptr.find(node_idx) != _node_idx_to_ptr.end());
              //assert(*_node_idx_to_ptr.find(node_idx) != 0);
              try
              {
                term = static_cast<oaTerm*>(_node_idx_to_ptr[node_idx]); 
                if(term) 
                {
                  assert(term);
                  oaIter<oaPin> pinIter(term->getPins());
                  oaPin *pin = pinIter.getNext();
                  if(pin == NULL)
                  {
                    CapoWrapperException excp;
                    excp.msg = "Error: oaTerm does not have an oaPin"; 
                    throw excp;
                  }
                  oaIter<oaPinFig>      figIter(pin->getFigs());
                  oaPinFig * fig = figIter.getNext();
                  if(fig == NULL)
                  {
                    CapoWrapperException excp;
                    excp.msg = "Error: oaPin does not have an oaPinFix "; 
                    throw excp;
                  }
                  //is this the correct location we want to use? //TODO
                  oaBox           bbox;
                  fig->getBBox(bbox);
                  place_origin.x() = bbox.left();
                  place_origin.y() = bbox.bottom();
                }
              }
              catch (CapoWrapperException &excp) 
              {
                cerr<<"Wrapper Exception inside capo exposed interface"<<endl<<excp.msg<<endl;
                exit(1);
              }
            }
            else if( _is_fixed_inst[node_idx])
            {
              try 
              {
                inst = static_cast<oaInst*>(_node_idx_to_ptr[node_idx]); 
                if(inst)
                {
                 // bbox = getPlacementBBox(inst);
                  //inst->getBBox(bbox);
                  inst->getOrigin(place_origin);

                  //std::string s = getNameFromOA(inst);
                  //cout<<"DPDEBUG: fixed cell "<<s<<" located at: "<<endl;
                  //cout<<"DPDEBUG: ("<<bbox.left()<<", "<<bbox.bottom()<<", "<<bbox.right()<<", "<<bbox.top()<<")"<<endl;
                  //cout<<"DPDEBUG: ("<<place_origin.x()<<", "<<place_origin.y()<<")"<<endl;
                }
              }
              catch (CapoWrapperException &excp) 
              {
                cerr<<"Wrapper Exception inside capo exposed interface"<<endl<<excp.msg<<endl;
                exit(1);
              }
            }
            else
            {
              //if(_node_idx_to_ptr.find(node_idx)==_node_idx_to_ptr.end())
              assert(_node_idx_to_ptr.size() > node_idx);
              try 
              {
                if(!_node_idx_to_ptr[node_idx])
                {
                  CapoWrapperException excp;
                  excp.msg = "Error: found a pointer that is not stored";    
                  throw excp;
                }
                else
                {
                  //cerr<<"DPDEBUG Found a stored pointer "<<endl;
                }
                //assert(_node_idx_to_ptr.find(node_idx) != _node_idx_to_ptr.end());
              }
              catch (CapoWrapperException &excp) 
              {
                cerr<<"Wrapper Exception inside capo exposed interface"<<endl<<excp.msg<<endl;
                exit(1);
              }
             
              try
              {
                //assert(*_node_idx_to_ptr.find(node_idx) != 0);
                inst = static_cast<oaInst*>(_node_idx_to_ptr[node_idx]); 
                if(!inst)
                {
                  CapoWrapperException excp;
                  excp.msg = "Error: unable to find an inst from stored pointer";
                  throw excp;
                }
                else
                {
                  //cerr<<"DPDEBUG Found a valid inst"<<endl;
                }
              }
              catch (CapoWrapperException &excp) 
              {
                cerr<<"Wrapper Exception inside capo exposed interface"<<endl<<excp.msg<<endl;
                exit(1);
              }

              //bbox = getPlacementBBox(inst);
              //inst->getBBox(bbox);
              inst->getOrigin(place_origin);
            }
            //loc[node_idx] = Point(bbox.bottom(),bbox.left());
            loc[node_idx] = Point(place_origin.x(), place_origin.y());
            //  pl << "\t : N";  //TODO : fix this to use real oaOrient
        }//for loop: each capo node idx
    } 
    catch (oaException &excp) 
    {
        cerr<<"oaException inside capo exposed interface"<<endl;
        printf("\t%s\n", (const char *)excp.getMsg());
        exit(1);
    }
    catch (CapoWrapperException &excp) 
    {
        cerr<<"Uncaught Wrapper Exception inside capo exposed interface"<<endl;
        cerr<<excp.msg<<endl;
        exit(1);
    }
}//function: readOAPllocations

void 
capoExposedInterface::buildCapoCoreRows(const PlacementWOrient* pl, 
                                        vector<RBPCoreRow>*& cr)
{
    //cerr<<"DPDEBUG: "<<(&cr)<<endl;
    oaCoreBoxSpec cbs;
    oaPRBoundary *prb = 0;
    oaBlock * bl  = _block;
    prb = oaPRBoundary::find(bl);
    if(!prb || !prb->hasCoreBoxSpec() )
    {
        cerr<<"Design has no placement boundaries, aborting placement..."<<endl;
        oagBazaar::operationDesignIncompatible error;
        throw error;
    }
    prb->getCoreBoxSpec(cbs);

    //TODO : the following line of code accounts for a bug in the OA implementation
    // the row counts can be over by 1 in some circumstances, hence the -1. bug: [ #262 ]
    oaUInt4 nRows = cbs.getNumRows() -1;
    cr=new vector<RBPCoreRow>;
    cr->reserve(nRows);

    for(oaUInt4 i = 0; i < nRows; i++)
    {
        oaBox bbox;
        //TODO : the following line of code accounts for a bug in the OA implementation
        // the row counts begin at 1, and therefore I adding 1
        // this should be changed to simply i if and when the bug is fixed. bug: [ #263 ]
        cbs.getRowBBox(i+1,bbox);

        oaUInt4 numSites = ( bbox.right() - bbox.left() ) / cbs.getSiteDef()->getWidth();
        oaUInt4 width = cbs.getSiteDef()->getWidth();

        oaUInt4 spacing = width;
        double xStart = bbox.left();

        //cerr<<"DPDEBUG: \t bottom: "<<bbox.bottom()<<endl;
        //cerr<<"DPDEBUG: \t height: "<<cbs.getSiteDef()->getHeight()<<endl;
        //cerr<<"DPDEBUG: \t sitewidth: "<< width << endl;
        //PlacementWOrient pl2(pl);
        //cerr<<"DPDEBUG: \t placement: "<<endl<<pl2<<endl;
        //cerr<<"DPDEBUG: \t spacing: "<<spacing<<endl;
        RBPCoreRow r(bbox.bottom(), Orient("N"), //TODO "N"  
                RBPSite(cbs.getSiteDef()->getHeight(),
                    width,
                    Symmetry("") //TODO
                    ),
                *pl,
                spacing
                );



        double xEnd = (numSites-1)*spacing + width + xStart;
        r.appendNewSubRow(xStart, xEnd);
        //cerr<<"DPDEBUG:  "<<r<<endl;
        cr->push_back(r);
        //cerr<<"DPDEBUG:  "<<endl<<cr<<endl;
    }
    //cerr<<"DPDEBUG:  "<<endl<<cr<<endl;
    //cerr<<"DPDEBUG:  "<<&cr<<endl;
    //for(size_t i=0;i<cr->size();i++)
    //cerr<<&((*cr)[i])<<endl;
}

//class pushTermsOnVec: public oaTermQuery, public vector<oaTerm*>
//{
//public:
//     virtual void queryTerm(oaTerm* t)
//    {
//        push_back(t);
//    }
//    
//};

class pushInstsOnVec: public oaInstQuery, public vector<oaInst*>
{
public:
     virtual void queryInst(oaInst* inst)
    {
        push_back(inst);
    }
    
};

class pushRowsOnVec: public oaRowQuery, public vector<oaRow*>
{
public:
     virtual void queryRow(oaRow* row)
    {
        push_back(row);
    }
    
};

void  //TODO
capoExposedInterface::buildCapoHGraphWDimensions(HGraphWDimensions*& hg,
                                                 const oaBox& bbox)
{
  //magic box region query
  //It is very possible to reuse the code (not copy paste) from the 
  //respective overloaded members
  //this will take some time I dont have right now,   TODO

  //this code got out of date, and now I am going to cut it out.  I will
  //simply leave a call to the above function here which does work.
  //someday maybe the above function will call this one instead :P
  buildCapoHGraphWDimensions(hg);

}

void clip_bbox(const oaBox& bbox, oaBox& row_bbox)
//this is unwritten   TODO
{
  static_cast<void>(bbox); //avoid unused paramter warning
  static_cast<void>(row_bbox); //avoid unused paramter warning
  //this is just an empty stub.  Write this whenever.
  return; //stub returns right away
}

void  //TODO
capoExposedInterface::buildCapoCoreRows(const PlacementWOrient* pl, 
                           vector<RBPCoreRow>*& cr,
                           const oa::oaBox& bbox)
{
  //just call the implemented one for now
  buildCapoCoreRows(pl, cr);
}

