###############################################################################
# Initialization
###############################################################################

AC_PREREQ([2.57])
AC_INIT([OAGear], [@@VERSION@@], [pchong@cadence.com], [OAGear])
AC_CONFIG_AUX_DIR([Build])
AM_INIT_AUTOMAKE([foreign])
AC_CONFIG_SRCDIR([config.h.in])
AM_CONFIG_HEADER([config.h])
AC_COPYRIGHT([
(c) Copyright 2004-2006, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information.
])

###############################################################################
# Compilation Features
###############################################################################

AC_ARG_ENABLE([check], AC_HELP_STRING([--enable-check],
    [check for external packages (default: yes)]),
    [test "$enable_check" = "yes" || enable_check=""],
    [enable_check="yes"])
AC_ARG_ENABLE([debug], AC_HELP_STRING([--enable-debug],
    [compile with debug (default: no)]),
    [test "$enable_debug" = "yes" || enable_debug=""],
    [enable_debug=""])
AC_ARG_ENABLE([all], AC_HELP_STRING([--enable-all],
    [build all OA Gear components (default: yes)]),
    [test "$enable_all" = "yes" || enable_all=""],
    [enable_all="yes"])
AC_ARG_ENABLE([bazaar], AC_HELP_STRING([--enable-bazaar],
    [build OA Gear Bazaar]),
    [test "$enable_bazaar" = "yes" || enable_bazaar=""],
    [enable_bazaar="$enable_all"])

# METAMAKE ENABLES

###############################################################################
# External Packages
###############################################################################

AC_ARG_WITH([oa], AC_HELP_STRING([--with-oa=DIR],
    [look for OpenAccess in DIR (default: ../OA-2.2)]), ,
    [with_oa="../OA-2.2"])
AC_ARG_WITH([sysname], AC_HELP_STRING([--with-sysname=SYSNAME],
    [override automatically detected OA sysname]), ,
    [with_sysname=""])

# QT is configured using the QTDIR environment variable
# so there is no --with-qt flag
with_qt="$QTDIR"

AC_ARG_WITH([cudd], AC_HELP_STRING([--with-cudd=DIR],
    [look for CUDD in DIR (default: ../cudd)]), ,
    [with_cudd="../cudd"])
AC_ARG_WITH([tcl], AC_HELP_STRING([--with-tcl=DIR],
    [look for tclConfig.sh in DIR (default: /usr/lib)]), ,
    [with_tcl="/usr/lib"])
AC_ARG_WITH([umpack], AC_HELP_STRING([--with-umpack=DIR],
    [look for UMpack in DIR (default: ../UMpack)]), ,
    [with_umpack="../UMpack"])
AC_ARG_WITH([zlib], AC_HELP_STRING([--with-zlib=DIR],
    [look for zlib in DIR (default: /usr)]), ,
    [with_zlib="/usr"])

###############################################################################
# Fix Relative Paths
###############################################################################

# Directory names provided by the user which start with '/', '\', '?:/'
# or '?:\' (where ? is assumed to be a letter) are absolute paths
# and need not be changed.
# Otherwise we prepend the present working directory to the directory name
# since it is a relative path.

case "$with_oa" in
    [[\\/]*|?:[\\/]*]) ;;
    *) with_oa="$PWD/$with_oa" ;;
esac

case "$with_cudd" in
    [[\\/]*|?:[\\/]*]) ;;
    *) with_cudd="$PWD/$with_cudd" ;;
esac
case "$with_tcl" in
    [[\\/]*|?:[\\/]*]) ;;
    *) with_tcl="$PWD/$with_tcl" ;;
esac
case "$with_umpack" in
    [[\\/]*|?:[\\/]*]) ;;
    *) with_umpack="$PWD/$with_umpack" ;;
esac
case "$with_zlib" in
    [[\\/]*|?:[\\/]*]) ;;
    *) with_zlib="$PWD/$with_zlib" ;;
esac

###############################################################################
# Check configuration consistency
###############################################################################

# METAMAKE CONSISTENCY

###############################################################################
# Check for programs
###############################################################################

AC_LANG([C++])
AC_PROG_CC
AC_PROG_CXX
AC_PROG_CXXCPP
AM_PROG_LEX
AC_PROG_YACC

AC_LIBTOOL_DLOPEN
AC_DISABLE_STATIC
AC_PROG_LIBTOOL

###############################################################################
# Check for Doxygen and Dot
###############################################################################

if test "$enable_check" ; then
    AC_PATH_PROG([OAG_DOXYGEN], [doxygen], [""])
    if test "OAG_DOXYGEN" ; then
	AC_CHECK_PROG([OAG_HAVE_DOT], [dot], [yes], [no])
	AC_CHECK_PROG([OAG_HAVE_FIG2DEV], [fig2dev], [yes], [no])
    fi
fi

###############################################################################
# Set compile flags for OA
###############################################################################

if test "$enable_debug" ; then
    AC_MSG_NOTICE([debug enabled])
    OAG_D=D
    OAG_LIBOPT=dbg
else
    OAG_D=
    OAG_LIBOPT=opt
fi

OAG_CPPFLAGS="-I$with_oa/include/oa"
# FIXME workaround for Solaris
if test `uname -s` = "Linux" ; then
    OAG_CXXFLAGS="-fPIC -W -Wall -Wno-non-virtual-dtor -Wno-ctor-dtor-privacy"
    OAG_LDADD="-loaBase$OAG_D -loaDM$OAG_D -loaDesign$OAG_D -loaPlugIn$OAG_D \
-loaTech$OAG_D -loaCommon$OAG_D -ldl"
else # assume Solaris
    OAG_CXXFLAGS="-KPIC"
    OAG_LDADD="-loaBase$OAG_D -loaDM$OAG_D -loaDesign$OAG_D -loaPlugIn$OAG_D \
-loaTech$OAG_D -loaCommon$OAG_D -i -lm -Bdynamic -lsocket -lnsl -lintl -ldl \
-lelf -lrt"
fi

###############################################################################
# External Package: OA
###############################################################################

OAG_USER_CPPFLAGS="$CPPFLAGS"
OAG_USER_CXXFLAGS="$CXXFLAGS"
OAG_USER_LDFLAGS="$LDFLAGS"

if test "$enable_check" ; then
    AC_MSG_CHECKING([OA sysname])
    if test ! "$with_sysname" -a -x "$with_oa/bin/sysname" ; then
	with_sysname=`$with_oa/bin/sysname`
	case "$with_sysname" in
	    linux_rhel21) bits=32 ;;
	    *) bits=64 ;;
	esac
	with_sysname="${with_sysname}_$bits"
    fi
    if test "$with_sysname" ; then
	AC_MSG_RESULT([$with_sysname])
    else
	AC_MSG_RESULT([none])
	AC_MSG_ERROR([could not determine sysname
This means either your compiler could not compile the test program (see
config.log) or OpenAccess is not properly set up in the directory $with_oa
(use --with-oa=DIR and/or --with-sysname to specify OpenAccess directory)])
    fi

    OAG_LIBDIR="$with_oa/lib/$with_sysname/$OAG_LIBOPT"
    OAG_LDFLAGS="-L$OAG_LIBDIR -Wl,-rpath,$OAG_LIBDIR"

    AC_CHECK_FILE([$OAG_LIBDIR/liboaBase$OAG_D.so], ,
	AC_MSG_ERROR([could not find liboaBase$OAG_D.so in $OAG_LIBDIR
Use --with-oa=DIR and/or --with-sysname to specify OpenAccess directory]))

    CPPFLAGS="$OAG_USER_CPPFLAGS"
    CXXFLAGS="$OAG_USER_CXXFLAGS"
    LDFLAGS="$OAG_USER_LDFLAGS"
fi

###############################################################################
# External Package: CUDD
###############################################################################
                                           
if test "$enable_dd" ; then
    if test "$enable_check" ; then
        AC_MSG_NOTICE([CUDD enabled, checking for CUDD])
	AC_CHECK_FILE([$with_cudd/cudd/libcudd.a], ,
            AC_MSG_ERROR([could not find cudd/libcudd.a in $with_cudd
Use --with-cudd=DIR to specify CUDD directory]))
    fi
    AC_SUBST([OAG_CUDD_INCS], ["-I$with_cudd/include"])
    AC_SUBST([OAG_CUDD_LIBS],
	["$with_cudd/cudd/libcudd.a $with_cudd/mtr/libmtr.a \
$with_cudd/st/libst.a $with_cudd/util/libutil.a \
$with_cudd/epd/libepd.a"])
fi

###############################################################################
# External Package: QT
###############################################################################

if test "$enable_bazaar" ; then
    if test "$enable_check" ; then
	AC_MSG_NOTICE([Bazaar enabled, checking for QT in $with_qt])
	AC_CHECK_FILE([$with_qt/include/qglobal.h], ,
	    AC_MSG_ERROR([include/qglobal.h not found in $with_qt
Set the QTDIR environment variable]))
	AC_MSG_CHECKING([QT version])
	CPPFLAGS="$OAG_USER_CPPFLAGS -I$with_qt/include"
	AC_PREPROC_IFELSE([[
#include "qglobal.h"
#if QT_VERSION < 0x030300
#error
#endif
]],
	    AC_MSG_RESULT([>= 3.3.0]),
	    AC_MSG_RESULT([< 3.3.0])
	    AC_MSG_ERROR([QT version too old
Set the QTDIR environment variable to specify a newer QT]))
	AC_PATH_PROG([OAG_QMAKE], [qmake], [""], [$with_qt/bin])
	if test ! "$OAG_QMAKE" ; then
	    AC_MSG_ERROR([bin/qmake not found in $with_qt
Set the QTDIR environment variable])
	fi
	AC_SUBST([OAG_QMAKE], ["$OAG_QMAKE"])

	CPPFLAGS="$OAG_USER_CPPFLAGS"
    fi
fi

###############################################################################
# External Package: TCL
###############################################################################

if test "$enable_bazaar" ; then
    if test "$enable_check" ; then
	AC_MSG_NOTICE([Bazaar enabled, checking for TCL in $with_tcl])
	AC_CHECK_FILE([$with_tcl/tclConfig.sh], ,
	    AC_MSG_ERROR([tclConfig.sh not found in $with_tcl
Use --with-tcl=DIR to specify the directory containing tclConfig.sh]))
	source "$with_tcl/tclConfig.sh"
	AC_MSG_CHECKING([TCL version])
	if test "$TCL_MAJOR_VERSION" -lt "8" -o \
		"$TCL_MAJOR_VERSION" -eq "8" -a \
		"$TCL_MINOR_VERSION" -lt 4 ; then
	    AC_MSG_RESULT([< 8.4])
	    AC_MSG_ERROR([TCL version too old
Use --with-tcl=DIR to specify a newer TCL])
	fi
	AC_MSG_RESULT([>= 8.4])
    fi
    AC_SUBST([OAG_TCL_INCS], ["$TCL_INCLUDE_SPEC"])
    AC_SUBST([OAG_TCL_LIBS], ["$TCL_LIB_SPEC"])
fi

###############################################################################
# External Package: UMPack
###############################################################################

if test "$enable_capo_wrapper" ; then
    if test "$enable_check" ; then
	AC_MSG_NOTICE([Capo Wrapper enabled, checking for UMPack])
	AC_CHECK_FILE([$with_umpack/lib/libCapo.so], ,
	    AC_MSG_ERROR([could not find lib/libCapo.so in $with_umpack
Use --with-umpack=DIR to specify UMpack directory]))
    fi
    AH_TEMPLATE([CAPOWRAPPER])
    AC_DEFINE([CAPOWRAPPER])
    AC_SUBST([OAG_UMPACK_INCS],
	["-I$with_umpack"])
    AC_SUBST([OAG_UMPACK_LIBS],
	["-L$with_umpack/lib -Wl,-rpath,$with_umpack/lib \
-lABKCommon -lPartEvals -lAnalytPl \
-lCtainers -lPartitioners -lSmallPart -lDB -lPartitioning \
-lSmallPlacement -lFilledHier -lMetaPlacer -lPartLegality \
-lSmallPlacers -lFixOr -lMLPart -lPlaceEvals -lStats -lCapo \
-lFMPart -lPlacement -lClusteredHGraph -lGenHier -lNetTopology \
-lRBPlace -lCombi -lGeoms -lParquetDBFromRBP -lRBPlFromDB \
-lGeomTrees -lParquetFP -lCongestionMaps -lHGraph \
-lParserLEFDEF -lRowIroning \
-lConstraints -lHGraphWDims -lShellPart -lPhySyn -lTimeAna \
-ldl"])
    AC_CHECK_FILE([$with_umpack/lib/libHMetis.a],
	AC_SUBST([OAG_UMPACK_OPTIONAL_LIBS],
	["-L$with_umpack/lib -lHMetis -lFlute -lCS2"])
	AC_SUBST([OAG_UMPACK_OPTIONAL_INCS], [""]))
fi

###############################################################################
# External Package: zlib
###############################################################################

if test "$enable_mini_sat" ; then
    if test "$enable_check" ; then
	AC_MSG_NOTICE([MiniSat enabled, checking for zlib])
	CPPFLAGS="-I$with_zlib/include $CPPFLAGS"
	LDFLAGS="-L$with_zlib/lib $LDFLAGS"
	AC_CHECK_LIB(z, gzread,
	    AC_SUBST([OAG_ZLIB_INCS], ["-I$with_zlib/include"])
		    AC_SUBST([OAG_ZLIB_LIBS], ["-L$with_zlib/lib -lz"]),
	    AC_MSG_ERROR([zlib not found in $with_zlib
Use --with-zlib=DIR to specify zlib directory]))
    fi
fi

CPPFLAGS="$OAG_USER_CPPFLAGS"
CXXFLAGS="$OAG_USER_CXXFLAGS"
LDFLAGS="$OAG_USER_LDFLAGS"

###############################################################################
# Set Automake Conditional Flags
###############################################################################

AM_CONDITIONAL([OAG_COND_BAZAAR], [test "$enable_bazaar"])
AM_CONDITIONAL([OAG_COND_DOXYGEN], [test "$OAG_DOXYGEN"])
AM_CONDITIONAL([OAG_COND_DUMMY], [false])

# METAMAKE CONDITIONALS

###############################################################################
# Construct Makefile Substitutions
###############################################################################

AC_SUBST([OAG_D])

AC_SUBST([OAG_OA_INCS], ["$OAG_CPPFLAGS"])
AC_SUBST([OAG_OA_LIBS], ["$OAG_LDFLAGS $OAG_LDADD"])

# For QT we rely on the QTDIR environment variable
# so there are no Makefile substitutions

###############################################################################
# Generate Output Files
###############################################################################

AC_CONFIG_FILES([
])
AC_OUTPUT
