/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#if !defined(oagBufferSimpleInserter_P)
#define oagBufferSimpleInserter_P

#include "oaDesignDB.h"
#include "oagTimerTimer.h"

class oa::oaBlock;
class oa::oaScalarInst;
class oa::oaScalarNet;

namespace oagBuffer {

/// \brief Some simple buffer optimization routines.
///
/// This class uses the OA Gear Timer to estimate the timing impact
/// of buffer insertion.

class SimpleInserter {
  public:
    SimpleInserter(oa::oaBlock      *block,
                   oagTimer::Timer  *timer);
    ~SimpleInserter();

    oa::oaScalarNet *insertBuf(oa::oaScalarInst *inst,
                               oa::oaScalarNet  *net);

    void removeBuf(oa::oaScalarInst* inst);

    void optimalInsert(oa::oaScalarInst *inst,
                       oa::oaScalarNet  *net);

    void optInsToPath(const oa::oaScalarName    lib,
                      const oa::oaScalarName    cell,
                      const oa::oaScalarName    view,
                      oagTimer::nodesSlopeDir   &path);

    double optInsToNet(oa::oaScalarInst *inst,
                       oa::oaNet        *net,
                       double           oldWorstSlack,
                       int              &position,
                       bool             insert);

    void insToNet(oa::oaScalarInst  *inst,
                  oa::oaNet         *net,
                  int               position);

    void sortBySlacks(std::vector<oa::oaOccObject*> &blocks);

  private:
    oa::oaBlock *_block;
    oagTimer::Timer *_timer;

    class SortBySlack;
};

}

#endif
