/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

// Author: David Papa <iamyou@umich.edu>

/****************************************************************************
 ** ui.h extension file, included from the uic-generated form implementation.
 **
 ** If you want to add, delete, or rename functions or slots, use
 ** Qt Designer to update this file, preserving your code.
 **
 ** You should not define a constructor or destructor in this file.
 ** Instead, write your code in functions called init() and destroy().
 ** These will automatically be called by the form's constructor and
 ** destructor.
 *****************************************************************************/

#include <string>

void RunCapoOptionsT::RunCapoButton_clicked()
{
    emit sigRunCapo(optionsEdit->text().ascii());
    done(0);
}


void RunCapoOptionsT::CancelButton_clicked()
{
    done(1);
}


void RunCapoOptionsT::verbCheck_toggled( bool en)
{
    verbosityGroup->setEnabled(en);
    updateOptionsString();
}


void RunCapoOptionsT::updateOptionsString()
{
    std::string capoOptions;

    if(helpCheck->isChecked())
        capoOptions += " -help";

    if(ROOSTERcheck->isChecked())
        capoOptions += " -ROOSTER";    

    if(numCheck->isChecked())
    {
        capoOptions += " -num";
        capoOptions += " ";
        std::string num(numEdit->text().ascii());
        if(num == "")
            num = "1";
        capoOptions += num;
    }

    if(verbCheck->isChecked())
    {
        capoOptions += " -verb ";
        capoOptions += actionsEdit->text().ascii();
        capoOptions += "_";
        capoOptions += resourcesEdit->text().ascii();
        capoOptions += "_";
        capoOptions += statsEdit->text().ascii();
    }

    if(fasterRadio->isChecked())
        capoOptions += " -faster";

    if(tryHarderRadio->isChecked())
        capoOptions += " -tryHarder";

    optionsEdit->setText(QString(capoOptions.c_str()));
}


void RunCapoOptionsT::ROOSTERcheck_clicked()
{
    updateOptionsString();
}


void RunCapoOptionsT::numCheck_clicked()
{
    updateOptionsString();
}


void RunCapoOptionsT::numEdit_textChanged(const QString& str)
{
    //get rid of compiler unused warnings
    static_cast<void>(str);

    updateOptionsString();
}


void RunCapoOptionsT::fasterRadio_clicked()
{
    updateOptionsString();
}


void RunCapoOptionsT::defaultRadio_clicked()
{
    updateOptionsString();
}


void RunCapoOptionsT::tryHarderRadio_clicked()
{
    updateOptionsString();
}


void RunCapoOptionsT::helpCheck_clicked()
{
    updateOptionsString();
}


