/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */
#ifndef PROCESS_MANAGER_H
#define PROCESS_MANAGER_H

#include <deque>

#include <qobject.h>

namespace oagBazaar
{

    class QoagThread;

    class Controller;

    class ProcessManager : public QObject
    {
        Q_OBJECT

        public:
            ProcessManager(Controller* controller, QObject * parent = 0, const char * name = 0 ):
              QObject(parent, name),
              _controller(controller)
            {}

            void insert( QoagThread * process );
            void customEvent( QCustomEvent * e );

            void printQueue(void) const;


        private: //functions
         
           void runNextOnQueue();

        private: //data
            std::deque< QoagThread* > _processes;
            std::deque< QoagThread* > _processQueue;
            Controller* _controller;
    };

}

#endif



