/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */
#include <iomanip>

#include "processManager.h"
#include "oagThread.h"
#include "DebugLog.h"
#include "mainwindow.h"
#include "QoagCommon/QoagEvents.h"

using std::deque;
using std::setw;

namespace oagBazaar
{

    void ProcessManager::insert(QoagThread* process)
    {
        _processQueue.push_back(process);  
        if(_processes.empty())
        {
          runNextOnQueue();
        }
    }

    void ProcessManager::runNextOnQueue()
    {
          if(_processQueue.empty()) return;
          QoagThread* proc = _processQueue.front();
          _processQueue.pop_front();
          _processes.push_back(proc);
          proc->start();
    }

    void ProcessManager::customEvent( QCustomEvent * e )
    {
        if ( e->type() == QEvent::User ) 
        {  
            cout<<"Processing ProcessFinished event"<<endl;
            ProcessFinished* ce = dynamic_cast<ProcessFinished*>(e);
            if(ce)
            {
                void * data = ce->data();
                QoagThread* thread = (QoagThread*)(data);
                if(!thread) return;  
                thread->finished();
                deque<QoagThread*>::iterator new_end = std::remove(_processes.begin(), _processes.end(), thread);
                _processes.erase(new_end, _processes.end());
                runNextOnQueue();
            }
           
            Qoag::PlacementFinished* pe = dynamic_cast<Qoag::PlacementFinished*>(e);
            if(pe)
            {
               void * data = pe->data();
               std::vector<std::string>* design_name = (std::vector<std::string>*)(data);
               if(!design_name) return;  
               if(design_name->size() != 3) return;
               MainWindow& mainwindow = _controller->getView();
               mainwindow.placedLayout((*design_name)[0], (*design_name)[1], (*design_name)[2]);
            }
            Qoag::PlacementStarted* ps = dynamic_cast<Qoag::PlacementStarted*>(e);
            if(ps)
            {
               void * data = ps->data();
               std::vector<std::string>* design_name = (std::vector<std::string>*)(data);
               if(!design_name) return;  
               if(design_name->size() != 3) return;
               MainWindow& mainwindow = _controller->getView();
               mainwindow.placingLayout((*design_name)[0], (*design_name)[1], (*design_name)[2]);
            }
            Qoag::PlacementEnqueued* pnq = dynamic_cast<Qoag::PlacementEnqueued*>(e);
            if(pnq)
            {
            }
            Qoag::PlacementDequeued* pdq = dynamic_cast<Qoag::PlacementDequeued*>(e);
            if(pdq)
            {
            }
        }
    }
    
    void ProcessManager::printQueue(void) const
    {
        cout<<"Current jobs running:"<<endl;
        unsigned i=1;
        for(deque<QoagThread*>::const_iterator it = _processes.begin(); it != _processes.end(); ++it)
        { 
          cout<<setw(3)<<(i++)<<" : ";
          (*it)->print();
        }
        cout<<"Current jobs queued:"<<endl;
        i=1;
        for(deque<QoagThread*>::const_iterator it = _processQueue.begin(); it != _processQueue.end(); ++it)
        { 
          cout<<setw(3)<<(i++)<<" : ";
          (*it)->print();
        }
    }

}


