/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

// Author: David Papa <iamyou@umich.edu>

/*! \file openDesignForm.ui.h */

/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include <vector>
#include <iostream>


#include "oaUtils.h"

void openDesignFormT::loadDesign()
{
  emit sigDesignLoad();
  close();
}

void openDesignFormT::init()
{
    connect(libComboBox, SIGNAL(activated(const QString&)), this, SLOT(libChanged(const QString&)));
    connect(cellComboBox, SIGNAL(activated(const QString&)), this, SLOT(cellChanged(const QString&)));
 
    readLibs();

    
}


void openDesignFormT::libChanged(const QString& libNameQ)
{
    cellComboBox->clear();
    viewComboBox->clear();
    //std::cout<<"Got lib changed"<<std::endl;
    std::string libName = libNameQ.ascii();
    oa::oaNativeNS ns;
    oa::oaScalarName libScalarName(ns, libName.c_str());
    oa::oaLib* lib = oa::oaLib::find(libScalarName);
    oa::oaBoolean haveAccess=false;
    if(lib)
    {
        haveAccess=lib->getAccess(oa::oacReadLibAccess);
    }
    else
    {
        std::cout<<"Warning: Couldnt find lib: \""<<libName<<"\""<<std::endl;
        cellComboBox->clear();
        viewComboBox->clear();
    }
    
    if(haveAccess)
    {
      
      std::vector<std::string> cellList = oagBazaar::getCellNamesInLib(lib);
      //std::cout<<"Found lib: \""<<libName<<"\" has "<<cellList.size()<<" cells."<<std::endl;
      for(unsigned i = 0 ; i < cellList.size(); ++i)
        cellComboBox->insertItem(QString(cellList[i].c_str()));
      if(cellList.size())
        cellChanged(QString(cellList[0].c_str()));
      lib->releaseAccess();
    }
    else
    {
        std::cout<<"Warning: Couldnt get read access to lib: \""<<libName<<"\""<<std::endl;
        cellComboBox->clear();
        viewComboBox->clear();
    }
}



void openDesignFormT::cellChanged( const QString & cellNameQ )
{
    viewComboBox->clear();
    //std::cout<<"Got cell changed"<<std::endl;
    std::string cellName = cellNameQ.ascii();
    oa::oaNativeNS ns;
    oa::oaScalarName cellScalarName(ns, cellName.c_str());
    QString libNameQ = libComboBox->currentText();
    std::string libName = libNameQ.ascii();
    oa::oaScalarName libScalarName(ns, libName.c_str());
    oa::oaLib* lib = oa::oaLib::find(libScalarName);
    oa::oaBoolean haveAccess=false;
    if(lib)
    {
        haveAccess=lib->getAccess(oa::oacReadLibAccess);
    }
    else
    {
        std::cout<<"Warning: Couldnt find lib: \""<<libName<<"\""<<std::endl;
        cellComboBox->clear();
        viewComboBox->clear();
    }
    
    if(haveAccess)
    {
             oa::oaCell* selectedCell = oa::oaCell::find(lib, cellScalarName);
             std::vector<std::string> viewList = oagBazaar::getCellViewNames(selectedCell);
             //std::cout<<"Found cell: \""<<cellName<<"\" has "<<viewList.size()<<" views."<<std::endl;
              for(unsigned i = 0 ; i < viewList.size(); ++i)
           viewComboBox->insertItem(QString(viewList[i].c_str()));
             lib->releaseAccess();
    }
    else
    {
        std::cout<<"Warning: Couldnt get read access to lib: \""<<libName<<"\""<<std::endl;
        cellComboBox->clear();
        viewComboBox->clear();
    }   
}


void openDesignFormT::readLibs()
{
    //std::cout<<"Reading libs..."<<std::endl;
    std::vector<std::string> libList  = oagBazaar::walkLibDefList(oa::oaLibDefList::getTopList());
    libComboBox->clear();
    for(unsigned i = 0; i < libList.size(); ++i)
        libComboBox->insertItem(QString(libList[i].c_str()));
    
    if(!libList.empty())
    {
    //hack to make "designs" default if it exists
    unsigned designsIdx = 0;
    for(unsigned i = 0; i < libList.size(); ++i)
        if(libList[i] == "designs")
            designsIdx = i;
    libComboBox->setCurrentItem(designsIdx);
    libChanged(QString(libList[designsIdx].c_str()));
    }
}
