/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */
#ifndef _OAG_THREAD_H_
#define _OAG_THREAD_H_

#include <qthread.h>
#include <qevent.h>


namespace oagBazaar
{
    class ProcessManager;

    class ProcessFinished : public QCustomEvent
    {
       public:
          ProcessFinished(void* data) : QCustomEvent(QEvent::User, data) { }
    };

    class QoagThread : public QThread
    {
        public:

            virtual void finish() = 0; 
            virtual void print() const { }

            virtual void setProcessManager(ProcessManager* processManager);

        protected: //data

            ProcessManager* _processManager;

    };

}

#endif




