/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
 */

/*! \file oagConnect.h */

#ifndef OPENACCESS_CONNECT_H
#define OPENACCESS_CONNECT_H

#include "oaDesignDB.h"
#include <string>

namespace oagBazaar
{

    ///A simple struct that contains an oaDesign and a oaBlock
    /** This class is intended to make it easier to pass around design objects
      with a corresponding top block.  Since these two entities are used together
      and passed around often, using this class makes interfaces cleaner.
     */
    struct oagDesignBlock
    {
        oa::oaBlock* block;
        oa::oaDesign* design;
    };

    /// Encapsulates a connection to the OpenAccess Database
    class oagConnection
    {
        public:
            oagConnection(std::string Lib, std::string Cell, std::string View);
            ~oagConnection(void);
            oagDesignBlock getOAGDesignBlock(void); 
            oa::oaBlock* getBlock(void) { return _block; }
            oa::oaDesign* getDesign(void) { return _des; }
            const oa::oaBox& getCoreRegionBBox();
            std::string getLibName() { return _Lib; }
            std::string getCellName() { return _Cell; }
            std::string getViewName() { return _View; }

            void getWriteAccess(void);

        private: //functions
            ///private copy constructor prevents duplication
            oagConnection(const oagConnection& src); //no implementation provided

        private: //data
            std::string _Lib, _Cell, _View;
            oa::oaBlock* _block;
            oa::oaDesign* _des;
            oa::oaBox* _coreRegionBBox; 
    };

}

#endif


