/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2005-11-07: ChangeLog started
 */

/*! \file oaUtils.h */ 

#ifndef _OAUTILS_H_
#define _OAUTILS_H_

#include <vector>
#include <string>

#include "oaDesignDB.h"

namespace oagBazaar
{

    /** \fn std::vector<std::string> walkLibDefList(oa::oaLibDefList *list)
     *  \brief return a list of library names that are in the oaLibDefList list 
     *
     *  \param list The oaLibDefList to search.
     */
    std::vector<std::string> walkLibDefList(oa::oaLibDefList *list);

    /** \fn std::vector<std::string> getCellNamesInLib(const oa::oaLib* lib)
     *  \brief return a list of cell names that are defined in an oaLib
     *
     *
     *  \param lib The oaLib to search.
     */
    std::vector<std::string> getCellNamesInLib(const oa::oaLib* lib);

    /** \fn std::vector<std::string> getCellViewNames(const oa::oaCell* cell)
     *  \brief return a list of view names that are defined for an oaCell
     *
     *  \param cell The oaCell to search
     */
    std::vector<std::string> getCellViewNames(const oa::oaCell* cell);

}

#endif


