/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/


/*! \file mainwindow.h */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <qmainwindow.h>
#include <qwidgetlist.h>
#include <string>
#include <map>
#include "LayoutView/LayoutViewWnd.h"
#include "SchemInstView/SchemInstViewWnd.h"
#include "saveDesignAsForm.h"
#include "openDesignForm.h"
#include "openSchemForm.h"
#include "openOADB.h"
#include "loadPlugIn.h"
#include "oagConnect.h"
#include "Controller/controller.h"
#include "dockingCommandWindow.h"

class QAction;
class QLabel;
class QWorkspace;

/** \namespace oagBazaar
 *  \brief Namespace for OAGear Bazaar
 */
namespace oagBazaar
{

    ///A Qt QMainWindow object that represents OAGear Bazaar's View object of the Model-View-Controller design pattern
    class MainWindow : public QMainWindow
    {
        Q_OBJECT
        public:
            MainWindow(QWidget *parent, const char *name, Controller& controllerIn);
            QWorkspace* getWorkspace(void) { return workspace; }

            void loadSchematic(const std::string& lib, const std::string& cell, const std::string& view);
            void loadLayout(oagConnection* dbConnection);
            commandWindowT* getCommandWindow(void);

            //PlugIn API functions
            QPopupMenu* addMenu(const std::string& name);
            QPopupMenu* addMenu(const std::string& iconName, const std::string& name);
            QToolBar* addToolBar(const std::string& name);
            void takeWidget(QWidget* widget);
            void takeDialog(QDialog* dialog);
            void takeThread(QoagThread* dialog);
            void registerCommand(Tcl_CmdProc* cmd, const std::string& cmdName, ClientData clientData=0, Tcl_CmdDeleteProc *deleteProc = 0);
            void registerAction(const std::string& command, QAction* action);
            void getActiveDesign(std::string& library, std::string& cell, std::string& view) const;
            //end PlugIn API functions

        public slots:
            void newFile();
            void openFile(const std::string &fileName);
            void loadLayout(void);
            void loadSchematic(void);
            void doSaveAs(void);
            void closeActiveWindow();
            void placingLayout(const std::string& lib, const std::string& cell, const std::string view);
            void placedLayout(const std::string& lib, const std::string& cell, const std::string view);
            void loadLibraryDefinitionFile(const std::string& fileName);
            void loadPlugInFile(const std::string& fileName);
            void runCommand(QAction*);
            void runCommand(const std::string& command);

        protected:
            void closeEvent(QCloseEvent *event);

        private slots:
            void open();
            void openSchem();
            void openOADB();
            void loadPlugIn();
            void save();
            void saveAs();
            void cut();
            void copy();
            void paste();
            void del();
            void about();
            void updateMenus();
            void activateWindow(int param);
            void copyAvailable(bool available);
            void updateModIndicator();
            void zoomIn();
            void zoomOut();

        private:
            void createActions(void);
            void createMenus(void);
            void createWindowsMenu(void);
            void createToolBars(void);
            void createStatusBar(void);
            void createCommandWindow(void);

            LayoutViewWnd* createLayoutViewWnd(oagConnection* dbConnection);
            LayoutViewWnd* activeLayoutViewWnd();
            Qoag::QoaSCVScrollingFrame* createSchematic(const std::string& lib, const std::string& cell, const std::string& view);
            ///Returns a pointer to the LayoutViewWnd whose contents matches lib/cell/view or (LayoutViewWnd*)(0) if no such child widget exists
            LayoutViewWnd* getLayoutWnd(const std::string& lib, const std::string& cell, const std::string view);

            QWorkspace *workspace;
            QLabel *readyLabel;
            QLabel *modLabel;
            QWidgetList windows;
            openDesignFormT* openDialog;
            saveDesignAsFormT* saveAsDialog;
            openSchematicFormT* openSchemDialog;
            openOADBForm* openOADBDialog;
            loadPlugInFormT* loadPlugInDialog;
            QoaCommandDockWindow* bottomDockCommandWindow;

            QPopupMenu *fileMenu;
            //QPopupMenu *editMenu;
            QPopupMenu *viewMenu;
            QPopupMenu *placeMenu;
            QPopupMenu *windowsMenu;
            QPopupMenu *helpMenu;
            QToolBar *fileToolBar;
            QToolBar *editToolBar;
            //QAction *newAct;
            QAction *openLayoutAct;
            QAction *openSchemAct;
            QAction *openOADBAct;
            QAction *loadPlugInAct;
            QAction *saveAct;
            QAction *saveAsAct;
            QAction *exitAct;
            QAction *cutAct;
            QAction *copyAct;
            QAction *pasteAct;
            QAction *deleteAct;
            QAction *closeAct;
            QAction *closeAllAct;
            QAction *tileAct;
            QAction *cascadeAct;
            QAction *nextAct;
            QAction *previousAct;
            QAction *aboutAct;
            QAction *aboutQtAct;
            QAction *zoomInAct;
            QAction *zoomOutAct;
            QAction *runSchemAct;

            std::map<QAction*, std::string> _actionToCommand;

            Controller& controller;
    };

}

#endif


