/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

/*! \file dockingCommandWindow.h */

#ifndef COMMANDWINDOWT_H
#define COMMANDWINDOWT_H

#include <qvariant.h>
#include <qwidget.h>
#include <qdockwindow.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <sstream>
#include <iostream>
#include "Controller/controller.h"

using std::cout;
using std::endl;
using std::cerr;

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QLineEdit;

namespace oagBazaar
{

    ///A Qt QWidget object that encapsulates a command line window
    class commandWindowT : public QWidget
    {
        Q_OBJECT
        public:

            ///Construct a commandWindowT object with specified Controller.
            commandWindowT( QWidget* parent, Controller& controller, const char* name = 0, WFlags fl = 0 );

            ///Get the rdbuf of the command log 
            /** 
             * This function is useful for redirecting stdout and stderr into the command window log.
             */
            std::stringbuf* log_rdbuf(){ return log.rdbuf(); }   

            ///Take the stream from DebugLog and echo it into log.
            void echoDebugStream(void);

signals:
            virtual void serviceCommand(void);

            public slots:
                virtual void execute(void);
            virtual void refresh(void);

        protected:
            ///The log of commands and their output.
            std::ostringstream log;

            protected slots:
                void languageChange(void);

        private:
            ///Print the contents of str to the log.
            void echo(const std::string& str);

            ///Refresh the contents of logTextEdit from the log stream.
            void drawLog(void);

            ///The Controller that interprets commands.
            Controller& _controller;

            ///The log of commands and their output.
            QTextEdit* logTextEdit;

            ///The LineEdit box to type a command into.
            QLineEdit* commandLineEdit;

            ///The button to push when finished typing a command to execute it.
            QPushButton* sendCommandButton;
    };

    ///The Qt QDockWindow object that makes a commandWindowT a docking command line window.
    class QoaCommandDockWindow : public QDockWindow
    {
        public:
            ///Construct a QoaCommandDockWindow with specified Controller.
            QoaCommandDockWindow(QWidget* parent, Controller& controller);

            ///Get the command window that is contained in this QoaCommandDockWindow.
            commandWindowT* getCommandWindow(void){ return _cwnd;}
        protected:

            ///Set the command window that is contained in this QoaCommandDockWindow.
            void setCommandWindow(commandWindowT* cwnd){ _cwnd=cwnd; }

        private:
            ///The command window that is contained in this QoaCommandDockWindow.
            commandWindowT* _cwnd;
    };

}

#endif // COMMANDWINDOWT_H


