/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

/*! \file QoagCommonTempl.h */

#ifndef _Q_OA_COMMON_TEMPL_
#define _Q_OA_COMMON_TEMPL_

#include <string>
#include "oaBase.h"
#include "oaDesignDB.h"

namespace oagBazaar
{

    namespace Qoag
    {
        ///Templated function to get a std::string object from an OpenAccess object
        /**
         * 
         *  i->getName() must be defined.
         */
        template <typename T> 
            std::string getNameFromOA(T i)
            {
                oa::oaNativeNS ns;
                oa::oaString name;
                i->getName(ns,name);
                return std::string(static_cast<const char*>(name) );
            }

        ///Templated function to get a std::string object from an OpenAccess object
        /**
         * \overload
         * Specialized template function to get a std::string object from an oaDesign object
         */
        template <> 
            std::string getNameFromOA<oa::oaDesign*>(oa::oaDesign* i);

    }; //end namespace Qoag

} //end namespace oagBazaar

#endif

