/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/


#include <iostream>
#include <vector>
#include <string>
#include <iomanip>

#include "simulatorPlugIn.h"
#include "SimEqui/oagResynUserIntf.h"

void SimulationDataTableT::init(void)
{
    _simulatorPI = 0;
    _simulator = 0;
}

void SimulationDataTableT::setSimulatorPI( SimulatorPlugIn * simulatorPI)
{
 _simulatorPI = simulatorPI;
}



void SimulationDataTableT::doNextCycleClicked()
{
   _simulator->step();

   std::vector<oa::oaNet*> outputs;
   _simulator->getOutputs(outputs);
   std::vector<std::string> outputValues(outputs.size());
       oagResyn::simulatorInterface::SimulationVector simulationValue;
       for(unsigned  i = 0; i < outputs.size(); ++i)
       {
           _simulator->getVector(outputs[i], simulationValue);
           std::stringstream num;
           num  << std::setfill('0') << std::setw(8) << std::hex << simulationValue;
           outputValues[i] += num.str();
       }

   for(unsigned  i = 0; i < outputs.size(); ++i)
   {
      simulationData->setText(i, 1, 
             QString(
               (
                    std::string(simulationData->text(i, 1).ascii())+outputValues[i]
               )
                                         
                     .c_str()
          
              )
         );
   }
   simulationData->adjustColumn(1);

}




void SimulationDataTableT::setSimulator( oagResyn::simulatorInterface * simulator )
{
     _simulator = simulator;
}
