/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

/*! \file LayoutInstView.h */

#ifndef SIMILARITY_LAYOUT_INST_VIEW_H
#define SIMILARITY_LAYOUT_INST_VIEW_H

#include <qframe.h>
#include <qpainter.h>
#include <qgl.h>
#include <vector>
#include "oaDesignDB.h"

namespace oagBazaar
{

#define STD_CELL_FILL_COLOR_B 128,0,128

    ///A Qt QGLWidget gui object that represents a circuit layout
    class glSimilarityLayoutWidget: public QGLWidget
    {
        Q_OBJECT
        public:
            glSimilarityLayoutWidget(QWidget* parent, const oa::oaBox& coreRegion);
            void addInst(const oa::oaBox&, int color = 0);
            void clear(void){ _insts.clear(); _coreRegion=oa::oaBox(); }
            void resizeGL(double zoom);
            void resizeCR(const oa::oaBox&);
            void initializeGL();
            void paintGL();
            void setZoom(double zoom);
            double getZoom(void) {return _zoom;}

        private:
            void draw();
            void draw_test_pattern();


            std::vector< oa::oaBox > _insts;
            std::vector< int > _inst_colors;
            oa::oaBox _coreRegion;
            double _zoom;
    };

}

#endif


