/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

// Author: David Papa <iamyou@umich.edu>

/****************************************************************************
 ** ui.h extension file, included from the uic-generated form implementation.
 **
 ** If you want to add, delete, or rename functions or slots, use
 ** Qt Designer to update this file, preserving your code.
 **
 ** You should not define a constructor or destructor in this file.
 ** Instead, write your code in functions called init() and destroy().
 ** These will automatically be called by the form's constructor and
 ** destructor.
 *****************************************************************************/

#include <string>
#include <iostream>
#include <vector>
#include "oaDesignDB.h"
#include "../../oaUtils.h"


void RunCapoOptionsPIT::init()
{
    connect(libComboBox, SIGNAL(activated(const QString&)), this, SLOT(libChanged(const QString&)));
    connect(cellComboBox, SIGNAL(activated(const QString&)), this, SLOT(cellChanged(const QString&)));

//    oa::oaDesignInit();
//    oa::oaLibDefList::openLibs();

    readLibs();


}

void RunCapoOptionsPIT::libChanged(const QString& libNameQ)
{
    try
    {
        cellComboBox->clear();
        viewComboBox->clear();
        std::cout<<"Got lib changed"<<std::endl;
        std::string libName = libNameQ.ascii();
        oa::oaNativeNS ns;
        oa::oaScalarName libScalarName(ns, libName.c_str());
        oa::oaLib* lib = oa::oaLib::find(libScalarName);
        oa::oaBoolean haveAccess=false;
        if(lib)
        {
            haveAccess=lib->getAccess(oa::oacReadLibAccess);
        }
        else
        {
            std::cout<<"Warning: Couldnt find lib: \""<<libName<<"\""<<std::endl;
            cellComboBox->clear();
            viewComboBox->clear();
        }

        if(haveAccess)
        {

            std::vector<std::string> cellList = oagBazaar::getCellNamesInLib(lib);
            //std::cout<<"Found lib: \""<<libName<<"\" has "<<cellList.size()<<" cells."<<std::endl;
            for(unsigned i = 0 ; i < cellList.size(); ++i)
                cellComboBox->insertItem(QString(cellList[i].c_str()));
            cellChanged(QString(cellList[0].c_str()));
            lib->releaseAccess();
        }
        else
        {
            std::cout<<"Warning: Couldnt get read access to lib: \""<<libName<<"\""<<std::endl;
            cellComboBox->clear();
            viewComboBox->clear();
        }
    }
    catch (oa::oaException &e) 
    {
        std::cerr << "ERROR: " << e.getMsg() << std::endl;
    }
}



void RunCapoOptionsPIT::cellChanged( const QString & cellNameQ )
{
    try
    {
        viewComboBox->clear();
        std::cout<<"Got cell changed"<<std::endl;
        std::string cellName = cellNameQ.ascii();
        oa::oaNativeNS ns;
        oa::oaScalarName cellScalarName(ns, cellName.c_str());
        QString libNameQ = libComboBox->currentText();
        std::string libName = libNameQ.ascii();
        oa::oaScalarName libScalarName(ns, libName.c_str());
        oa::oaLib* lib = oa::oaLib::find(libScalarName);
        oa::oaBoolean haveAccess=false;
        if(lib)
        {
            haveAccess=lib->getAccess(oa::oacReadLibAccess);
        }
        else
        {
            std::cout<<"Warning: Couldnt find lib: \""<<libName<<"\""<<std::endl;
            cellComboBox->clear();
            viewComboBox->clear();
        }

        if(haveAccess)
        {
            oa::oaCell* selectedCell = oa::oaCell::find(lib, cellScalarName);
            std::vector<std::string> viewList = oagBazaar::getCellViewNames(selectedCell);
            //std::cout<<"Found cell: \""<<cellName<<"\" has "<<viewList.size()<<" views."<<std::endl;
            for(unsigned i = 0 ; i < viewList.size(); ++i)
                viewComboBox->insertItem(QString(viewList[i].c_str()));
            lib->releaseAccess();
        }
        else
        {
            std::cout<<"Warning: Couldnt get read access to lib: \""<<libName<<"\""<<std::endl;
            cellComboBox->clear();
            viewComboBox->clear();
        }   
    }
    catch (oa::oaException &e) 
    {
        std::cerr << "ERROR: " << e.getMsg() << std::endl;
    }
}


void RunCapoOptionsPIT::readLibs()
{
    try
    {
        oa::oaLibDefList * ldl = oa::oaLibDefList::getTopList();
        std::vector<std::string> libList  = oagBazaar::walkLibDefList(ldl);
        libComboBox->clear();
        for(unsigned i = 0; i < libList.size(); ++i)
            libComboBox->insertItem(QString(libList[i].c_str()));

        if(!libList.empty())
        {
            //hack to make "designs" default if it exists
            unsigned designsIdx = 0;
            for(unsigned i = 0; i < libList.size(); ++i)
                if(libList[i] == "designs")
                    designsIdx = i;
            libComboBox->setCurrentItem(designsIdx);
            libChanged(QString(libList[designsIdx].c_str()));
        }
    }
    catch (oa::oaException &e) 
    {
        std::cerr << "ERROR: " << e.getMsg() << std::endl;
    }
}


void RunCapoOptionsPIT::RunCapoButton_clicked()
{
    std::string cmd;
    cmd += "capo ";
    cmd += libComboBox->currentText().ascii();
    cmd += " ";
    cmd += cellComboBox->currentText().ascii();
    cmd += " ";
    cmd += viewComboBox->currentText().ascii();
    cmd += " ";
    cmd += optionsEdit->text().ascii();
    emit sigRunCapo(cmd);
    done(0);
}


void RunCapoOptionsPIT::CancelButton_clicked()
{
    done(1);
}


void RunCapoOptionsPIT::verbCheck_toggled( bool en)
{
    verbosityGroup->setEnabled(en);
    updateOptionsString();
}


void RunCapoOptionsPIT::updateOptionsString()
{
    std::string capoOptions;

    if(helpCheck->isChecked())
        capoOptions += " -help";

    if(ROOSTERcheck->isChecked())
        capoOptions += " -ROOSTER";    

    if(numCheck->isChecked())
    {
        capoOptions += " -num";
        capoOptions += " ";
        std::string num(numEdit->text().ascii());
        if(num == "")
            num = "1";
        capoOptions += num;
    }

    if(verbCheck->isChecked())
    {
        capoOptions += " -verb ";
        capoOptions += actionsEdit->text().ascii();
        capoOptions += "_";
        capoOptions += resourcesEdit->text().ascii();
        capoOptions += "_";
        capoOptions += statsEdit->text().ascii();
    }

    if(fasterRadio->isChecked())
        capoOptions += " -faster";

    if(tryHarderRadio->isChecked())
        capoOptions += " -tryHarder";

    optionsEdit->setText(QString(capoOptions.c_str()));
}


void RunCapoOptionsPIT::ROOSTERcheck_clicked()
{
    updateOptionsString();
}


void RunCapoOptionsPIT::numCheck_clicked()
{
    updateOptionsString();
}


void RunCapoOptionsPIT::numEdit_textChanged(const QString& str)
{
    //get rid of compiler unused warnings
    static_cast<void>(str);

    updateOptionsString();
}


void RunCapoOptionsPIT::fasterRadio_clicked()
{
    updateOptionsString();
}


void RunCapoOptionsPIT::defaultRadio_clicked()
{
    updateOptionsString();
}


void RunCapoOptionsPIT::tryHarderRadio_clicked()
{
    updateOptionsString();
}


void RunCapoOptionsPIT::helpCheck_clicked()
{
    updateOptionsString();
}

int findComboBoxItem(const QComboBox* box, const QString& str)
{
    for(int i = 0; i < box->count(); ++i)
    {
        if(box->text(i) == str)
            return i;
    }
    return -1;
}

void RunCapoOptionsPIT::setActiveDesign( const QString & lib, const QString & cell, const QString & view )
{
    int libLoc = findComboBoxItem(libComboBox, lib),
        cellLoc =findComboBoxItem(cellComboBox, cell),
        viewLoc = findComboBoxItem(viewComboBox, view);
    if(  libLoc != -1 && cellLoc != -1 && viewLoc != -1)
    {
        libComboBox->setCurrentItem(libLoc);
        cellComboBox->setCurrentItem(cellLoc);
        viewComboBox->setCurrentItem(viewLoc);
    }
}
