/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */
#ifndef _PLACE_THREAD_PI_H
#define _PLACE_THREAD_PI_H

#include <qthread.h>
#include <qevent.h>

#include "oagThread.h"

class ProcessManager;

    class CapoPIThread : public oagBazaar::QoagThread
    {

        public:

            CapoPIThread(std::string Lib, std::string Cell, std::string View, 
                       int argc, const char** argv);
            ~CapoPIThread(void);

            virtual void run(void);

            virtual void finish(void);
 
            virtual void print(void) const;

            std::string getLib(void) const { return _lib; }
            std::string getCell(void) const { return _cell; }
            std::string getView(void) const { return _view; }


        private:

            std::string _lib;
            std::string _cell;
            std::string _view;

            int _argc;
            char ** _argv;


    };

#endif




