/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */


#include <qapplication.h>

#include <config.h>

#include "oagConnect.h"
#include "PlacerInterface.h"
#include "placeThread.h"
#include "processManager.h"
#include "QoagCommon/QoagEvents.h"


#include <iostream>
#include <vector>
#include <string>

using std::cerr;
using std::endl;
using std::string;
using std::vector;


    CapoPIThread::CapoPIThread(std::string Lib, std::string Cell, std::string View,
            int argc, const char** argv): 
        _lib(Lib), _cell(Cell), _view(View), _argc(argc) 
    { 
        //need to store a local copy of argv, because it will be deleted soon
        _argv = new char *[argc];
        for(int i = 0; i < argc; ++i)
        {
            const unsigned len = strlen(argv[i]) + 1;
            _argv[i] = new char[len];
            strcpy(_argv[i], argv[i]);
        } 
        //vector<string> * design_name = new vector<string>(3);
        //(*design_name)[0] = _lib;
        //(*design_name)[1] = _cell;
        //(*design_name)[2] = _view;
        //QApplication::postEvent(   _processManager,  new oagBazaar::Qoag::PlacementEnqueued(design_name));
        //delete design_name;
    }

    CapoPIThread::~CapoPIThread(void)
    {
      for(int i = 0; i < _argc; ++i) {
        delete [] _argv[i];
      }
      delete [] _argv;
    }

    void CapoPIThread::run(void)
    {
        vector<string> * design_name = new vector<string>(3);
        (*design_name)[0] = _lib;
        (*design_name)[1] = _cell;
        (*design_name)[2] = _view;
        //QApplication::postEvent(   _processManager,  new oagBazaar::Qoag::PlacementDequeued(design_name));
        try
        {
            QApplication::postEvent(   _processManager,  new oagBazaar::Qoag::PlacementStarted(design_name));
            place(_lib, _cell, _view, _argc, const_cast<const char**>(_argv));
        }
        catch(...)
        {
            cerr<<"Placement failed, ignoring and continuing..."<<endl; 
            QApplication::postEvent( _processManager, new oagBazaar::ProcessFinished(this) );
            return;
        }

        std::cout<<"Capo finished!"<<std::endl;
        std::cout<<"Posting event ProcessFinished"<<std::endl;
        QApplication::postEvent(   _processManager,  new oagBazaar::ProcessFinished(this));

        QApplication::postEvent(   _processManager,  new oagBazaar::Qoag::PlacementFinished(design_name));
        delete design_name;
        return;
    }

    void CapoPIThread::finish(void)
    {
        //oagConnection dbConnection(_lib, _cell, _view);
        //oagDesignBlock oaDBlk = dbConnection.getOAGDesignBlock();
        //oaDBlk.design->save();
    }

    void CapoPIThread::print(void) const
    {
       for(int i = 0; i < _argc; ++i) {
         std::cout<<_argv[i]<<" ";
       }
       std::cout<<std::endl;
    }


