/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2005-10-19: ChangeLog started
*/

/*! \file DebugLog.h */

#ifndef _DEBUGLOG_H_
#define _DEBUGLOG_H_

#include <ostream>
#include <sstream>

namespace oagBazaar
{

    class commandWindowT;

    ///A singleton that stores data printed to a special debug output stream.
    /** Use this class by writing DebugLog::ostream() << "My debug message." << endl;
     * The data in the log is owned by the commandWindowT class
     * and this is why it is a friend, but the seperate singleton class
     * is necessary for the desired interface.  Currently the stream data is only accessable
     * to the user through the command line, by using the command echo_debug_log.
     */
    class DebugLog
    {
        friend class commandWindowT;

        public:
        ///Get an std::ostream object that represents the debug output stream
        /**
         * ostream() is a static public member function and is supposed to comprise the entire
         * DebugLog interface.  This function exists to create the desired interface to a 
         * debug stream which is owned by the commandWindowT class.
         */
        static std::ostream& ostream(void);

        ///Destructor that deletes the singleton _impl pointer
        ~DebugLog();

        private:
        ///Static function get returning pointer to self for singleton implementation
        static DebugLog * get(void);

        ///Static private pointer to self for singleton implementation
        static DebugLog * _impl;

        ///private default constructor, only get() can use it 
        DebugLog() {}

        ///private copy constructor, only get() can use it 
        DebugLog(const DebugLog& dblog) 
        {
           static_cast<void>(dblog);
        }

        ///debug output stream
        std::ostringstream log;

    };

}

#endif


