/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */
#ifndef _TCLCOMMANDS_H_
#define _TCLCOMMANDS_H_

/*! \file tclCommands.h */

#include <tcl.h>
#include "config.h"

namespace oagBazaar
{

    ///A function that registers all custom TCL functions with the given interpreter
    void registerTclCommands(Tcl_Interp *interp);

    ///A function that takes a particular TCL CmdProc and registers it using the given interpreter and command name
    void registerTCLCommand(Tcl_Interp* interp, Tcl_CmdProc* cmd, const std::string& cmdName, ClientData clientData=0, Tcl_CmdDeleteProc *deleteProc = 0);



    ///The implementation of the library_definition_file TCL command which reads from a lib.defs file
    int library_definition_file(ClientData clientData,
            Tcl_Interp *interp,
            int argc,
            CONST char *argv[]);

    ///The implementation of the echo_debug_log TCL command which reads echos the contents of the DebugLog on the command line
    int echo_debug_log(ClientData clientData,
            Tcl_Interp *interp,
            int argc,
            CONST char *argv[]);

    ///The implementation of the load_layout TCL command which creates a new LayoutView window
    int load_layout(ClientData clientData,
            Tcl_Interp *interp,
            int argc,
            CONST char *argv[]);

    ///The implementation of the load_layout TCL command which creates a new SchemInstView window
    int load_schematic(ClientData clientData,
            Tcl_Interp *interp,
            int argc,
            CONST char *argv[]);

    ///The implementation of the print_job_queue TCL command which prints the jobs waiting in the ProcessManager's queue
    int print_job_queue(ClientData clientData,
            Tcl_Interp *interp,
            int argc,
            CONST char *argv[]);

    ///The implementation of the save TCL command which saves an oaDesign object
    int save(ClientData clientData, 
            Tcl_Interp *interp,
            int argc, 
            CONST char *argv[]);

    ///The implementation of the save_as TCL command which saves an oaDesign object with a specified name
    int save_as(ClientData clientData, 
            Tcl_Interp *interp,
            int argc, 
            CONST char *argv[]);

#ifdef CAPOWRAPPER
    ///The implementation of the capo TCL command which runs the capo placer
    int capo(ClientData clientData,
            Tcl_Interp *interp,
            int argc,
            CONST char *argv[]);
#endif

    int load_plugin(ClientData clientData,
            Tcl_Interp *interp,
            int argc,
            CONST char* argv[]);

}


#endif



