# Implementation along the lines of
# Chinnery, Keutzer, 2005
# This implementation is not tested, nor validated.

proc makeOptionsLPA { } {
    set options [list]
    foreach_in_collection iCell [get_cells] {
        if {[get_property $iCell is_sequential] == "false"} {
            set gname [get_property $iCell hierarchical_name]
            set iPin [getOutputPin $gname]
            set phname [get_property $iPin hierarchical_name]

            set cellname0 [get_property $iCell ref_lib_cell_name]
            set sr0 [get_property $iPin slack_max_rise]
            set sf0 [get_property $iPin slack_max_fall]
            set leak0 [getLeakagePowerLibCell $cellname0]
            
            if { ( $sr0 != "INFINITY" ) && 
                 ( $sf0 != "INFINITY" ) &&
                 ( $sr0 != "NA" ) &&
                 ( $sf0 != "NA" ) } {
                downsize $gname
                set cellnameN [get_property $iCell ref_lib_cell_name]
                if { $cellname0 != $cellnameN } {
                    set srN [get_property $iPin slack_max_rise]
                    set sfN [get_property $iPin slack_max_fall]
                    set leakN [getLeakagePowerLibCell $cellnameN]
                    set Dsr [expr -($srN-$sr0)]
                    set Dsf [expr -($sfN-$sf0)]
                    set Dleak [expr $leakN - $leak0]
                    lappend options [list $gname D $Dleak $Dsr $Dsf] 
                    
                    ecoChangeCell -inst $gname -cell $cellname0
                } 
                
                upsize $gname
                set cellnameN [get_property $iCell ref_lib_cell_name]
                if { $cellname0 != $cellnameN } {
                    set srN [get_property $iPin slack_max_rise]
                    set sfN [get_property $iPin slack_max_fall]
                    set leakN [getLeakagePowerLibCell $cellnameN]
                    set Dsr [expr -($srN-$sr0)]
                    set Dsf [expr -($sfN-$sf0)]
                    set Dleak [expr $leakN - $leak0]
                    lappend options [list $gname U $Dleak $Dsr $Dsf] 
                    
                    ecoChangeCell -inst $gname -cell $cellname0
                } 
            }
        }
    }
    return $options
}

proc LPassignment { } {
    setEcoMode -refinePlace false
    # Allocate slacks according to sensitivities
    # Load the upsize and downsize procedures information
    #source /w/design/puneet/projects/eco/scripts/sizingProcs.tcl
    

    
    global gatesList
    numberGates
    set riseOffset 0
    set fallOffset [llength $gatesList]
    setEcoMode -refinePlace false

    set cc [get_clocks]
    set clockPeriod [get_property $cc period]

    set loopf 1
    
    set fidl [open "lpassignment.log" "w"]
    puts "OPENING LOG FILE lpassignment.log"
    writeIterateInfo "Initial" $fidl
    
    set iters 0
    
    # to use mosek instead of lp_solve
    set MOSEK 0
    
    while { $loopf } {
        set OUTPUTFILE "LPassignment.lp";
        set fid [open $OUTPUTFILE "w"]
        puts "OPENING FILE ${OUTPUTFILE}"
        
        set options [makeOptionsLPA]
        
        set plusFlag false
        set bounds [list]
        # Write LP
        
        if { $MOSEK } {
            puts $fid "minimize"
        } else {
            puts $fid "min:"
            puts "MOSEK DISABLED"
            return 0
        }
        
        
        # write objective
        foreach s $options {
            set gname [lindex $s 0] 
            set type [lindex $s 1]
            set DP [lindex $s 2] 
            
            if { $DP > 0 } {
                if {$plusFlag == true} {
                    puts $fid "+ " nonewline
                } else {
                    set plusFlag true
                }
            } else {
                set plusFlag true
            }
            puts $fid "$DP G${gname}_$type " nonewline
        }
        
        if { ! $MOSEK } {
            puts $fid ";"
        } else {
            puts $fid "\n" nonewline
            puts $fid "subject to"
        }

        
        # Write LP
        foreach_in_collection iCell [get_cells] {
            set gname [get_property $iCell hierarchical_name]
            set cgate [get_cell $gname]
            set cellname0 [get_property $cgate ref_lib_cell_name]
            set cpins [get_pins $gname/*]

            foreach_in_collection iPin $cpins {
                
                # flip-flop outputs 
                if {([get_property $iCell is_sequential] == "true") && 
                    ([get_property $iPin direction]  == "out") } {
                    set pname [get_property $iPin ref_lib_pin_name]
                    set phname [get_property $iPin hierarchical_name]
                    
                    set ac [get_arcs -from $phname]
                    if {[sizeof_collection $ac] != 0} {
                        set amr [get_property $iPin arrival_max_rise]
                        set amf [get_property $iPin arrival_max_fall]
                        puts $fid "-G${phname}_r <= -$amr" nonewline
                        if {$MOSEK == 0} {
                            puts $fid ";"
                        }
                        puts $fid "-G${phname}_f <= -$amf" nonewline
                        if { ! $MOSEK } {
                            puts $fid ";"
                        } else {
                            puts $fid "\n" nonewline
                        }
                    }
                }

                #input pin loop
                if {([get_property $iPin direction] == "in") && 
                    ([get_property $iPin is_async]  == "false") && 
                    ([get_property $iPin is_clock]  == "false") } {
                    set pname [get_property $iPin ref_lib_pin_name]
                    set phname [get_property $iPin hierarchical_name]
                    if { [get_property $iPin is_rise_edge_triggered_data] == "true" } {
                        # Flip-flop Inputs - handled differently
                        # compute the delay into this gate
                        set ac [get_arcs -to $phname]
                        set FIGInd -1
                        foreach_in_collection ca $ac {
                            if { [get_property $ca arc_type] == "setup_rising"} {
                                set setupRise [get_property $ca delay_max_rise]
                                set setupFall [get_property $ca delay_max_fall]
                            } else {
                                set sourcepin [get_property $ca source_pin]
                                if { [get_property $sourcepin is_port] } {
                                    # add the delay at the port
                                    set amr [get_property $sourcepin arrival_max_rise]
                                    set amf [get_property $sourcepin arrival_max_fall]
                                } else {
                                    set srcGate [getGateFromPin $sourcepin]
                                    set FIGInd [getGateIndex $srcGate]
                                    set FIPinName [get_property $sourcepin hierarchical_name] 
                                }
                                set dmr [get_property $ca delay_max_rise]
                                set dmf [get_property $ca delay_max_fall]
                            }
                        }
                        
                        #adjust the times to account for clock latency
                        set ipamr [get_property $iPin arrival_max_rise]
                        set ipamf [get_property $iPin arrival_max_fall]
                        set ipsmr [get_property $iPin slack_max_rise]
                        set ipsmf [get_property $iPin slack_max_fall]
                        
                        set dcr [expr $ipamr + $ipsmr + $setupRise]
                        set dcf [expr $ipamf + $ipsmf + $setupFall]
                        
                        # rising path from input
                        if {$FIGInd != "-1"} {
                            set constb [expr -$dmr - $setupRise + $dcr]
                            puts $fid "G${FIPinName}_r <= ${constb}" nonewline
                            if { ! $MOSEK } {
                                puts $fid ";"
                            } else {
                                puts $fid "\n" nonewline
                            }
                        } 
                        
                        # falling path from input

                        if {$FIGInd != "-1"} {
                            set constb [expr -$dmf - $setupFall + $dcf]
                            puts $fid "G${FIPinName}_f <= ${constb}" nonewline
                            if { ! $MOSEK } {
                                puts $fid ";"
                            } else {
                                puts $fid "\n" nonewline
                            }
                        } 
                        
                        
                    } else {
                        # compute the delay into this gate
                        set ac [get_arcs -to $phname]
                        set FIGInd -1
                        foreach_in_collection ca $ac {
                            set sourcepin [get_property $ca source_pin]
                            if { [get_property $sourcepin is_port] } {
                                # add the delay at the port
                                set amr [get_property $sourcepin arrival_max_rise]
                                set amf [get_property $sourcepin arrival_max_fall]
                            } else {
                                set srcGate [getGateFromPin $sourcepin]
                                set FIGInd [getGateIndex $srcGate]
                                set FIPinName [get_property $sourcepin hierarchical_name] 
                            }
                            set dmr [get_property $ca delay_max_rise]
                            set dmf [get_property $ca delay_max_fall]
                        }
                        
                        set ac [get_arcs -from $phname]
                        foreach_in_collection ca $ac {
                            set sinkpin [get_property $ca sink_pin]
                            set tsense [get_property $ca sense]
                            set sinkPinName [get_property $sinkpin hierarchical_name]
                            #puts $fid "$phname to $sinkPinName $tsense" 
                            
                            # rising path from input
                            set constb [expr -$dmr]
                            
                            if {$FIGInd != "-1"} {
                                if { $tsense == "negative_unate" } {
                                    puts $fid "G${FIPinName}_f " nonewline
                                } 
                                if { $tsense == "positive_unate" } {
                                    puts $fid "G${FIPinName}_r " nonewline
                                }
                            } else {
                                set constb [expr $constb - $amr]
                            }
                            
                            puts $fid "-G${sinkPinName}_r " nonewline
                            set constb [expr $constb - [get_property $ca delay_max_rise]]                       
                            set linds [lsearch -all $options "${gname} *"]
                            foreach lind $linds {
                                set copt [lindex $options $lind]
                                set ddr [lindex $copt 3]
                                set type [lindex $copt 1]
                                if { $ddr != 0.0 } {
                                    if {$ddr < 0.0} {
                                        puts $fid " ${ddr} G${gname}_${type} " nonewline
                                    } else {
                                        puts $fid "+ ${ddr} G${gname}_${type} " nonewline
                                    }
                                }
                            }
                            puts $fid " <= ${constb}" nonewline
                            if {! $MOSEK } {
                                puts $fid ";"
                            } else {
                                puts $fid "\n" nonewline
                            }
                            
                            # falling path from input
                            set constb [expr -$dmf]
                            if {$FIGInd != "-1"} {
                                if { $tsense == "negative_unate" } {
                                    puts $fid "G${FIPinName}_r " nonewline
                                } 
                                if { $tsense == "positive_unate" } {
                                    puts $fid "G${FIPinName}_f " nonewline
                                }                           
                            } else {
                                set constb [expr $constb - $amf]
                            }
                            puts $fid "-G${sinkPinName}_f " nonewline
                            set constb [expr $constb - [get_property $ca delay_max_fall]]                          
                            set linds [lsearch -all $options "${gname} *"]
                            foreach lind $linds {
                                set copt [lindex $options $lind]
                                set ddf [lindex $copt 4]
                                set type [lindex $copt 1]
                                if { $ddf != 0.0 } {  
                                    if {$ddf < 0.0} {
                                        puts $fid " ${ddf} G${gname}_${type} "  nonewline
                                    } else {
                                        puts $fid "+ ${ddf} G${gname}_${type} "         nonewline
                                    }
                                }
                            }
                            puts $fid " <= ${constb}" nonewline
                            if { ! $MOSEK } {
                                puts $fid ";"
                            }    else {
                                puts $fid "\n" nonewline
                            }
                        }
                        
                    }
                    
                }
            }
        }
        
        
        foreach_in_collection iPort [get_ports] {
            set pname [get_property $iPort hierarchical_name]
            set s0 [min [get_property $iPort slack_max_rise]  [get_property $iPort slack_max_fall]]
            set ac [get_arcs -to $pname]
            set FIGInd -1
            foreach_in_collection ca $ac {
                set sourcepin [get_property $ca source_pin]
                set sourcePinName [get_property $sourcepin hierarchical_name]
                set dmr [get_property $ca delay_max_rise]
                set dmf [get_property $ca delay_max_rise]
                if { [get_property $sourcepin is_port] } {
                    # add the delay at the port
                    set amr [get_property $sourcepin arrival_max_rise]
                    set amf [get_property $sourcepin arrival_max_fall]
                } else {
                    set srcGate [getGateFromPin $sourcepin]
                    set FIGInd [getGateIndex $srcGate]
                }

                #adjust the times to account for clock latency
                set ipamr [get_property $iPort arrival_max_rise]
                set ipamf [get_property $iPort arrival_max_fall]
                set ipsmr [get_property $iPort slack_max_rise]
                set ipsmf [get_property $iPort slack_max_fall]
                        
                set dcr [expr $ipamr + $ipsmr]
                set dcf [expr $ipamf + $ipsmf]

                # falling path from input
                
                if {$FIGInd != "-1"} {
                    set constb [expr -$dmf+$dcf]
                    
                    puts $fid "G${sourcePinName}_f " nonewline
                    puts $fid " <= ${constb}" nonewline
                    if { ! $MOSEK } {
                        puts $fid ";"
                    } else {
                        puts $fid "\n" nonewline
                    }
                } 
                

                # rising path from input
                if {$FIGInd != "-1"} {
                    set constb [expr -$dmr+$dcr]
                    
                    puts $fid "G${sourcePinName}_r " nonewline
                    puts $fid " <= ${constb}" nonewline
                    if { ! $MOSEK } {
                        puts $fid ";"
                    } else {
                        puts $fid "\n" nonewline
                    }
                } 
                
            }
        }
        
        foreach_in_collection iCell [get_cells] {
            set gname [get_property $iCell hierarchical_name]
            set cgate [get_cell $gname]
            set linds [lsearch -all $options "${gname} *"]
            if { [llength $linds] != 0} {
                set plusFlag false
                puts $fid "0 <= " nonewline
                foreach lind $linds {
                    set copt [lindex $options $lind]
                    set type [lindex $copt 1]
                    if { $plusFlag == true } {
                        puts $fid "+ " nonewline
                    } else {
                        set plusFlag true
                    }
                    puts $fid "G${gname}_${type} " nonewline
                }
                puts $fid "<= 1" nonewline
                if { ! $MOSEK } {
                    puts $fid ";"
                } else {
                    puts $fid "\n" nonewline
                }
            }
            
        }
        if { $MOSEK } {
            puts $fid "end"
        } 
        close $fid
        
        if { $MOSEK } {
            set solvstatus [catch { exec mosek -p /w/design/puneet/projects/gs_survey/tcl/mosek.par  LPassignment.lp }]
        } else {
            set solvstatus [catch { exec lp_solve LPassignment.lp > output.lp }]
        }

        if { $solvstatus != 0 } {
            minDelayLPassignment options
            setEcoMode -refinePlace false
            set loopf 1
        } else {
            if { $MOSEK } {
                set assignments [readLPAoutput LPassignment.sol]
            } else {
                set assignments [readLPAoutput output.lp]
            }
            set loopf 0
            foreach s $assignments {
                set gname [lindex $s 0]
                set type [lindex $s 1]
                set value [lindex $s 2]
                
                if { $value > 0.99 } {
                    if { ${type} == "U" } {
                        puts "upsize $gname"
                        upsize $gname
                        set loopf 1
                    }
                    if { ${type} == "D" } {
                        puts "downsize $gname"
                        downsize $gname
                        set loopf 1
                    } 
                }
                
            }
        }
        writeIterateInfo "Iterate" $fidl
        incr iters 1
        if { $iters > 20} {
            set loopf 0
        }
        if { ($iters > 3) && ([getMinSlack]  > 0) } {
            set loopf 0
        }
    }
    
    setEcoMode -refinePlace true
    
    writeIterateInfo "Final  " $fidl
    close $fidl
}

proc minDelayLPassignment { options } {
    setEcoMode -refinePlace false
    # Allocate slacks according to sensitivities
    # Load the upsize and downsize procedures information
    #source /w/design/puneet/projects/eco/scripts/sizingProcs.tcl
    
    global gatesList
    numberGates
    set riseOffset 0
    set fallOffset [llength $gatesList]
    setEcoMode -refinePlace false

    set cc [get_clocks]
    set clockPeriod [get_property $cc period]

    set loopf 1
    # to use mosek instead of lp_solve
    set MOSEK 0

    set fidl [open "lpassignment.log" "w"]
    puts "OPENING LOG FILE lpassignment.log"
    writeIterateInfo "Initial" $fidl
    set iter 0

    while { $loopf } {
        set OUTPUTFILE "LPassignmentMD.lp";
        set fid [open $OUTPUTFILE "w"]
        puts "OPENING FILE ${OUTPUTFILE}"
        
        if { $MOSEK } {
            puts $fid "minimize\ntmax\n"
        } else {
            puts $fid "min:\ntmax;\n"
            puts "MOSEK DISABLED"
        }
        if {$MOSEK } {
            puts $fid "subject to"
        }

        set plusFlag false
        set bounds [list]
        # Write LP
        foreach_in_collection iCell [get_cells] {
            set gname [get_property $iCell hierarchical_name]
            set cgate [get_cell $gname]
            set cellname0 [get_property $cgate ref_lib_cell_name]
            set cpins [get_pins $gname/*]

            foreach_in_collection iPin $cpins {
                
                # flip-flop outputs 
                if {([get_property $iCell is_sequential] == "true") && 
                    ([get_property $iPin direction]  == "out") } {
                    set pname [get_property $iPin ref_lib_pin_name]
                    set phname [get_property $iPin hierarchical_name]
                    
                    set ac [get_arcs -from $phname]
                    if {[sizeof_collection $ac] != 0} {
                        set amr [get_property $iPin arrival_max_rise]
                        set amf [get_property $iPin arrival_max_fall]
                        puts $fid "-G${phname}_r <= -$amr" nonewline
                        if {$MOSEK == 0} {
                            puts $fid ";"
                        }
                        puts $fid "-G${phname}_f <= -$amf" nonewline
                        if { ! $MOSEK } {
                            puts $fid ";"
                        } else {
                            puts $fid "\n" nonewline
                        }
                    }
                }

                #input pin loop
                if {([get_property $iPin direction] == "in") && 
                    ([get_property $iPin is_async]  == "false") && 
                    ([get_property $iPin is_clock]  == "false") } {
                    set pname [get_property $iPin ref_lib_pin_name]
                    set phname [get_property $iPin hierarchical_name]
                    if { [get_property $iPin is_rise_edge_triggered_data] == "true" } {
                        # Flip-flop Inputs - handled differently
                        # compute the delay into this gate
                        set ac [get_arcs -to $phname]
                        set FIGInd -1
                        foreach_in_collection ca $ac {
                            if { [get_property $ca arc_type] == "setup_rising"} {
                                set setupRise [get_property $ca delay_max_rise]
                                set setupFall [get_property $ca delay_max_fall]
                            } else {
                                set sourcepin [get_property $ca source_pin]
                                if { [get_property $sourcepin is_port] } {
                                    # add the delay at the port
                                    set amr [get_property $sourcepin arrival_max_rise]
                                    set amf [get_property $sourcepin arrival_max_fall]
                                } else {
                                    set srcGate [getGateFromPin $sourcepin]
                                    set FIGInd [getGateIndex $srcGate]
                                    set FIPinName [get_property $sourcepin hierarchical_name] 
                                }
                                set dmr [get_property $ca delay_max_rise]
                                set dmf [get_property $ca delay_max_fall]
                            }
                        }
                        
                        
                        # rising path from input
                        if {$FIGInd != "-1"} {
                            set constb [expr -$dmr - $setupRise]
                            puts $fid "G${FIPinName}_r - tmax <= ${constb}" nonewline
                            if { ! $MOSEK } {
                                puts $fid ";"
                            } else {
                                puts $fid "\n" nonewline
                            }
                        } 
                        
                        # falling path from input

                        if {$FIGInd != "-1"} {
                            set constb [expr -$dmf - $setupFall]
                            puts $fid "G${FIPinName}_f - tmax <= ${constb}" nonewline
                            if { ! $MOSEK } {
                                puts $fid ";"
                            } else {
                                puts $fid "\n" nonewline
                            }
                        } 
                        
                        
                    } else {
                        # compute the delay into this gate
                        set ac [get_arcs -to $phname]
                        set FIGInd -1
                        foreach_in_collection ca $ac {
                            set sourcepin [get_property $ca source_pin]
                            if { [get_property $sourcepin is_port] } {
                                # add the delay at the port
                                set amr [get_property $sourcepin arrival_max_rise]
                                set amf [get_property $sourcepin arrival_max_fall]
                            } else {
                                set srcGate [getGateFromPin $sourcepin]
                                set FIGInd [getGateIndex $srcGate]
                                set FIPinName [get_property $sourcepin hierarchical_name] 
                            }
                            set dmr [get_property $ca delay_max_rise]
                            set dmf [get_property $ca delay_max_fall]
                        }
                        
                        set ac [get_arcs -from $phname]
                        foreach_in_collection ca $ac {
                            set sinkpin [get_property $ca sink_pin]
                            set tsense [get_property $ca sense]
                            set sinkPinName [get_property $sinkpin hierarchical_name]
                            #puts $fid "$phname to $sinkPinName $tsense" 
                            
                            # rising path from input
                            set constb [expr -$dmr]
                            
                            if {$FIGInd != "-1"} {
                                if { $tsense == "negative_unate" } {
                                    puts $fid "G${FIPinName}_f " nonewline
                                } 
                                if { $tsense == "positive_unate" } {
                                    puts $fid "G${FIPinName}_r " nonewline
                                }
                            } else {
                                set constb [expr $constb - $amr]
                            }
                            
                            puts $fid "-G${sinkPinName}_r " nonewline
                            set constb [expr $constb - [get_property $ca delay_max_rise]]                       
                            set linds [lsearch -all $options "${gname} *"]
                            foreach lind $linds {
                                set copt [lindex $options $lind]
                                set ddr [lindex $copt 3]
                                set type [lindex $copt 1]
                                if { $ddr != 0.0 } {
                                    if {$ddr < 0.0} {
                                        puts $fid " ${ddr} G${gname}_${type} " nonewline
                                    } else {
                                        puts $fid "+ ${ddr} G${gname}_${type} " nonewline
                                    }
                                }
                            }
                            puts $fid " <= ${constb}" nonewline
                            if {! $MOSEK } {
                                puts $fid ";"
                            } else {
                                puts $fid "\n" nonewline
                            }

                            # falling path from input
                            set constb [expr -$dmf]
                            if {$FIGInd != "-1"} {
                                if { $tsense == "negative_unate" } {
                                    puts $fid "G${FIPinName}_r " nonewline
                                } 
                                if { $tsense == "positive_unate" } {
                                    puts $fid "G${FIPinName}_f " nonewline
                                }                           
                            } else {
                                set constb [expr $constb - $amf]
                            }
                            puts $fid "-G${sinkPinName}_f " nonewline
                            set constb [expr $constb - [get_property $ca delay_max_fall]]                          
                            set linds [lsearch -all $options "${gname} *"]
                            foreach lind $linds {
                                set copt [lindex $options $lind]
                                set ddf [lindex $copt 4]
                                set type [lindex $copt 1]
                                if { $ddf != 0.0 } {
                                    if {$ddf < 0.0} {
                                        puts $fid " ${ddf} G${gname}_${type} " nonewline
                                    } else {
                                        puts $fid "+ ${ddf} G${gname}_${type} " nonewline
                                    }
                                }
                            }
                            puts $fid " <= ${constb}" nonewline
                            if { ! $MOSEK } {
                                puts $fid ";"
                            }    else {
                                puts $fid "\n" nonewline
                            }                       
                        }
                        
                    }
                    
                }
            }
        }
        
        
        foreach_in_collection iPort [get_ports] {
            set pname [get_property $iPort hierarchical_name]
            set s0 [min [get_property $iPort slack_max_rise]  [get_property $iPort slack_max_fall]]
            set ac [get_arcs -to $pname]
            set FIGInd -1
            foreach_in_collection ca $ac {
                set sourcepin [get_property $ca source_pin]
                set sourcePinName [get_property $sourcepin hierarchical_name]
                set dmr [get_property $ca delay_max_rise]
                set dmf [get_property $ca delay_max_rise]
                if { [get_property $sourcepin is_port] } {
                    # add the delay at the port
                    set amr [get_property $sourcepin arrival_max_rise]
                    set amf [get_property $sourcepin arrival_max_fall]
                } else {
                    set srcGate [getGateFromPin $sourcepin]
                    set FIGInd [getGateIndex $srcGate]
                }

                # falling path from input
                
                if {$FIGInd != "-1"} {
                    set constb [expr -$dmf]
                    
                    puts $fid "G${sourcePinName}_f " nonewline
                    puts $fid " - tmax <= ${constb}" nonewline
                    if { ! $MOSEK } {
                        puts $fid ";"
                    } else {
                        puts $fid "\n" nonewline
                    }
                } 
                

                # rising path from input
                if {$FIGInd != "-1"} {
                    set constb [expr -$dmr]
                    
                    puts $fid "G${sourcePinName}_r " nonewline
                    puts $fid " - tmax <= ${constb}" nonewline
                    if { ! $MOSEK } {
                        puts $fid ";"
                    } else {
                        puts $fid "\n" nonewline
                    }
                } 
                
            }
        }
        foreach_in_collection iCell [get_cells] {
            set gname [get_property $iCell hierarchical_name]
            set cgate [get_cell $gname]
            set linds [lsearch -all $options "${gname} *"]
            if { [llength $linds] != 0} {
                set plusFlag false
                puts $fid "0 <= " nonewline
                foreach lind $linds {
                    set copt [lindex $options $lind]
                    set type [lindex $copt 1]
                    if { $plusFlag == true } {
                        puts $fid "+ " nonewline
                    } else {
                        set plusFlag true
                    }
                    puts $fid "G${gname}_${type} " nonewline
                }
                puts $fid "<= 1" nonewline
                if { ! $MOSEK } {
                    puts $fid ";"
                } else {
                    puts $fid "\n" nonewline
                }
            }
        }
        
        if { $MOSEK } {
            puts $fid "end"
        } 
        close $fid
        
        if { $MOSEK } {
            set solvstatus [catch { exec mosek -p /w/design/puneet/projects/gs_survey/tcl/mosek.par  LPassignmentMD.lp }]
            set assignments [readLPAoutput LPassignmentMD.sol]
        } else {
            set solvstatus [catch { exec lp_solve LPassignmentMD.lp > output.lp }]
            set assignments [readLPAoutput output.lp]
        }
        
        set loopf 0
        foreach s $assignments {
            set gname [lindex $s 0]
            set type [lindex $s 1]
            set value [lindex $s 2]
            
            if { $value > 0.99 } {
                if { ${type} == "U" } {
                    puts "upsizing $gname"
                    upsize $gname
                    set loopf 1
                }
                if { ${type} == "D" } {
                    puts "downsizing $gname"
                    downsize $gname
                    set loopf 1
                } 
            }
            
        }
        if { [getMinSlack]  > 0 } {
            set loopf 0
        }
        incr iter 1
        if { $iter > 20 } {
            set loopf 0
        }
        set loopf 0
        writeIterateInfo "Iterate" $fidl
    }
    
    setEcoMode -refinePlace true
    
    writeIterateInfo "Final" $fidl
    close $fidl
}

proc readLPAoutput { fname } {
    set fid [open $fname "r"]
    set assign [list]
    while {[gets $fid line] >= 0} {
        set words [regexp -all -inline {\S+} $line]
        if {[llength $words] == 2 } {
            set gname [lindex $words 0]
            set sind [string last _U $gname]
            if {$sind != -1} {
                set gname [string range $gname 1 [expr $sind-1]]
                set salloc [lindex $words 1]
                lappend assign [list $gname U $salloc] 
            }
            set sind [string last _D $gname]
            if {$sind != -1} {
                set gname [string range $gname 1 [expr $sind-1]]
                set salloc [lindex $words 1]
                lappend assign [list $gname D $salloc] 
            }       
        } 
        if {[llength $words] == 8 } {
            set gname [lindex $words 1]
            set sind [string last _U $gname]
            if {$sind != -1} {
                set gname [string range $gname 1 [expr $sind-1]]
                set salloc [lindex $words 3]
                lappend assign [list $gname U $salloc] 
            }
            set sind [string last _D $gname]
            if {$sind != -1} {
                set gname [string range $gname 1 [expr $sind-1]]
                set salloc [lindex $words 3]
                lappend assign [list $gname D $salloc] 
            }       
        } 
    }
    return $assign
}

