# helper functions for the timing

proc getSlackPin { iPin } {
  set st [min [get_property $iPin slack_max_rise]  [get_property $iPin slack_max_fall]]
  if  {($st != "NA") && ($st != "INFINITY") } {
    return $st
  }
  return 100

}

proc getSlackRisePin { iPin } {
  set st [get_property $iPin slack_max_rise]
  if  {($st != "NA") && ($st != "INFINITY") } {
    return $st
  }
  return 100
}

proc getSlackFallPin { iPin } {
  set st [get_property $iPin slack_max_fall]
  if  {($st != "NA") && ($st != "INFINITY") } {
    return $st
  }
  return 100
}

proc getArrivalFallPin { iPin } {
  set st [get_property $iPin arrival_max_fall]
  if  {($st != "NA") && ($st != "INFINITY") } {
    return $st
  }
  return -100
}

proc getArrivalRisePin { iPin } {
  set st [get_property $iPin arrival_max_rise]
  if  {($st != "NA") && ($st != "INFINITY") } {
    return $st
  }
  return -100
}


proc getMaxArrivalTimePin { iPin } {
  return [max [get_property $iPin arrival_max_rise]  [get_property $iPin arrival_max_fall]]
}

proc getSlackCell { gn } {
  set slackMin 10000
  
  set op_coll [get_pins "${gn}/*" -filter "direction==out"]
  foreach_in_collection op $op_coll {
    set sc [getSlackPin $op]
      if {$sc < $slackMin} {
        set slackMin $sc
      }
  }
return $slackMin
}

proc getFanInSlack { gn } {
  set slackMin 10000
  
  set op_coll [get_pins "${gn}/*" -filter "direction==in"]
  foreach_in_collection op $op_coll {
    set dcc  [all_fanin -levels 1 -to $op -only_cells]
    foreach_in_collection dc $dcc {
      set dcn [get_property $dc hierarchical_name]
      set op_coll2 [get_pins "${dcn}/*" -filter "direction==out"]
      foreach_in_collection drpo $op_coll2 {
        set sc [getSlackPin $drpo]
        if {$sc < $slackMin} {
          set slackMin $sc
        }
      }
    }
  }
  return $slackMin
  
}

proc getMaxDelay { } {
  #extractRC
  set cl "(direction == out)"
  set pcoll [get_pins -filter $cl]
         
  set dmax -10000
  # find minimum slack
  foreach_in_collection iPin $pcoll {
    set dt [getMaxArrivalTimePin $iPin]
    if {($dt != "NA") && ($dt != "INFINITY") && ($dt > $dmax)} {
      set dmax $dt
    }
  }
  return $dmax
}



proc getMinSlack { } {
  #extractRC
  set cl "(direction == out)"
  set pcoll [get_pins -filter $cl]
         
  set smin 10000
  # find minimum slack
  foreach_in_collection iPin $pcoll {
    set s0 [getSlackPin $iPin]
    if {($s0 != "NA") && ($s0 != "INFINITY") && ($s0 < $smin)} {
      set smin $s0
    }
  }
  return $smin
}

proc getTotalSlack { } {
  set cl "(direction == out)"
  set pcoll [get_pins -filter $cl]
  
  set stotal 0
  # find minimum slack
  foreach_in_collection iPin $pcoll {
    set s0 [getSlackPin $iPin]
    if {($s0 != "NA") && ($s0 != "INFINITY")} {
      set stotal [expr $stotal+$s0]
    }
  }
  return $stotal
}


