# Procedures used to dump timing data for analysis

proc generateTimingData { } {
# Load the upsize and downsize procedures information
#source /w/design/puneet/projects/eco/scripts/sizingProcs.tcl

setEcoMode -refinePlace false

puts "OUTPUT: [sizeof_collection [get_cells]] gates and [sizeof_collection [get_pins]] pins"
set OUTPUTFILE "timingInformation.log";
set fileId [open $OUTPUTFILE "w"]
puts "OPENING FILE ${OUTPUTFILE}"

# Dump arrival times
foreach_in_collection iCell [get_cells] {
    set gname [get_property $iCell hierarchical_name]
    set cgate [get_cells $gname]
    set cellname0 [get_property $cgate ref_lib_cell_name]
    set cpins [get_pins $gname/*]
    puts $fileId "$gname $cellname0"
    #input pin loop
    foreach_in_collection iPin $cpins {
      if {[get_property $iPin direction] == "in"} {
        set pname [get_property $iPin ref_lib_pin_name]
        set phname [get_property $iPin hierarchical_name]
        set s0 [min [get_property $iPin slack_max_rise]  [get_property $iPin slack_max_fall]]
        if {($s0 == "NA") || ($s0 == "INFINITY")} {
          # pins without timing information
          puts $fileId "   $pname: NA NA"
        } else {
          set amr [get_property $iPin arrival_max_rise]
          set amf [get_property $iPin arrival_max_fall]
          set smr [get_property $iPin slack_max_rise]
          set smf [get_property $iPin slack_max_fall]
          puts $fileId "   $pname: $amr $amf $smr $smf"
        }
        set iretd [get_property $iPin is_rise_edge_triggered_data]
        puts $fileId "           - $iretd"
        set ac [get_arcs -to $phname]
        append_to_collection ac [get_arcs -from $phname]
        foreach_in_collection ca $ac {
          set sourcepin [get_property [get_property $ca source_pin] hierarchical_name]
          set sinkpin [get_property [get_property $ca sink_pin] hierarchical_name]
          puts $fileId "     ARC: $sourcepin -> $sinkpin :  [get_property $ca delay_max_rise] [get_property $ca delay_max_fall]"
          puts $fileId "    -- [get_property $ca arc_type] "
          puts $fileId "    -- [get_property $ca sense] "
          puts $fileId "    -- [get_property $ca mode] "
          puts $fileId "    -- [get_property $ca when] "
        }
      }
    }
    
    # output pin loop
    foreach_in_collection iPin $cpins {
      if {[get_property $iPin direction] == "out"} {
        set pname [get_property $iPin ref_lib_pin_name]
        set phname [get_property $iPin hierarchical_name]
        set s0 [min [get_property $iPin slack_max_rise]  [get_property $iPin slack_max_fall]]
        if {($s0 == "NA") || ($s0 == "INFINITY")} {
          # pins without timing information
          puts $fileId "   $pname: NA NA"
        } else {
          set amr [get_property $iPin arrival_max_rise]
          set amf [get_property $iPin arrival_max_fall]
          set smr [get_property $iPin slack_max_rise]
          set smf [get_property $iPin slack_max_fall]
          puts $fileId "   $pname: $amr $amf $smr $smf"
        }
        set iretd [get_property $iPin is_rise_edge_triggered_data]
        puts $fileId "           - $iretd"
        set iretd [get_property $iPin is_rise_edge_triggered_data]
        puts $fileId "           - $iretd"
        set ac [get_arcs -to $phname]
        append_to_collection ac [get_arcs -from $phname]
        foreach_in_collection ca $ac {
          set sourcepin [get_property [get_property $ca source_pin] hierarchical_name]
          set sinkpin [get_property [get_property $ca sink_pin] hierarchical_name]
          puts $fileId "     ARC: $sourcepin -> $sinkpin :  [get_property $ca delay_max_rise] [get_property $ca delay_max_fall]"
          puts $fileId "      -- [get_property $ca arc_type] "
          
        }
        set nname [get_property $iPin net_name]
        if { $nname != "NA"} {
          set opins [get_property [get_net $nname] load_pins]
          foreach_in_collection opin $opins {
            set opinname [get_property $opin hierarchical_name]
            set amr [get_property $opin arrival_max_rise]
            set amf [get_property $opin arrival_max_fall]
            set smr [get_property $opin slack_max_rise]
            set smf [get_property $opin slack_max_fall]
            puts $fileId "   FANOUT: $opinname $amr $amf $smr $smf"
          }
        }
      }
    }
}

foreach_in_collection iPort [get_ports] {
    set pname [get_property $iPort hierarchical_name]
    set s0 [min [get_property $iPort slack_max_rise]  [get_property $iPort slack_max_fall]]
    if {$s0 == "NA"} {
        # pins without timing information
        puts $fileId "$gname PORT NA NA NA"
    } else {
        set amr [get_property $iPort arrival_max_rise]
        set amf [get_property $iPort arrival_max_fall]
        set smr [get_property $iPort slack_max_rise]
        set smf [get_property $iPort slack_max_fall]
        puts $fileId "$pname PORT $amr $amf $smr $smf"
    }
    set ac [get_arcs -to $pname]
    append_to_collection ac [get_arcs -from $pname]
    foreach_in_collection ca $ac {
      set sourcepin [get_property [get_property $ca source_pin] hierarchical_name]
      set sinkpin [get_property [get_property $ca sink_pin] hierarchical_name]
      puts $fileId "     ARC: $sourcepin -> $sinkpin :  [get_property $ca delay_max_rise] [get_property $ca delay_max_fall]"
      puts $fileId "    -- [get_property $ca arc_type] "
      puts $fileId "    -- [get_property $ca sense] "
      puts $fileId "    -- [get_property $ca mode] "
      puts $fileId "    -- [get_property $ca when] "
    }
}

close $fileId
}

proc writeNetTiming { } {
foreach_in_collection cn [get_nets] {
    set cname [get_property $cn hierarchical_name]
    puts "$cname"

}


}

proc printClockTree { clk_name } {
set OUTPUTFILE "clockTreeInformation.log";
set fileId [open $OUTPUTFILE "w"]
puts "OPENING FILE ${OUTPUTFILE}"

buildTimingGraph

set cstack [get_net $clk_name]
set level 0

while { [sizeof_collection $cstack] != 0 } {
  puts $fileId "level $level"
  incr level 1
  set cstack2 {}
  foreach_in_collection cp $cstack {
    set cname [get_property $cp hierarchical_name]
    puts $fileId "   $cname"
    set opins [get_property $cp load_pins]
    foreach_in_collection opin $opins {
      set opn [get_property $opin hierarchical_name]      
      puts $fileId "    -> $opn"
      if { ![get_property $opin is_clock]} {
        set ac [get_arcs -from $opin]
        foreach_in_collection carc ${ac} {
          set sinkpin [get_property $carc sink_pin]
          set spn [get_property $sinkpin hierarchical_name]
          set nn [get_property $sinkpin net_name]
          append_to_collection cstack2 [get_net $nn]
        }
      }
    }
  }
  set cstack ${cstack2}
}
  
close $fileId   
}

