# used to restore sizing saved by "saveCurrentSizing"
proc restoreSizing { sname } {
    puts "Restoring sizing ..."
    foreach s $sname { 
        if { [llength $s] == 2 } {
            set gname [lindex $s 0] 
            set cname [lindex $s 1]
            #puts "$gname $cname"
            ecoChangeCell -inst $gname -cell $cname
        }
    }
}

# used to save a given sizing. Note that the timing may differ
# if incremental placement or routing was performed between saving 
# and restoring
proc saveCurrentSizing {  } {
    global sname
    set sname [list]
    
    foreach_in_collection iCell [get_cells] {
        set gname [get_property $iCell hierarchical_name]
        set cname [get_property $iCell ref_lib_cell_name]
        lappend sname [list $gname $cname] 
    }
    return $sname
}

# Writes current iteration information to file fid
proc writeIterateInfo { txt fid } {
    set cleak [getLeakagePower]
    set cslack [getMinSlack]
    set cdelay [getMaxDelay]
    puts $fid "${txt}: Leakage ${cleak} Slack ${cslack} Delay ${cdelay}"
}

# Procedure used to upsize gates. When footprints
# are available, the method will change to the gate with 
# the next highest leakage power.
proc upsize {gname} {
    encMessage info 0
    
    global libFootprint
    global fpDict
    global leakList
    
    if {$libFootprint} {
      set lcell [get_property [get_cell $gname] ref_lib_cell_name]
      set ind [lsearch $leakList "$lcell *"]
      set footprint [lindex [lindex $leakList $ind] 2]      
      set fpInd [lsearch $fpDict "$footprint *"]
      if {$fpInd == -1} {
        #footprint does not exist yet
        puts "Footprint $footprint / $lcell does not exist!"
      } else {
        set fpc [lindex [lindex $fpDict $fpInd] 1 ]
        set ind [lsearch $fpc "$lcell *"]
        if {[expr $ind + 1] != [llength $fpc]} {
          set newCell [lindex [lindex $fpc [expr $ind + 1]] 0]
          ecoChangeCell -inst $gname -cell $newCell
        } 
        
      }
    } else {
        ecoChangeCell -inst $gname -upsize
    }
}

# Procedure used to downsize gates. When footprints
# are available, the method will change to the gate with 
# the next lowest leakage power.
proc downsize {gname} {
    encMessage info 0

    global libFootprint
    global fpDict
    global leakList
    
    if {$libFootprint} {
      set lcell [get_property [get_cell $gname] ref_lib_cell_name]
      set ind [lsearch $leakList "$lcell *"]
      set footprint [lindex [lindex $leakList $ind] 2]      
      set fpInd [lsearch $fpDict "$footprint *"]
      if {$fpInd == -1} {
        #footprint does not exist yet
        puts "Footprint $footprint does not exist!"
      } else {
        set fpc [lindex [lindex $fpDict $fpInd] 1 ]
        set ind [lsearch $fpc "$lcell *"]
        if {$ind != 0} {
          set newCell [lindex [lindex $fpc [expr $ind -1]] 0]
          ecoChangeCell -inst $gname -cell $newCell
        } 
      }
    } else {
      ecoChangeCell -inst $gname -downsize
      }
}

proc getOutputPin { gname } {   
    return [get_pin "${gname}/*" -filter "direction==out"]
}

# This procedure creates a list consisting of 
# [Cellname] [Delta Slack] [Delta Power]
# The flag "fastTiming" can be used for Encounter v10.1 and up
# for a 2x to 5x runtime improvement
# (catch output does not work on older versions)
# this procedure takes most of the runtime.
proc evaluateOptions { gname } {
    encMessage info 1
    # this procedure takes the bulk of the runtime
    set fastTiming 1
    set opts [list]
    if { $fastTiming } {
        set data [catchOutput ecoChangeCell -inst $gname -evaluateAll]
        
        set cgate [get_cell $gname]
        set cname [get_property $cgate ref_lib_cell_name]
        set s0 [getSlackCell $gname]
        set leak0 [getLeakagePowerLibCell $cname]
        
        set loopf 1
        set bb 0
        while {1} {
            set mind [string first "---- Cell: " $data $bb]
            if {$mind == -1} {
                break
            } else {
                set bb [expr $mind + 11]
                #set data [string range $data [expr 11+ $mind] end]
                
                # grab the cell name
                set bind [string first "/" $data $bb]
                set eind [string first " " $data $bind]
                set cname [string range $data [expr $bind + 1] [expr $eind - 1]]
                
                # grab the slack
                set nind [string first "Through-object Slack: " $data $eind]
                set eind [string first "\n" $data $nind]
                set slackStr [string range $data [expr $nind + 22] [expr $eind-1]] 
                #puts "$gname ($cname) / slack: ($slackStr)"
                set leakN [getLeakagePowerLibCell $cname]
                lappend opts [list $cname [expr $slackStr - $s0] [expr $leakN-$leak0] $slackStr]
            }
        }
        return $opts
    } else {
        setEcoMode -refinePlace false
        # standard flow
        set cgate [get_cell $gname]
        set cname [get_property $cgate ref_lib_cell_name]
        set s0 [getSlackCell $gname]
        set leak0 [getLeakagePowerLibCell $cname]

        # check downsizes
        while {1} {
            set cnameL [get_property $cgate ref_lib_cell_name]
            downsize $gname
            set cnameN [get_property $cgate ref_lib_cell_name]
            if {$cnameN != $cnameL} {
                set leakN [getLeakagePowerLibCell $cnameN]
                set sN [getSlackCell $gname]
                lappend opts [list $cnameN [expr $sN - $s0] [expr $leakN-$leak0] $sN ]
            } else {
                break
            }
        }
        ecoChangeCell -inst $gname -cell $cname
        
        # check upsizes
        while {1} {
            set cnameL [get_property $cgate ref_lib_cell_name]
            upsize $gname
            set cnameN [get_property $cgate ref_lib_cell_name]
            if {$cnameN != $cnameL} {
                set leakN [getLeakagePowerLibCell $cnameN]
                set sN [getSlackCell $gname]
                lappend opts [list $cnameN [expr $sN - $s0] [expr $leakN-$leak0] $sN]
            } else {
                break
            }
        }
        ecoChangeCell -inst $gname -cell $cname
        return $opts
    }
}

# Version of the above for just one cell type.
# This procedure creates a singleton list consisting of 
# [Delta Slack] [Delta Power] [Slack]
# The flag "fastTiming" can be used for Encounter v10.1 and up
# for a 2x to 5x runtime improvement
# (catch output does not work on older versions)
# this procedure takes most of the runtime.
proc evaluateOption { gname ecname } {
  encMessage info 1
  # this procedure takes the bulk of the runtime
  set fastTiming 1
  set opts [list]
  if { $fastTiming } {
    set data [catchOutput ecoChangeCell -inst $gname -cell $ecname -evaluateOnly]
    
    set cgate [get_cell $gname]
    set cname [get_property $cgate ref_lib_cell_name]
    set s0 [getSlackCell $gname]
    set leak0 [getLeakagePowerLibCell $cname]
    
    set loopf 1
    set bb 0
    while {1} {
      set mind [string first "---- Cell: " $data $bb]
      if {$mind == -1} {
	break
      } else {
	set bb [expr $mind + 11]
	#set data [string range $data [expr 11+ $mind] end]
	
	# grab the cell name
	set bind [string first "/" $data $bb]
	set eind [string first " " $data $bind]
	set cname [string range $data [expr $bind + 1] [expr $eind - 1]]
	
	# grab the slack
	set nind [string first "Through-object Slack: " $data $eind]
	set eind [string first "\n" $data $nind]
	set slackStr [string range $data [expr $nind + 22] [expr $eind-1]] 
	#puts "$gname ($cname) / slack: ($slackStr)"
	set leakN [getLeakagePowerLibCell $cname]
	set opts [list [expr $slackStr - $s0] [expr $leakN-$leak0] $slackStr]
      }
    }
    return $opts
  } else {
    setEcoMode -refinePlace false
    # standard flow
    set cgate [get_cell $gname]
    set cname [get_property $cgate ref_lib_cell_name]
    set s0 [getSlackCell $gname]
    set leak0 [getLeakagePowerLibCell $cname]
   
    ecoChangeCell -inst $gname -cell $ecname
    set leakN [getLeakagePowerLibCell $cnameN]
    set sN [getSlackCell $gname]
    set opts [list [expr $sN - $s0] [expr $leakN-$leak0] $sN ]
    
    ecoChangeCell -inst $gname -cell $cname
    return $opts
  }
}

# procedure to capture stdout to variable
# command "redirect" works on encounter v.10.1 and up
proc catchOutput { args } {
    redirect {eval $args} > tmp.co.log
    set fp [open "tmp.co.log" r]
    set file_data [read $fp]
    close $fp
    return $file_data
}







