proc makeTimingConstraint { DELAYFACTOR } {

set filename "timingInfo.log";
set fileId [open $filename "w"]

# create clocks
set cc [all_clocks]
if  {([sizeof_collection $cc]) == 0} {
  set cp [get_ports blif_clk_net]
  if {([sizeof_collection $cp]) == 0} {
    create_clock -period 10 -name clk
    set cc [all_clocks]
  } else {
    create_clock -period 10 -name clk  blif_clk_net
    set cc [all_clocks]
  }
}


set cclock [index_collection $cc 0]
set cname [get_property $cclock hierarchical_name]
puts "Clock name: ${cname}"

# set the timing constraints
#set_input_delay -clock $cname 0.0 [all_inputs]
#set_output_delay -clock $cname 0.0 [all_outputs]

# figure out the delay
#buildTimingGraph

# figure out the current delay
set ati [getMaxDelay]
set nci [sizeof_collection [get_cells]]
reportLeakagePower -outfile init.power.log

# figure out the maximum delay
minimumSize
set atmx [getMaxDelay]
reportLeakagePower -outfile init_min.power.log
reportFootPrint

setDontUse * false
set_dont_touch [get_cells] false

greedySizingTiming
set atmn [getMaxDelay]
puts "Max delay after optimization: $atmn"
reportLeakagePower -outfile mindelay.power.log

set att [expr ($atmn + $DELAYFACTOR*($atmx-$atmn))]  

create_clock -period [expr $att] -name clk

reportLeakagePower -outfile actual.power.log

timeDesign -preCTS -outDir timingPreRoute

puts "OUTPUT: Max delays $ati / $atmn / $atmx / $att"



# Write the sdc for fun
#writeTimingCon -sdc -filePrefix $DNAME_tc
close $fileId


}
