# Procedures to read leakage power from lib files, and use for 
# optimization. Note that the leakage computed from getLeakagePower
# may not correspond with Encounter's internal leakage power. However,
# these leakage power estimates are sufficient for sizing method
# comparisons

# Read leakage power from liberty file libname
# also reads footprints, if they are available.
proc readLeakagePower {fname} {

# Used to distinguish cells with the same footprint that are not interchangeable
# e.g. cells INV and INV_NNNNN_ are not interchangeable.
set altType _NNNNNN_

puts "*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*"
puts "Reading leakage power from $fname"

set fid [open $fname "r"]
set RE {[][();"]} 

global leakList
if {! [info exists leakList]} {
    set leakList [list]
}

global libFootprint
set libFootprint 0

global fpDict
if {! [info exists fpDict]} {
    set fpDict [list]
}

set red 0
set leakage 0
set count 0
set average 0
set cellname "NULL"

while {[gets $fid line] >= 0} {
    set line [regsub -all $RE $line " "]
    set words [regexp -all -inline {\S+} $line]
    if {[llength $words] > 0} {
        set word1 [lindex $words 0]
        if [expr "[string compare $word1 "cell"] == 0"] {
              
                
            if {$red && $loaded} {
                if {! $average } {
                    set leakage [expr ($leakage * 1.0 ) / ( $count * 1.0 )]
                }
                puts "   $cellname / $footprint / $leakage ( $count )"
                lappend leakList [list $cellname $leakage $footprint]
                
                if {$footprint != "NULL"} {
                  # add data to the footprint
                  set fpInd [lsearch $fpDict "$footprint *"]
                  if {$fpInd == -1} {
                    #footprint does not exist yet
                    lappend fpDict [list $footprint  [list [list $cellname $leakage]]]
                  } else {
                    set fpc [lindex [lindex $fpDict $fpInd] 1 ]
                    lappend fpc [list $cellname $leakage]
                    set fpc [lsort -real -increasing -index 1 $fpc]
                    set fpDict [lreplace $fpDict $fpInd $fpInd [list $footprint $fpc]]
                  }
                  
                }
            }
            set cellname [lindex $words 1]
            set leakage 0
            set count 0
            set average 0
            set loaded 0
            set footprint "NULL"
            #puts "Found cell $cellname"
            set red 1
        } elseif [expr "[string compare $word1 "cell_footprint"] == 0"] {
          set footprint [lindex $words 2]
	    if {[string first $altType $cellname] != -1} {
		set footprint ${footprint}${altType}
	    }
          set libFootprint 1
        } elseif  [expr "[string compare $word1 "cell_leakage_power"] == 0"] {
            set leakage [lindex $words 2]
            set leakage [expr (1.0* $leakage )/1000]
            set loaded 1
            set average 1
        } elseif  [expr "[string compare $word1 "value"] == 0"] {
            if {! $average } {
                set leakageTmp [lindex $words 2]
                set leakage [expr $leakage + (1.0* $leakageTmp )/1000]
                set count [expr $count + 1.0]
                set loaded 1
                #puts "Read $cellname $leakageTmp / $leakage ($count)"
            }
        }
    }
}
if {$red && $loaded} {
    puts "   $cellname / $footprint / $leakage ( $count )"
    lappend leakList [list $cellname $leakage $footprint]
    if {$footprint != "NULL"} {
      # add data to the footprint
      set fpInd [lsearch $fpDict "$footprint *"]
      if {$fpInd == -1} {
        #footprint does not exist yet
        lappend fpDict [list $footprint  [list [list $cellname $leakage]]]
      } else {
        set fpc [lindex [lindex $fpDict $fpInd] 1 ]
        lappend fpc [list $cellname $leakage]
        set fpc [lsort -real -increasing -index 1 $fpc]
        set fpDict [lreplace $fpDict $fpInd $fpInd [list $footprint $fpc]]
      }
                  
    }
}


close $fid
}

# Returns the leakage power associated with
# library cell $cn
proc getLeakagePowerLibCell { cn } {
  global leakList
  set lind [lsearch $leakList "$cn *"]
  if { $lind == -1 } {
    puts "Leakage for $cn not found"
    return 0
  } else {
    return [lindex [lindex $leakList $lind] 1]
  }
  
}

# Returns the current leakage power of gate $cg
proc getLeakagePowerGate { cg } {
  set lcn [get_property $cg ref_lib_cell_name]
  return [getLeakagePowerLibCell $lcn ]
}

# Returns estimated total leakage power
# note that this may not be the same leakage
# as computed by encounter
proc getLeakagePower { } {
  set tp 0
  foreach_in_collection cc [get_cells] {
    set tp [expr $tp + [getLeakagePowerGate $cc] ]
  }
  return $tp
}

