# Implementation of Coudert, Global Sizing.
# Implementation performs poorly - needs testing and validation

proc globalSizingPower { } {
  # start by minimizing power
  #globalSizingTiming
  
  #Performs a greedy sensitivity based sizing
  set fid [open "globalSizingPower.log" "w"]
  
  setDontUse * false
  set_dont_touch [get_cells] false
  
  # Don't do incremental placements inbetween cell sizings
  setEcoMode -refinePlace false
  
  gsGoToLocalMin gsPowerObj gsPowerFitness gsCompare {(1)} {(0)} 2  $fid

  #refinePlace
  #ecoPlace
  #ecoRoute
  
  close $fid
}


proc globalSizingTiming { } {
  #encMessage info 0
  #Performs a greedy sensitivity based sizing
  set fid [open "globalSizingTiming.log" "w"]
  
  setDontUse * false
  set_dont_touch [get_cells] false
  
  # Don't do incremental placements inbetween cell sizings
  setEcoMode -refinePlace false
  
  set best_slack -1000
  gsGoToLocalMin gsNegMinSlack gsDeltaLocalSlack gsCompare {($s0 == $smin)} {(1)} 10 $fid
  set SN [getMinSlack]

  set iters 0
  while { $SN > $best_slack } {
    set best_slack [getMinSlack]
    gsGoToLocalMin gsNegTotalSlack gsDeltaLocalTotalSlack gsCompare {(1)} {(0)} 10 $fid
    gsGoToLocalMin gsNegMinSlack gsDeltaLocalSlack gsCompare {($s0 == $smin)} {(1)} 1 $fid
    set SN [getMinSlack]
    puts $fid "$iters : $best_slack -> $SN"
    incr iters 1
  }
  
  #refinePlace
  #ecoPlace
  #ecoRoute
  
  close $fid
  #encMessage info 1
}

proc gsDiff { a b } {
  if {([llength $a] == 1) || ([llength $b] == 1)} {
    return [expr [lindex $a 0] - [lindex $b 0]]
  }
  
  return [list [expr [lindex $a 0] - [lindex $b 0] ] [expr [lindex $a 1] - [lindex $b 1] ]]
}


proc gsCompare {a b} {

  if {[lindex $a 0] < [lindex $b 0]} {
    return -1
  } elseif {[lindex $a 0] > [lindex $b 0]} {
    return 1
  }
  
  if {([llength $a] == 1) || ([llength $b] == 1)} {
    return 0
  }
  
  set a0 [lindex $a 1]
  set b0 [lindex $b 1]
  if {$a0 < $b0} {
    return -1
  } elseif {$a0 > $b0} {
    return 1
  }
  return 0

}

proc gsNegMinSlack { } {
  return [expr -[getMinSlack]]
}

proc gsNegTotalSlack { } {
  return [expr -[getTotalSlack]]
}

proc gsDeltaLocalSlack { cpin } {
  global S0
  
  return [expr [gsLocalSlack $cpin]-$S0]
}


proc gsLocalSlack { cpin } {
  
  set smin 1000
  set dcc  [all_fanin -pin_levels 20 -to $cpin ]
  foreach_in_collection dc $dcc {
    set sc [getSlackPin $dc]
    if { $sc < $smin } {
      set smin $sc
    }
  }
  set dcc  [all_fanout -pin_levels 20 -from $cpin ]
  foreach_in_collection dc $dcc {
    set sc [getSlackPin $dc]
    if { $sc < $smin } {
      set smin $sc
    }
  }
  return $smin
}


proc gsDeltaLocalTotalSlack { cpin } {
  global TS0
  
  return [expr [gsLocalTotalSlack $cpin]-$TS0]
}


proc gsLocalTotalSlack { cpin } {
  set stotal 0
  set dcc  [all_fanin -pin_levels 20 -to $cpin ]
  foreach_in_collection dc $dcc {
    set sc [getSlackPin $dc]
    if {($sc != "NA") && ($sc != "INFINITY")} {
      set stotal [expr $stotal + $sc]
    }
  }
  set dcc  [all_fanout -pin_levels 20 -from $cpin ]
  foreach_in_collection dc $dcc {
    set sc [getSlackPin $dc]
    if {($sc != "NA") && ($sc != "INFINITY")} {
      set stotal [expr $stotal + $sc]
    }
  }
  return [expr -$stotal]
}

proc gsLocalPower { cpin } {
  set lpc 0

  set gc [all_fanin -levels 5 -only_cells -to $cpin]
  append_to_collection gc [all_fanout -levels 5  -only_cells -from $cpin]
  foreach_in_collection cg $gc {
    set lpc [expr $lpc + [getLeakagePowerGate $gc]]
  }
  return $lpc
}

proc gsPowerFitness { cpin } {
  set epsilon .001
  set alpha 1e-5
  
  set SN [gsLocalSlack $cpin]
  set PN [gsLocalPower $cpin]

  global P0
  global S0

  set DP [expr $PN-$P0]
  set DS [expr $SN-$S0]

  if { ($DP > 0) || ([expr $S0+$DS] < 0) } {
    return $epsilon
  }
  
  set x [expr ($DS)/($epsilon+$S0)]
  if { $x >= 0 } {
    set phi [expr 1 + $x ]
  } else {
    set phi [expr 1/(1-$x)]
  }
  
  return [expr ($epsilon-$alpha*$DP)*$phi]
  
}


proc gsPowerObj {  } {
  set s [getMinSlack]
  if {$s < 0} {
    return 100000000000
  }
  
  return [getLeakagePower]
   
}



proc gsGoToLocalMin { cost fitness comparison cond cond2 maxChanges fid } {
  encMessage info 0
  global P0
  global S0
  global TS0
  set old_cost 0
  set new_cost 1
  set moves {}

  set cl "(direction == out)"
  set pcoll [get_pins -filter $cl]
  set iters 0
  
  while { $old_cost != $new_cost } {
    set old_cost [$cost]
    set smin [getMinSlack]

    puts "$iters : $old_cost"
    
    if {[expr $cond2]} {
      set pcoll [get_pins -filter $cl]
    }
  
    # Make sensitivity list
    foreach_in_collection iPin $pcoll {
      encMessage info 0
      if {![get_property $iPin is_clear] && ![get_property $iPin is_async] && ![get_property $iPin is_clock]} {
        set hname [get_property $iPin hierarchical_name]
        set ppname [get_property $iPin hierarchical_name]
        #get the gate associated with the pin
        regsub -all {/} $hname { } hname
        scan $hname "%s %s" gname pname
        set cgate [get_cells $gname]
        set cellname0 [get_property $cgate ref_lib_cell_name]
        set iscom [get_property $cgate is_combinational]
        if {$iscom} {
          # get the slack
          set s0 [getSlackPin $iPin]
          # only change the negative slack minimum slack instances
          if {($s0 != "NA") && ($s0 != "INFINITY") && [expr $cond] } {

            # get the initial leakage
            set leak0 [getLeakagePowerLibCell $cellname0]
            set lbool 1
            set P0 [gsLocalPower $iPin]
            set S0 [gsLocalSlack $iPin]
            set TS0 [gsLocalTotalSlack $iPin]
            set move0 NULL
            set fit0 [$fitness $iPin]

            
            # start from minimum size
            while {1} {
              set cellnameL [get_property $cgate ref_lib_cell_name]
              downsize $gname
              set cellnameN [get_property $cgate ref_lib_cell_name]
              if {$cellnameN == $cellnameL} {
                break
              }
              
            }

            # find the best option
            while {1} {
              set cellnameM [get_property $cgate ref_lib_cell_name]
              if {$cellnameM != $cellname0} {
                set fitN [$fitness $iPin]
                #puts "$fitN > $fit0"
                if { $fitN > $fit0 } {
                  set fit0 $fitN
                  set move0 $cellnameM
                }
              }
              upsize $gname
              set cellnameN [get_property $cgate ref_lib_cell_name]
              if {$cellnameN == $cellnameM} {
                break
              }
            }
            ecoChangeCell -inst $gname -cell $cellname0
            if { $move0 != "NULL" } {
              lappend moves [list $gname $move0 $fit0]
            }
          }
        }
      }
    }
    set moved [list]
    set moves [lsort -real -index 2 -decreasing $moves]
    puts "[llength $moves] available moves"
    set nChanges 0
    foreach st $moves {
      set gname [lindex $st 0]
      set cellnameN [lindex $st 1]
      #puts $fid "       $gname $cellnameN [lindex $st 2]"
  
      
      ecoChangeCell -inst $gname -cell $cellnameN
      lappend moved $gname
      
      incr nChanges 1
      if {$nChanges >= $maxChanges} {
        break
      }
    }
    
    # remove the processed moves
    set pcoll {}
    foreach modGate $moved {
      #puts "Processing moved gate $modGate"
      set cg [get_cell $modGate]
      set mcl [all_fanin -levels 15 -only_cells -to ${modGate}/*]
      # find a 5 level region around it
      append_to_collection mcl [all_fanout -levels 15 -only_cells -from ${modGate}/*]
      foreach_in_collection cgc $mcl {
        set cgate [get_property $cgc hierarchical_name]
        #puts "  processing neighbor $cgate to pcoll"
        # add pins to be recomputed
             
        set op_coll [get_pins "${cgate}/*" -filter "direction==out"]
        add_to_collection $pcoll $op_coll

        #foreach_in_collection cp $op_coll {
        #  puts "  adding [get_property $cp hierarchical_name] to pcoll"
        #}   
        set lind [lsearch $moves "$cgate *"]
        if { $lind != -1 } {
          set moves [lreplace $moves $lind $lind]
        }
        
      }
    }
    
    set new_cost [$cost]
    incr iters 1
    puts $fid "   s- $iters : $new_cost [getMinSlack] [getLeakagePower] $nChanges"
    if { ($iters >= 50) || ([llength $moves] == 0) } {
      break;
    }
    
    
  }
  encMessage info 1
}


