close all;
curr_directory = pwd;
cd('/w/ee.00/puneet/liangzhe/cvx/cvx'); 
cvx_setup;
cd(curr_directory);
f_fit_DP=0;%%% 1: fitting data to functions. 0: select points
f_fit_DVFS=1; %%% 1: fitting data to functions. 0: select points
data_num=200; %%% output number of data
D1_lb=10^(-7.8); % delay lower bound
D1_ub=10^(-6.0); % delay upper bound
%%%%%%%%%Parameters ends %%%%%%%%%%%%

%%%%%%%%%%%%%%fitting for Delay and Power 
a=[];
truck_data=[];
truck_data=write_data(find(write_data(:,1)>D1_lb),1:2);
truck_data=log10(truck_data(find(truck_data(:,1)<D1_ub),1:2));
truck_data=sortrows(truck_data,1);
x=[];
y=[];
x=truck_data(:,1)';
y=truck_data(:,2);
X=[];
X=[ones(1,length(x));x;x.^2;x.^3;x.^4;x.^5;x.^6;];
X=X';
cvx_begin
    variable a(7);
    minimize ( norm(X*a-y, 2));
cvx_end
x1=[];
x1=x(1):(x(length(x))-x(1))/(data_num-1):x(length(x));
X1=[];
X1=[ones(1,length(x1));x1;x1.^2;x1.^3;x1.^4;x1.^5;x1.^6;]';
y1=[];
y1=X1*a;
figure;
plot(x1,y1,'r','linewidth',2);
fitting_data=[];
fitting_data(:,1)=x1';
fitting_data(:,2)=y1';
%%%%%%%%%%%%%select data
x=x';
min_x=min(x);
max_x=max(x);
i_d=0;
select_data=[];
for i=1:data_num
    i_d=i_d+1;
    interval1=min_x+(i-1)*(max_x-min_x)/data_num;
    interval2=min_x+i*(max_x-min_x)/data_num;
    temp_x=x(find(x>=interval1));
    temp_y=y(find(x>=interval1));
    temp_x=temp_x(find(temp_x<=interval2));
    temp_y=temp_y(find(temp_x<=interval2));
    if(isempty(temp_x))
        i_d=i_d-1;
    else
        x2=temp_x(1);
        y2=temp_y(1);
        select_data(i_d,1)=x2;
        select_data(i_d,2)=y2;
    end
end
hold on;
TP_file=['Throuput_',write_name];
plot(select_data(:,1),select_data(:,2),'*');
if(f_fit_DP)
    dlmwrite(DP_file,10.^fitting_data,'\t');
    TP_data(:,1)=1./10.^fitting_data(:,1);
    TP_data(:,2)=10.^fitting_data(:,2);
    dlmwrite(TP_file,TP_data,'\t');
else
    dlmwrite(DP_file,10.^select_data,'\t');
    TP_data(:,1)=1./10.^select_data(:,1);
    TP_data(:,2)=10.^select_data(:,2);
    dlmwrite(TP_file,TP_data,'\t');
end
%%%%%%%%%%%%%%%%%%DVFS_data
if(f_DVFS)
figure;
for ith=1:length(Th_put)
    a=[];
    truck_data=[];
    truck_data=DVFS(ith).final_data(find(DVFS(ith).final_data(:,1)<1./D1_lb),1:2);
    truck_data=log10(truck_data(find(truck_data(:,1)>1./D1_ub),1:2));
    truck_data=sortrows(truck_data,1);
    x=[];
    y=[];
    x=truck_data(:,1)';
    y=truck_data(:,2);
    X=[];
    X=[ones(1,length(x));x;x.^2;x.^3;x.^4];
    X=X';
    cvx_begin
        variable a(5);
        minimize ( norm(X*a-y, 1));
    cvx_end
    x1=[];
    x1=x(1):(x(length(x))-x(1))/(data_num-1):x(length(x));
    X1=[];
    X1=[ones(1,length(x1));x1;x1.^2;x1.^3;x1.^4;]';
    y1=[];
    y1=X1*a;
    hold on;
    plot(x1,y1,'g','linewidth',2);
    fitting_data=[];
    fitting_data(:,1)=x1';
    fitting_data(:,2)=y1';
    %%%%%DVFS select data
    x=x';
    min_x=min(x);
    max_x=max(x);
    i_d=0;
    select_DVFS_data=[];
    for i=1:data_num
        i_d=i_d+1;
        interval1=min_x+(i-1)*(max_x-min_x)/data_num;
        interval2=min_x+i*(max_x-min_x)/data_num;
        temp_x=x(find(x>=interval1));
        temp_y=y(find(x>=interval1));
        temp_x=temp_x(find(temp_x<=interval2));
        temp_y=temp_y(find(temp_x<=interval2));
        if(isempty(temp_x))
            i_d=i_d-1;
        else
            x2=temp_x(1);
            y2=temp_y(1);
            select_DVFS_data(i_d,1)=x2;
            select_DVFS_data(i_d,2)=y2;
        end
    end
    hold on;
    plot(select_DVFS_data(:,1),select_DVFS_data(:,2),'k*');
    DVFS_file=[num2str(Th_put(ith)),'_DVFS_',write_name];
    if(f_fit_DVFS)
        dlmwrite(DVFS_file,10.^fitting_data,'\t');
    else
        dlmwrite(DVFS_file,10.^select_DVFS_data,'\t');
    end
end
hold on;
plot(log10(TP_data(:,1)),log10(TP_data(:,2)));
end
