clear;
clc;
%%%%%%%%%%%%%%%%%%%%%%%%%%% Parameters for Pareto optimization%%%%%%%%%%%%%%%%%%%%%
mode = 1; %optimizing selections 1 delay and power 2 delay and area 3 power and area
max_limit_metric = 1e12; %the third metric limitation: [max araa] in mode 1, [max power] in mode 2, [max delay] in mode 3
start_t=cputime;
LDH=dlmread('898_mips_LDH'); % Read logic depth histogram 
total_gates=9240; % Total number of gates in design
depth_critical=56; %%% critical path depth
optimizing_stage=[1 2 3 4]; % number of bins divided in LDH (Must be sequency number and start from 1)
vdd_allocation=[ 1 0 0 ; 2 3 4]; % Divide multiple vdds into different bins, e.g. [1 2; 3 4] bin 1&2 use Vdd1, bin3&4 use vdd2
vt_allocation=[1 0 0; 2 3 4]; % Divide mutiple vts into different bins
devicemodel_allocation = [1 0 0;2 3 4];%%% divide multiple HGI devices into bins[1 2;3 0]bin 1 and bin 2 use model 1, bin3 use model 2
if(length( devicemodel_allocation(:,1)) > 1)
    flag_HGI = 1;
else
    flag_HGI = 0;
end
n_bins=length(optimizing_stage);
stage_weight;
if(mode == 3)
    max_limit_metric = max_limit_metric / delay_weight; %consistent with delay calculation
end

n_vdd=length(vdd_allocation(:,1));
n_vt= length(vt_allocation(:,1));
%%sizing option
flag_vdd=1; %0: constant vdd or 1: optimally picking vdd
flag_vt=1; %0:constant vt or 1: optimally picking vt
flag_plot=0; %0 : no plots, 1: show optimizing plot
%%variation
flag_var=0; %0: variation is not enabled, 1: Enable variation
p_slow=0.95; % percentage of low vdd (suffered from variation) in nominal vdd
dvt=0.05; % threshold voltage increasing due to variation, unit [V]
dw1=0.001;% gate sizes variation in percentage
ub=[1.7,0.3,2]; % upper bounds [ Vdd Vt Gate sizes (um) ]
lb=[0.4,-0.2,0.03]; % [lower bound [Vdd Vt Gate sizes (um) ]
%%%%%wire model*
flag_wire=1; % 1: enable wire model, 0: Constant wire model

L=45e-9; %%% channel length
activity=0.01;   %%% activity
wireload=1;%% multiplier for wire load 
Ci=2.57e-15*wireload; % capacitance for 1um wire
Ri=34.52*wireload; % resistance for 1um wire
input_total_area=1.764 * total_gates;%%% design area um^2
fanout=2.36;%Fan-out 
delay_upper_bound=0.7e-9;%%timing upper bound
delay_lower_bound=1e-7;%% timing lower bound
power_upper_bound = 1e-1; % design power upper bound
power_lower_bound = 1e-7; % design power lower bound

devicemodel(1).subcktname=['/app/design/puneet/projects/Shaodiwang/model/standard_model/TFET.sp'];%% model for device1 should include both NMOS and PMOS
devicemodel(2).subcktname=['/w/design/puneet/projects/Shaodiwang/model/standard_model/SOI.sp']; % model for device 2
parameter_initial = [ 1.2 0.1 1.0; 0.434 -0.15 0.3]; % initial parameter for devices Vdd, Vth, Size
devicename=['TFET_SOI']; % design number
number_sim = 3; % number of simulations performed
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% You may not need to change the following codes%%%%%%%%
save('Design_information.mat','devicemodel_allocation','optimizing_stage','Ri','Ci','input_total_area','flag_wire','fanout','wireload','activity','delay_weight','optimizing_stage_weight','flag_var','p_slow','dvt','dw1','vdd_allocation','vt_allocation','LDH','L','devicemodel','devicename','mode');
dwli=0.3;  %%% partial step in times unit
dwui=0.6;
dvi=0.005;  %%% partial voltage
Rti=10;  %%%% Trust region radius
Rt_th=4;
pd=0.5; %%% decreation speed on Rt
istart=0;
ivt=0;
    if(flag_HGI)
        area_model = fitting_HGI_interconnect_model('./nangate_TFET.data','./inv_TFET.data','./nangate.data','./inv.data' );
    else
        area_model=fitting_interconnect_model('./nangate_TFET.data','./inv_TFET.data');
    end
[min_area,temp_scale] = chip_area_model(devicemodel_allocation, area_model, lb(3)*ones(2+ 2*length(optimizing_stage), length(optimizing_stage)),optimizing_stage,optimizing_stage_weight );
[max_area,temp_scale] = chip_area_model(devicemodel_allocation, area_model, ub(3)*ones(2+ 2*length(optimizing_stage) , length(optimizing_stage)),optimizing_stage,optimizing_stage_weight );
area_scale = (max_area - min_area) /5; %%%This scale is used to scale area to the same range of delay and power
if(mode == 1)
    max_limit_metric = max_limit_metric / area_scale;
end

for i_sim = 1: number_sim
for ivd=1:1
    while( 1)
        if(ivt==1)
            ivt=0;
            break;
        end
        ivt=ivt+1;
        for iw=1:1
            X=[];
            for i_model = 1:length(devicemodel_allocation(:,1))
                for i_ss = 1:length(devicemodel_allocation(i_model,:))
                    i_stage = devicemodel_allocation(i_model,i_ss);
                    if(i_stage ==0)
                        break;
                    end
               n=2*optimizing_stage(i_stage);
               X(1,i_stage)=parameter_initial(i_model,1)+0.2*(ivd-1);
               X(2,i_stage)=parameter_initial(i_model,2)+0.05*(ivt-1);
               ub_i(1:2,i_stage)=ub(1:2);
               lb_i(1:2,i_stage)=lb(1:2);
               for iwtt=1:n/2
                    X(2+iwtt*2-1,i_stage)=parameter_initial(i_model,3);
                    X(2+iwtt*2,i_stage)=(1.0+0.5*iw)*X(2+iwtt*2-1,i_stage);
                    ub_i(2+2*iwtt-1:2+2*iwtt,i_stage)=ub(3);
                    lb_i(2+2*iwtt-1:2+2*iwtt,i_stage)=lb(3);
               end
                end
            end
           if(i_sim >1)
            for i_stage=1:n_bins
                X(1,i_stage) = next_X.X(1,i_stage);
                X(2,i_stage) = next_X.X(2,i_stage);
                for i=3:2*optimizing_stage(i_stage)+2
                    X(i,i_stage) = next_X.X(i,i_stage);
                end
            end
           end
           X(1:2,n_bins+1)=0;
           DB(1).X=X;
           istart=istart+1;
           Xc=[];
           J=[];
           nof=[];
        
%%%%%%%%%%%%%%%%%%%%%%%



%%% enviroment specification



Rt=Rti;  %%%% Trust region radius
DB(1).X(1,n_bins+1)=Rt;
sigma=1.5;%%%%minimum Rt
Resolution=0.2;

%%%%parameter calculation
spname=[num2str(1e9*L),'nm','_',num2str(activity),'_',num2str(wireload),'_',devicename,'.sp'];
resultname=[num2str(1e9*L),'nm','_',num2str(activity),'_',num2str(wireload),'_',devicename,'.mt0'];
logname=[num2str(1e9*L),'nm','_',num2str(activity),'_',num2str(wireload),'_',devicename,'.log'];
hspicerun=['hspice -i ',spname,' > ',logname];
txtname=[num2str(istart),'_',num2str(1e9*L),'nm','_',num2str(activity),'_',num2str(wireload),'_',devicename,'.txt'];
Xtxtname=[num2str(istart),'_','X_',num2str(1e9*L),'nm','_',num2str(activity),'_',num2str(wireload),'_',devicename,'.txt'];
edge=['rise'];


%%%%%wireload
%%%%%calculate the approximate delay

[Area_i,G_A] = chip_area_model(devicemodel_allocation, area_model, lb(3)*ones(2+ 2*length(optimizing_stage), length(optimizing_stage)),optimizing_stage,optimizing_stage_weight );
if(flag_wire)
    [R,C0]=interconnect_model( devicemodel_allocation, area_model,X,optimizing_stage,optimizing_stage_weight,input_total_area,Ri,Ci);
else
    C0=Ci;
    R=Ri;
end
for i_stage=1:n_bins
    n=2*optimizing_stage(i_stage);
    initial_measure_simulation;
    Delay_i(i_stage)=Delay1;
end



%%%%initial point
color_ng=['r','y'];
k=1;
nof(k)=1;
J(1,1)=log10(max(Delay_i)); %Delay J(:,1), power J(:,2), leakage J(:,4), area J(:,5) and id is J(:,3)
J_DB(1,1:n_bins)=Delay_i; %Stage delay
J(1,3)=1;
J(1,5) = Area_i / area_scale;
f=0;%%%flag 1 
%%%%pareto search starts
metric_scale = 5; % scale max delay or power up in gradient descent to avoid model error, this value will be automatically updated
while (1)
    updateinformation=['k=',num2str(k),' nof(k)=',num2str(nof(k)),' metric scale is ',num2str(metric_scale)];
    disp(updateinformation);
    if(k>75)
        break;
    end
    if(flag_plot)
        switch mode
            case 1 
                plot_x = log10(delay_weight)+J(:,1);
                plot_y = J(:,2);
            case 2
                plot_x = log10(delay_weight)+J(:,1);
                plot_y = J(:,5) ;
            case 3
                plot_x = J(:,5);
                plot_y = J(:,2);
        end
        h=plot(plot_x,plot_y,'--rs','LineWidth',2,...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor','g',...
                'MarkerSize',10);
        drawnow;
    end
    disp(updateinformation);
    if (nof(k)>2)
        nt=nof(k);
        d=zeros(nt,2);
        for i=2:nt-1
            switch mode
                case 1
                    index_com = [1 2];
                case 2
                    index_com = [1 5];
                case 3
                    index_com = [2 5];
            end
            d(i,1)= sqrt( (J(i,index_com)-J(i-1,index_com))*((J(i,index_com)-J(i-1,index_com))'))+sqrt( (J(i+1,index_com)-J(i,index_com))*((J(i+1,index_com)-J(i,index_com))'));
            d(i,2)=i;
        end
        d(1,1) = sqrt( (J(2,index_com)-J(1,index_com))*((J(2,index_com)-J(1,index_com))'));
        d(1,2) = 1;
        d(nt,1) = sqrt( (J(nt,index_com)-J(nt-1,index_com))*((J(nt,index_com)-J(nt-1,index_com))'));
        d(nt,2) = nt;
        d=sortrows(d,1);
        
        l=d(nt,2);
        Xc=DB(l).X;
        while (Xc(2,n_bins+1)==1)
            nt=nt-1;
            if(nt==0)
                f=1;
                disp('all are selected as Xc');                 
                break;                
            end
            l=d(nt,2);
            Xc=DB(l).X;
        end
        if(f==1)
            break;
        end
        switch mode
            case 1 
            if( J(nof(k),1)>log10(delay_lower_bound/delay_weight) && (J(1,1)<log10(delay_upper_bound/delay_weight) || J(1,5) > (max_limit_metric/1.5) /area_scale )&& nt>80 && d(nt,1)<Resolution)
                f=1;
                disp('finish after resolution is satisfied');
                break;
            end
            case 2
                if( J(nof(k),5) < min_area / area_scale * 1.5  && (J(1,1) > max_area / area_scale/2 || J(1,2) > log10(max_limit_metric/2) ) && nt>80 && d(nt,1)<Resolution)
                    f=1;
                    disp('finish after resolution is satisfied');
                    break;
                end
            case 3
            if( (J(nof(k),2)>log10(power_lower_bound/delay_weight) || J(nof(k),1) > log10(max_limit_metric/1.5 ) )&& J(1,2)<log10(power_upper_bound/delay_weight) && nt>80 && d(nt,1)<Resolution)
                f=1;
                disp('finish after resolution is satisfied');
                break;
            end
        end

        Delay_i(1:n_bins)=J_DB(l,1:n_bins);
        Rt=DB(l).X(1,n_bins+1);
        DB(l).X(1,n_bins+1)=Rt*pd;
        
        if(Rt<sigma)
            DB(l).X(2,n_bins+1)=1;
        end
    else 
        l=1;
        if(DB(l).X(2,n_bins+1)==1)
            l=2;
            if(nof(k)==1)
                disp('break when there is no front can be chosen as Xc');
                break;
            end
            if(DB(l).X(2,n_bins)==1)
                disp('break when there is no front can be chosen as Xc~');
                break;
            end
        end
        Xc=DB(l).X;
        
        Delay_i(1:n_bins)=J_DB(l,1:n_bins);
        Rt = DB(l).X(1,n_bins+1);
        DB(l).X(1,n_bins+1)=Rt*pd;
        
        if(Rt<sigma)
            DB(l).X(2,n_bins+1)=1;
        end
    end
    if(flag_plot)
        hold on;
        switch mode
            case 1 
                plot_x = log10(delay_weight)+J(l,1);
                plot_y = J(l,2);
            case 2
                plot_x = log10(delay_weight)+J(l,1);
                plot_y = J(l,5) ;
            case 3
                plot_x = J(l,5);
                plot_y = J(l,2);
        end
        plot(plot_x,plot_y,'--rs','LineWidth',2,...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor','r',...
                'MarkerSize',15);
        drawnow;
    end
    disp_rt=['Rt= ',num2str(Rt)];
    disp(disp_rt);
    %%%%%%%%%%%%%%%%%%%Update derivation step
    dv=dvi*(Rt/Rti)^(2/3);
    dwu=dwui*(Rt/Rti)^(2/3);
    dwl=dwli*(Rt/Rti)^(2/3);
    
    %%%%%%%delay and dynamic power partial calculation
    if(flag_wire)
        [R,C0]=interconnect_model( devicemodel_allocation, area_model,Xc,optimizing_stage,optimizing_stage_weight,input_total_area,Ri,Ci);
    else
        C0=Ci;
        R=Ri;
    end
    for i_stage=1:n_bins
        n=2*optimizing_stage(i_stage);
        n_partial=1+n+flag_vdd+flag_vt+(n+flag_vdd+flag_vt+1)*(n+flag_vdd+flag_vt)/2;
        f2=0;
        delay_and_power_partial_simulation;
        f3=0;
        leakage_calculation;
    
    if(f2==1)
        disp('faild in getting dynamic or delay partial');
        %DB(l).X(1,n_bins+1)=1;
        break;
    end
    if(f3==1)
        disp('faild in getting leakage partial');
        %DB(l).X(2,n_bins+1)=1;
        break;
    end
    Derivative(i_stage).D=D;
    Derivative(i_stage).DE=DE;
    Derivative(i_stage).LE=LE;
    end 
    if(f2||f3)
        continue;
    end
    
    fde0=0;
    [current_area, G_A] = chip_area_model(devicemodel_allocation, area_model, Xc,optimizing_stage,optimizing_stage_weight );
    for i_stage=1:n_bins
        n=2*optimizing_stage(i_stage);
        n_partial=1+n+flag_vdd+flag_vt+(n+flag_vdd+flag_vt+1)*(n+flag_vdd+flag_vt)/2;
        DE=[];
        LE=[];
        D=[];
        Derivative(i_stage).area = current_area/area_scale;
        DE=Derivative(i_stage).DE;
        D=Derivative(i_stage).D;
        LE=Derivative(i_stage).LE;
        derivation_calculation;
        Derivative(i_stage).D=D;
        Derivative(i_stage).E=E;
        Derivative(i_stage).d_D=d_D;
        Derivative(i_stage).d_D2=d_D2;
        Derivative(i_stage).d_E=d_E;
        Derivative(i_stage).d_E2=d_E2;
        Derivative(i_stage).d_A = G_A(:,i_stage)/area_scale;
    end
    
    
    if(fde0==1)
        continue;
    end
    k=k+1;  
    model_and_descent;
    if(flag_plot)
        hold on;
        switch mode
            case 1 
                plot_x = log10(delay_weight)+Jk(:,1);
                plot_y = Jk(:,2);
            case 2
                plot_x = log10(delay_weight)+Jk(:,1);
                plot_y = Jk(:,5) ;
            case 3
                plot_x = Jk(:,5);
                plot_y = Jk(:,2);
        end
        plot(plot_x ,plot_y,'rs',...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor','b',...
                'MarkerSize',10);
        drawnow;
    end
%     Jk(1:nk,3)=1:nk;
%     Jk=sortrows(Jk,1);
%     Xktemp(1:n+4,1)=Xk(1:n+4,Jk(1,3));
%     i=2;
%     while(i<=nk)  
%     if(Jk(i,2)>=Jk(i-1,2))
%         Jk(i,:)=[];
%         nk=nk-1;
%         continue;
%     end
%     Xktemp(1:n+4,i)=Xk(1:n+4,Jk(i,3));
%     i=i+1;
%     end
%     Xk=zeros(1:n+4,nk);
%     Xk(1:n+4,1:nk)=Xktemp(1:n+4,1:nk);

    %%%% test descent results
    cout_max_metric_vio =0;
    for ij=1:nk
        if(flag_plot)
            hold on;
            switch mode
            case 1 
                plot_x = log10(delay_weight)+Jk(ij,1);
                plot_y = Jk(ij,2);
            case 2
                plot_x = log10(delay_weight)+Jk(ij,1);
                plot_y = Jk(ij,5) ;
            case 3
                plot_x = Jk(ij,5);
                plot_y = Jk(ij,2);
            end
            plot(plot_x,plot_y,'rs',...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor','m',...
                'MarkerSize',10);
            drawnow;
        end
        f4=0;
        f2=0;
        if(flag_wire)
            [R,C0]=interconnect_model( devicemodel_allocation, area_model,Xkt(ij).X,optimizing_stage,optimizing_stage_weight,input_total_area,Ri,Ci);
        else
            C0=Ci;
            R=Ri;
        end
        max_D=0;
        for i_stage=1:n_bins
            n=optimizing_stage(i_stage)*2;
            Xk=Xkt(ij).X(1:n+2,i_stage);
            xk_initial_delay_estimation;
            if(Delay1>max_D)
                max_D=Delay1;
            end
        end
        if(f2==1)
            continue;
        end
        Delay1=max_D;
        current_E=0;
        current_L=0;
        for i_stage=1:n_bins
            n=optimizing_stage(i_stage)*2;
            Xk=Xkt(ij).X(1:n+2,i_stage);
            detail_delay_and_power_simulation;        
            if(f4==1 )
                disp('error in Xk');
                J(nof(k-1)+ij,1)=38;
                J(nof(k-1)+ij,2)=38;
                J(nof(k-1)+ij,3)=nof(k-1)+ij;
                J(nof(k-1)+ij,4)=38;
                J(nof(k-1)+ij,5)=38;
                DB(nof(k-1)+ij).X=Xkt(ij).X;
                J_DB(nof(k-1)+ij,1:n_bins)=38;
                break;
            end
            J_DB(nof(k-1)+ij,i_stage)=Delay2;
            current_E=current_E+optimizing_stage_weight(i_stage)*(Energy2);
            current_L=current_L+optimizing_stage_weight(i_stage)*(-Leakage2);
        end
        if(f4==1)
            continue;
        end
        max_D=max(J_DB(nof(k-1)+ij,:));
        if(max_D/Delay1>2.5 || Delay1/max_D>2.5)
            f4=1;
            delay1ne2=['delay1 and delay2 have big difference delay1=',num2str(Delay1),' delay2=',num2str(max_D)];
            disp(delay1ne2);
            J(nof(k-1)+ij,1)=38;
            J(nof(k-1)+ij,2)=38;
            J(nof(k-1)+ij,3)=nof(k-1)+ij;
            J(nof(k-1)+ij,4)=38;
            J(nof(k-1)+ij,5)=38;
            DB(nof(k-1)+ij).X=Xkt(ij).X;
            J_DB(nof(k-1)+ij,1:n_bins)=38;
        else
            disp(num2str(max_D/Delay1));
            current_E=current_E/(delay_weight*max_D)+current_L;
            if(current_E>10)
                111
            end
        end
        if(f4==1)  
            continue;
        end
        %%%Check max metric violation
        [Current_area, temp_G_A] = chip_area_model(devicemodel_allocation, area_model, Xkt(ij).X, optimizing_stage,optimizing_stage_weight );
        f5 =0 ;
        switch mode
            case 1
                if( Current_area /area_scale  > max_limit_metric )
                    f5=1;
                end
            case 2
                if( current_E > max_limit_metric )
                    f5=1;
                end
            case 3
                if( max(J_DB(nof(k-1)+ij,:)) > max_limit_metric )
                    f5=1;
                end
        end
        if (f5 ==1)
            cout_max_metric_vio = cout_max_metric_vio + 1;
            switch mode
                case 1
                    message=['violate max limit metric ', num2str(Current_area ),' > ', num2str(max_limit_metric * area_scale)];
                case 2
                    message=['violate max limit metric ', num2str(current_E ),' > ', num2str(max_limit_metric )];
                case 3
                    message=['violate max limit metric ', num2str( max(J_DB(nof(k-1)+ij,:)) * delay_weight ),' > ', num2str(max_limit_metric *delay_weight)];
            end
            disp(message);
            J(nof(k-1)+ij,1)=38;
            J(nof(k-1)+ij,2)=38;
            J(nof(k-1)+ij,3)=nof(k-1)+ij;
            J(nof(k-1)+ij,4)=38;
            J(nof(k-1)+ij,5)=38;
            DB(nof(k-1)+ij).X=Xkt(ij).X;
            J_DB(nof(k-1)+ij,1:n_bins)=38;
            continue;
        end
        %%%Pass all checks, now write valid data
        J(nof(k-1)+ij,1)=log10(max(J_DB(nof(k-1)+ij,:)));
        J(nof(k-1)+ij,2)=log10(current_E);
        J(nof(k-1)+ij,3)=nof(k-1)+ij;
        J(nof(k-1)+ij,4)=log10(current_L);
        J(nof(k-1)+ij,5) = Current_area /area_scale;
        DB(nof(k-1)+ij).X=Xkt(ij).X;
        current_time=clock;
        fprintf('current time is %i:%i\n',current_time(4),current_time(5));
        if(flag_plot)
            hold on;
            switch mode
            case 1 
                plot_x = log10(delay_weight)+J(nof(k-1)+ij,1);
                plot_y = J(nof(k-1)+ij,2);
            case 2
                plot_x = log10(delay_weight)+J(nof(k-1)+ij,1);
                plot_y = J(nof(k-1)+ij,5);
            case 3
                plot_x = J(nof(k-1)+ij,5);
                plot_y = J(nof(k-1)+ij,2);
            end
            plot(plot_x,plot_y,'rs','LineWidth',2,...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor',color_ng(mod(ij,2)+1),...
                'MarkerSize',10);
                drawnow;
        end
    end
    %%%%update metric_scale 
    if( cout_max_metric_vio / nk > 0.4)
        metric_scale = metric_scale * 0.7;
    end
    if( cout_max_metric_vio / nk < 0.1)
        metric_scale = metric_scale * 1.3;
    end
    if(metric_scale <1 )
        metric_scale = 1;
    end
%     if(metric_scale >10 )
%         metric_scale = 10;
%     end
    %%%%% dead with current results
    nof(k)=nof(k-1)+nk;
    switch mode
        case 1
            rankc1 = 1;
            rankc2 = 2;
        case 2
            rankc1 = 1;
            rankc2 = 5;
        case 3
            rankc1 = 5;
            rankc2 = 2;
    end
    Jtt=sortrows(real(J),[rankc1 3]);
    J=Jtt;
    f5=0;
    for i=1:1:nof(k)
        if(J(i,rankc1)==38)
            f5=1;
            break;
        end
    end
    if(f5==1)
        J(i:nof(k),:)=[];
        nof(k)=i-1;
    end

    i=2;

    while(i<=nof(k))
        if(J(i,rankc2)>=J(i-1,rankc2))
            J(i,:)=[];
            nof(k)=nof(k)-1;
            continue;
        end
        i=i+1;
    end
    DBtemp=[];
    J_DBtemp=[];
    for i=1:nof(k)
        DBtemp(i).X=DB(J(i,3)).X;
        J_DBtemp(i,1:n_bins)=J_DB(J(i,3),1:n_bins);
    end

    DB=[];
    DB=DBtemp;
    J_DB=[];
    J_DB=J_DBtemp;
    J(1:nof(k),3)=1:nof(k);
    if(flag_plot)
        close;
    end
    save('Current_results.mat','J','J_DB','DB','txtname','Xtxtname');
    fclose all;
end
if(k>1)
    fid=fopen(txtname,'w');
    for j=1:1:length(J(:,1))
        fprintf(fid,'%d %d %d %d\n',log10(delay_weight)+J(j,1),J(j,2),J(j,4),J(j,5)*area_scale);
    end
    fclose(fid);
    stage_delay=['stage_delay_',txtname];
    dlmwrite(stage_delay,'J_DB');
    fclose all;    
 Xtxtname=['X_',txtname];
 fid=fopen(Xtxtname,'w');
 for j=1:1:length(J(:,1))
     for i_stage=1:n_bins
         for i=1:2*optimizing_stage(i_stage)+2
             fprintf(fid,'%d ',DB(j).X(i,i_stage));
         end
     end
     fprintf(fid,'\n');
 end
 fclose(fid);
end
 
 
        end
    end
end
if(mod(i_sim,2) == 1)
    next_X = DB(2);
else
    next_X = DB(length(DB)-1);
end

end %% end sim
    
end_t=cputime;
runtime=['Run time is ',num2str(end_t-start_t),'\n'];
fprintf(runtime);
data_deal;
