% choose model for this stage
error_detect = 1;
for r_allocation = 1: length(devicemodel_allocation(:,1))
    if( length( find (devicemodel_allocation(r_allocation,:) == i_stage ) ) == 1 )
        subcktname = devicemodel(r_allocation).subcktname;
        error_detect = 0;
        break;
    end
end
if( error_detect)
    print('no model found for this bin stage');
    break;
end

fid=fopen(spname,'w');
fprintf(fid,'\n.inc ''%s'' \n',subcktname);
fprintf(fid,'\n.option converge=1\n');
fprintf(fid,'.param l=%d clock=%4.4fn cl=%d vd=%d vshift=%d rl=%d pulse=%4.4fn fanout=%3.2f ',L,clock1,C0,Xc(1,i_stage),Xc(2,i_stage),R,pulse,fanout-1); 
for i=1:n
    fprintf(fid,'w%i=%d ',i,Xc(2+i,i_stage));
end
fclose(fid);
write_derivation;  
fid=fopen(spname,'a');

fprintf(fid,'.subckt inv1 1 2 3 w=1u\nXn1 7 4 0 0 ntype Wid_ps=''2*w'' Len_ps=l\nXn2 2 8 7 0 ntype Wid_ps=''2*w'' Len_ps=l\nXp1 2 9 3 3 ptype Wid_ps=w Len_ps=l\nXp2 2 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nVtno 8 3 vshift \nVtpo 9 3 ''-vshift''\n.ends\n');
fprintf(fid,'.subckt inv2 1 2 3 w=1u\nXn 6 4 0 0 ntype Wid_ps=w Len_ps=l\nXp 6 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nRl 6 2 rl\nCl 2 0 cl\n.ends\n');
 
 fprintf(fid,'xinv100 100 1 vdr inv2 w=w1\n');
 for i=1:1:n
     if(mod(i,2))
         fprintf(fid,'xinv%i %i %i vdd inv1 w=w%i\n',i,i,i+1,i);
     else
         fprintf(fid,'xinv%i %i %i vdd inv2 w=w%i\n',i,i,i+1,i);
         if(i<n)
             fprintf(fid,'xinv%i %i %i vdr inv1 w=''fanout*w%i''\n',100+i-1,i+1,200+i,i-1);
         else
             fprintf(fid,'xinv%i %i %i vdr inv1 w=''fanout*w%i+w%i''\n',100+i-1,i+1,200+i,i-1,i-1);
         end
         
%          fprintf(fid,'c%i %i 0 0.1fF\n',100+i-1,200+i);
     end
 end


fprintf(fid,'Vdr vdr 0 DC vd\nVd vdd 0 DC vd\nVin 100 0 DC 0V\n');
fprintf(fid,'.DC sweep data=cv\n');
fprintf(fid,'.option ingold=1 brief=1 \n');
fprintf(fid,'.print par''-V(vdd)*I(Vd)'' \n');
fprintf(fid,'.end');
fclose(fid);
unix(hspicerun);

fid=fopen(logname,'r');
f3=1;
LE=[];
while(~feof(fid))
    tline=fgetl(fid);
    [t r]=strtok(tline);
    if(strcmp(t,'-v(vdd)*i(vd)'))
        f3=0;
        for i=1:n_partial
            tline=fgetl(fid);
            [t r]=strtok(tline);
            [t r]=strtok(r);
            [x status]=str2num(t);
            if(status==0)
                x=-1;
            end
            LE(i)=x;
        end
        break;
    end
end
if( min(LE)<=0)
      f3=1;
end
        
