
Rt=10;
Xc[1,:]=[ 0.8 0 1 1 1 ];
Resolution=0.5;

wireload=40;
C0=0.3e-15*wireload;
R=3*wireload;
lch=32;

nvaname=['''nTFET1.va'''];
nmodel=['nTFET'];
pmodel=['pTFET'];
pvaname=['''pTFET1.va'''];
spname=['mysp_2','.sp'];
resultname=['mysp_2','.mt0'];
u=0.1;%%%%%%%%%%%%%%%%%%%%

%%%%%%%%PARETO START
k=1;
while ( 1)
%%%%%%%%%  1 estimate Xc Delay begin

fid=fopen(spname,'w');
fprintf(fid,'\n.hdl %s\n.hdl %s\n.option post=1\n.param clock=%3.3fn cl=%e vd=%4.4f vshift=%4.4f w1=%4.4f w2=%4.4f w3=%4.4f lch=%4.4fe-7 rl=%4.4f\n',nvaname,pvaname,50000,C0,Xc(k,1), Xc(k,2), Xc(k,3),Xc(k,4),Xc(k,5),lch,R);

for i=1:1:3
    fprintf(fid,'.subckt inv%i 1 2 3\nXn 6 4 0 0 %s W=w%i Lch=lch\nXp 6 5 3 3 %s W=w%i Lch=lch\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nRl 6 2 rl \nCl 2 0 cl\n.ends\n',i,nmodel,i,pmodel,i);
end
for i=1:1:3
    fprintf(fid,'xinv%i %i %i vdd inv%i\n',i,i,i+1,i);
end

fprintf(fid,'Vd vdd 0 DC vd\nVpulse 1 0 PULSE(0,vd,10n,10p,10p,''clock/2'',clock)\n.tran ''clock/10000'' ''clock*3+10n'' \n');
%fprintf(fid,'.measure tran leakage integ I(Vd) From=''clock*2.5'' To=''clock*2.8''\n');
fprintf(fid,'.measure tran t1 trig V(1) val=''vd/2'' rise=2 targ V(4) val=''vd/2'' fall=2\n.measure tran avgpower avg p(Vd) FROM=''clock*2+10n'' TO=''clock*3+10n''\n');
fprintf(fid,'.ic v(1)=''vd/2'' v(2)=''vd/2'' v(3)=''vd/2'' v(4)=''vd/2''\n');
fprintf(fid,'.end');
fclose(fid);
hspicerun=['hspice -i ',spname];
unix(hspicerun);

for i=1:1:3
    fprintf(fid,'.subckt inv%i 1 2 3\nXn1 7 4 0 0 %s W=w%i Lch=lch\nXn2 6 4 7 0 %s W=w%i Lch=lch\nXp1 6 5 3 3 %s W=w%i Lch=lch\nXp2 6 5 3 3 %s W=w%i Lch=lch\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nRl 6 2 rl\nCl 2 0 cl\n.ends\n',i,nmodel,i,nmodel,i,pmodel,i,pmodel,i);
end
for i=1:1:3
    fprintf(fid,'xinv%i %i %i vdd inv%i\n',i,i,i+1,i);
end

fprintf(fid,'Vd vdd 0 DC vd\nVpulse 1 0 PULSE(0,vd,10n,10p,10p,''clock/2'',clock)\n.tran ''clock/10000'' ''clock*3+10n'' \n');
%fprintf(fid,'.measure tran leakage integ I(Vd) From=''clock*2.5'' To=''clock*2.8''\n');
fprintf(fid,'.measure tran t1 trig V(1) val=''vd/2'' TD=8n rise=2 targ V(4) val=''vd/2'' TD=8n fall=2\n.measure tran avgpower avg p(Vd) FROM=''clock*2+10n'' TO=''clock*3+10n''\n');
fprintf(fid,'.ic v(1)=''vd/2'' v(2)=''vd/2'' v(3)=''vd/2'' v(4)=''vd/2''\n');
fprintf(fid,'.end');
fclose(fid);
hspicerun=['hspice -i ',spname];
unix(hspicerun);




    fname=[resultname];
    fid=fopen(fname, 'r');
    p=1;
    
        x = [];
        for (j=1:4)
            tline=fgetl(fid);
        end
        [t r] = strtok(tline);
        [Delay1,status]=str2num(t);
        fclose(fid);
        if( Delay1>1e-4 || Delay < 0 || status==0)
            disp('Xc part failed');
            break;
        end
            
    
%%%%%%%%%%%%%%%% 1 estimate Xc Delay ends


    clock1=2*Delay1*20*1e9;
    fid=fopen(spname,'w');
    fprintf(fid,'\n.hdl %s\n.hdl %s\n.option post=1\n.param pulse=%3.3fn clock=%3.3fn cl=%e vd=%4.4f vshift=%4.4f w1=%4.4f w2=%4.4f w3=%4.4f lch=%4.4fe-7 rl=%4.4f\n.data cv\nvd vshift w1 w2 w3\n',nvaname,pvaname,Delay1*2*1e9,clock1,C0,Xc(k,1), Xc(k,2), Xc(k,3),Xc(k,4),Xc(k,5),lch, R);
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2), Xc(k,3),Xc(k,4),Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1)+0.2, Xc(k,2), Xc(k,3),Xc(k,4),Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2)+0.2, Xc(k,3),Xc(k,4),Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2), Xc(k,3)*2,Xc(k,4),Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2), Xc(k,3),Xc(k,4)*2,Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2), Xc(k,3),Xc(k,4),Xc(k,5)*2); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1)+0.4, Xc(k,2), Xc(k,3),Xc(k,4),Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1)+0.2, Xc(k,2)+0.2, Xc(k,3),Xc(k,4),Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1)+0.2, Xc(k,2), Xc(k,3)*2,Xc(k,4),Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1)+0.2, Xc(k,2), Xc(k,3),Xc(k,4)*2,Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1)+0.2, Xc(k,2), Xc(k,3),Xc(k,4),Xc(k,5)*2); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2)+0.4, Xc(k,3),Xc(k,4),Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2)+0.2, Xc(k,3)*2,Xc(k,4),Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2)+0.2, Xc(k,3),Xc(k,4)*2,Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2)+0.2, Xc(k,3),Xc(k,4),Xc(k,5)*2); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2), Xc(k,3)*3,Xc(k,4),Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2), Xc(k,3)*2,Xc(k,4)*2,Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2), Xc(k,3),Xc(k,4)*3,Xc(k,5)); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.\n',Xc(k,1), Xc(k,2), Xc(k,3)*2,Xc(k,4),Xc(k,5)*2); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f4f %4.4f\n',Xc(k,1), Xc(k,2), Xc(k,3),Xc(k,4)*2,Xc(k,5)*2); 
    fprintf(fid,'%4.4f %4.4f %4.4f %4.4f %4.4f\n',Xc(k,1), Xc(k,2), Xc(k,3),Xc(k,4),Xc(k,5)*3); 
   
    fprintf(fid,'.enddata\n');


    for i=1:1:3
        fprintf(fid,'.subckt inv%i 1 2 3\nXn1 7 4 0 0 %s W=w%i Lch=lch\nXn2 6 4 7 0 %s W=w%i Lch=lch\nXp1 6 5 3 3 %s W=w%i Lch=lch\nXp2 6 5 3 3 %s W=w%i Lch=lch\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nRl 6 2 rl\nCl 2 0 cl\n.ends\n',i,nmodel,i,nmodel,i,pmodel,i,pmodel,i);
    end
    for i=1:1:3
        fprintf(fid,'xinv%i %i %i vdd inv%i\n',i,i,i+1,i);
    end

    fprintf(fid,'Vd vdd 0 DC vd\nVpulse 1 0 PULSE(0,vd,10n,10p,10p,''pulse*10'',clock)\n.tran ''clock/1000'' ''clock*3+10n'' sweep data=cv\n');
    
    fprintf(fid,'.measure tran t1 trig V(1) val=''vd/2'' TD=8n rise=2 targ V(4) val=''vd/2'' TD=8n fall=2\n.measure tran dynamicpower avg p(Vd) FROM=''clock*2+9n'' TO=''clock*2+2*pulse+10n''\n.measure tran leakpower avg p(Vd) FROM=''clock*2+6*pulse+10n'' TO=''clock*2+7*pulse+10n''\n');
    fprintf(fid,'.measure tran leakage avg p(Vd) From=''clock*2+10n+16*pulse'' To=''clock*2+10n+17*pulse''\n');
    fprintf(fid,'.ic v(1)=''vd/2'' v(2)=''vd/2'' v(3)=''vd/2'' v(4)=''vd/2''\n');
    fprintf(fid,'.end');
    fclose(fid);
    hspicerun=['hspice -i ',spname];
    unix(hspicerun);

%%%%%%%%%%%%%%%%%%%% spice small range sweep end
%%%%%%%%%%%%%%%%%read2 part begin
f2=0;
    for i=1:1000
    fname=[resultname];
    fid=fopen(fname, 'r');
    p=1;
   
    if (fid ~= -1)
     x = [];
        for (j=1:6)
         tline=fgetl(fid);
        end
        p=1;
        for(j=1:21)
            tline = fgetl(fid);
            tline = fgetl(fid);
            [t r]=strtok(tline);
            [t r]=strtok(r);
            [t r]=strtok(r);
            [x,status]=str2num(t);
            if(status==0 || x<0)
                break;
                
            end
            D(p)=x;
                      
            tline = fgetl(fid);
            [t r]  = strtok(tline);
            [x,status]=str2num(t);
            if(status==0 || x>0)
                break;
               
            end
            DE(p) = -x;
           
            [t r]  = strtok(r);
            [x,status]=str2num(t);
            if(status==0 || x >0 )
                break;
            end
            LE(p) = -x;
            
            [t r]  = strtok(r);
            [x,status]=str2num(t);
            if(status==0 || x>0)
                break;
            end
            LE(p) = (LE(p)-x)/2;
            
           
            tline = fgetl(fid);
            p=p+1;
        end
        if(p<22)
            disp('faild in getting partial');
            f2=1;
        end
        fclose(fid);
        break;
        
    end
    fclose(fid);
    if(i == 1000)
        disp('faild in getting partial');
        f2=1;
    end
    end
if(f2==1)
    disp('faild in getting partial');
    break;
end
D(1:21)=log(D(1:21);

d_D(1,1)=(D(2)-D(1))/0.2;
d_D(2,1)=(D(3)-D(1))/0.2;
d_D(3,1)=(D(4)-D(1))/Xc(k,3);
d_D(4,1)=(D(5)-D(1))/Xc(k,4);
d_D(5,1)=(D(6)-D(1))/Xc(k,5); 
d_D2(1,1)= ((D(7)-D(2))/0.2-d_D(1))/0.2;
d_D2(2,1)= ((D(8)-D(2))/0.2-d_D(2))/0.2;
d_D2(3,1)= ((D(9)-D(2))/Xc(k,3)-d_D(3))/0.2;
d_D2(4,1)= ((D(10)-D(2))/Xc(k,4)-d_D(4))/0.2;
d_D2(5,1)= ((D(11)-D(2))/Xc(k,5)-d_D(5))/0.2;
d_D2(2,2)= ((D(12)-D(3))/0.2-d_D(2))/0.2;
d_D2(3,2)= ((D(13)-D(3))/Xc(k,3)-d_D(3))/0.2;
d_D2(4,2)= ((D(14)-D(3))/Xc(k,4)-d_D(4))/0.2;
d_D2(5,2)= ((D(15)-D(3))/Xc(k,5)-d_D(5))/0.2;
d_D2(3,3)= ((D(16)-D(4))/Xc(k,3)-d_D(3))/Xc(k,3);
d_D2(4,3)= ((D(17)-D(4))/Xc(k,4)-d_D(4))/Xc(k,3);
d_D2(5,3)= ((D(18)-D(4))/Xc(k,5)-d_D(5))/Xc(k,3);
d_D2(4,4)= ((D(19)-D(5))/Xc(k,4)-d_D(4))/Xc(k,4);
d_D2(5,4)= ((D(20)-D(5))/Xc(k,5)-d_D(5))/Xc(k,4);
d_D2(5,5)= ((D(21)-D(6))/Xc(k,5)-d_D(5))/Xc(k,5);
d_D2(1,2)= d_D2(2,1);
d_D2(1,3)= d_D2(3,1);
d_D2(1,4)= d_D2(4,1);
d_D2(1,5)= d_D2(5,1);
d_D2(2,3)= d_D2(3,2);
d_D2(2,4)= d_D2(4,2);
d_D2(2,5)= d_D2(5,2);
d_D2(3,4)= d_D2(4,3);
d_D2(3,5)= d_D2(5,3);
d_D2(4,5)= d_D2(5,4);
E=DE+LE%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fe=D(1);
fd=E(1);


if(n(k-1)>2)
    wp1=-J(l,2)+J(l-1,2);
    wp2=J(l,1)-J(l-1,1);
    wq1=-J(l+1,2)+J(l,2);
    wq2=J(l+1,1)-J(l,1);
    cp=wp1+wp2;
    cq=wq1+wq2;
    d_Dp=wp1/cp*d_D;
    d_D2p=wp1/cp*d_D2;
    fdp=wp1/cp*fd;
    d_Ep=wp2/cp*d_E;
    d_E2p=wp2/cp*d_E2;
    fep=wp2/cp*fe;
    
    d_p=d_Dp+d_Ep;
    d_2p=d_D2p+d_E2p;
    fp=fdp+fep;
    
    d_Dq=wq1/cq*d_D;
    d_D2q=wq1/cq*d_D2;
    fdq=wq1/cq*fd;
    d_Eq=wq2/cq*d_E;
    d_E2q=wq2/cq*d_E2;
    feq=wq2/cq*fe;
    
    d_q=d_Dq+d_Eq;
    d_2q=d_D2q+d_E2q;
    fq=fdq+feq;
    
    (Xtemp,ntemp)=Gradient(d_D, d_D2, Xc(k,1:5)', fd, Rt, d_D, d_D2, fd, d_E, d_E2, fe);
    Xk=Xtemp;
    nk=ntemp;
    (Xtemp,ntemp)=Gradient(d_E, d_E2, Xc(k,1:5)', fe, Rt, d_D, d_D2, fd, d_E, d_E2, fe);
    Xk(1:5,(nk+1):(nk+ntemp))=Xtemp(1:5);
    nk=nk+ntemp;
    (Xtemp,ntemp)=Gradient(d_p, d_2p, Xc(k,1:5)', fp, Rt, d_D, d_D2, fd, d_E, d_E2, fe);
    Xk(1:5,(nk+1):(nk+ntemp))=Xtemp(1:5);
    nk=nk+ntemp;
     (Xtemp,ntemp)=Gradient(d_q, d_2q, Xc(k,1:5)', fq, Rt, d_D, d_D2, fd, d_E, d_E2, fe);
    Xk(1:5,(nk+1):(nk+ntemp))=Xtemp(1:5);
    nk=nk+ntemp;
    Xk(6:7,:)=0;
else
    if(n(k-1)==2)
        wp1=-J(2,2)+J(1,2);
        wp2=J(2,1)-J(1,1);
        cp=wp1+wp2;
        d_Dp=wp1/cp*d_D;
        d_D2p=wp1/cp*d_D2;
        fdp=wp1/cp*fd;
        d_Ep=wp2/cp*d_E;
        d_E2p=wp2/cp*d_E2;
        fep=wp2/cp*fe;
    
        d_p=d_Dp+d_Ep;
        d_2p=d_D2p+d_E2p;
        fp=fdp+fep;
        (Xtemp,ntemp)=Gradient(d_D, d_D2, Xc(k,1:5)', fd, Rt, d_D, d_D2, fd, d_E, d_E2, fe);
        Xk=Xtemp;
        nk=ntemp;
        (Xtemp,ntemp)=Gradient(d_E, d_E2, Xc(k,1:5)', fe, Rt, d_D, d_D2, fd, d_E, d_E2, fe);
        Xk(1:5,(nk+1):(nk+ntemp))=Xtemp(1:5);
        nk=nk+ntemp;
        (Xtemp,ntemp)=Gradient(d_p, d_2p, Xc(k,1:5)', fp, Rt, d_D, d_D2, fd, d_E, d_E2, fe);
        Xk(1:5,(nk+1):(nk+ntemp))=Xtemp(1:5);
        nk=nk+ntemp;
        Xk(6:7,:)=0;
    else
        wp1=0.5;
        wp2=0.5;
        cp=wp1+wp2;
        d_Dp=wp1/cp*d_D;
        d_D2p=wp1/cp*d_D2;
        fdp=wp1/cp*fd;
        d_Ep=wp2/cp*d_E;
        d_E2p=wp2/cp*d_E2;
        fep=wp2/cp*fe;
    
        d_p=d_Dp+d_Ep;
        d_2p=d_D2p+d_E2p;
        fp=fdp+fep;
        
        (Xtemp,ntemp)=Gradient(d_D, d_D2, Xc(k,1:5)', fd, Rt, d_D, d_D2, fd, d_E, d_E2, fe);
        Xk=Xtemp;
        nk=ntemp;
        (Xtemp,ntemp)=Gradient(d_E, d_E2, Xc(k,1:5)', fe, Rt, d_D, d_D2, fd, d_E, d_E2, fe);
        Xk(1:5,(nk+1):(nk+ntemp))=Xtemp(1:5);
        nk=nk+ntemp;
        (Xtemp,ntemp)=Gradient(d_p, d_2p, Xc(k,1:5)', fp, Rt, d_D, d_D2, fd, d_E, d_E2, fe);
        Xk(1:5,(nk+1):(nk+ntemp))=Xtemp(1:5);
        nk=nk+ntemp;
        Xk(6:7,:)=0;
    end
end
f2=0;


%%%%%%%%%%%%%%%%%%%%% Evaluate Xk %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for i=1:nk
    fid=fopen(spname,'w');
    fprintf(fid,'\n.hdl %s\n.hdl %s\n.option post=1\n.param clock=%3.3fn cl=%e vd=%4.4f vshift=%4.4f w1=%4.4f w2=%4.4f w3=%4.4f lch=%4.4fe-7 rl=%4.4f\n',nvaname,pvaname,50000,C0,Xk(1,i), Xk(2,i), Xk(3,i),Xk(4,i),Xk(5,i),lch,R);

for i=1:1:3
    fprintf(fid,'.subckt inv%i 1 2 3\nXn 6 4 0 0 %s W=w%i Lch=lch\nXp 6 5 3 3 %s W=w%i Lch=lch\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nRl 6 2 rl \nCl 2 0 cl\n.ends\n',i,nmodel,i,pmodel,i);
end
for i=1:1:3
    fprintf(fid,'xinv%i %i %i vdd inv%i\n',i,i,i+1,i);
end

fprintf(fid,'Vd vdd 0 DC vd\nVpulse 1 0 PULSE(0,vd,10n,10p,10p,''clock/2'',clock)\n.tran ''clock/10000'' ''clock*3+10n'' \n');
%fprintf(fid,'.measure tran leakage integ I(Vd) From=''clock*2.5'' To=''clock*2.8''\n');
fprintf(fid,'.measure tran t1 trig V(1) val=''vd/2'' rise=2 targ V(4) val=''vd/2'' fall=2\n.measure tran avgpower avg p(Vd) FROM=''clock*2+10n'' TO=''clock*3+10n''\n');
fprintf(fid,'.ic v(1)=''vd/2'' v(2)=''vd/2'' v(3)=''vd/2'' v(4)=''vd/2''\n');
fprintf(fid,'.end');
fclose(fid);
hspicerun=['hspice -i ',spname];
unix(hspicerun);
fname=[resultname];
    fid=fopen(fname, 'r');
    p=1;
    
        x = [];
        for (j=1:4)
            tline=fgetl(fid);
        end
        [t r] = strtok(tline);
        [Delay1,status]=str2num(t);
        fclose(fid);
        if( Delay1>1e-4 || Delay < 0 || status==0)
            disp('Xk part failed');
            f2=1;
            break;
        end
        
         fid=fopen(spname,'w');
        fprintf(fid,'\n.hdl %s\n.hdl %s\n.option post=1\n.param pulse=%3.3fn clock=%3.3fn cl=%e vd=%4.4f vshift=%4.4f w1=%4.4f w2=%4.4f w3=%4.4f lch=%4.4fe-7 rl=%4.4f\n',nvaname,pvaname,Delay1*1e9/u,Delay1*2e9/u,C0,Xk(1,i), Xk(2,i), Xk(3,i),Xk(4,i),Xk(5,i),lch,R);


    for i=1:1:3
        fprintf(fid,'.subckt inv%i 1 2 3\nXn1 7 4 0 0 %s W=w%i Lch=lch\nXn2 6 4 7 0 %s W=w%i Lch=lch\nXp1 6 5 3 3 %s W=w%i Lch=lch\nXp2 6 5 3 3 %s W=w%i Lch=lch\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nRl 6 2 rl\nCl 2 0 cl\n.ends\n',i,nmodel,i,nmodel,i,pmodel,i,pmodel,i);
    end
    for i=1:1:3
        fprintf(fid,'xinv%i %i %i vdd inv%i\n',i,i,i+1,i);
    end

    fprintf(fid,'Vd vdd 0 DC vd\nVpulse 1 0 PULSE(0,vd,10n,10p,10p,pulse,clock)\n.tran ''clock/1000'' ''clock*3+10n'' \n');
    %fprintf(fid,'.measure tran leakpower integ i(Vd) FROM=5n TO=9n\n');
    fprintf(fid,'.measure tran leakpower avg p(Vd) FROM=''clock*2.3+10n+10p'' TO=''clock*2.4+10n+10p''\n');

    fprintf(fid,'.measure tran t1 trig V(1) val=''vd/2'' TD=8n rise=2 targ V(4) val=''vd/2'' TD=8n fall=2');
    %fprintf(fid,'\n.measure tran avgpower integ i(Vd) FROM=''clock*2+9n'' TO=''clock*3+9n''\n');
    fprintf(fid,'\n.measure tran avgpower avg p(Vd) FROM=''clock*2+9n'' TO=''clock*3+9n''\n');
    fprintf(fid,'.ic v(1)=''vd/2'' v(2)=''vd/2'' v(3)=''vd/2'' v(4)=''vd/2''\n');
    fprintf(fid,'.end');
    fclose(fid);
    hspicerun=['hspice -i ',spname];
    unix(hspicerun);
%%%%%%%%%%%%%%%%%%%% Result Spice part end

%%%%%%%%%%%%%%%%%%%  Result read part
    
    for i=1:1000
        fname=[resultname];
        fid=fopen(fname, 'r');
        p=1;
        if (fid ~= -1)
            x = [];
            for (j=1:5)
                tline=fgetl(fid);
            end
            [t r] = strtok(tline);
            if(~ischar(t))
                f2=1;
                fclose(fid);
                break;
            end
            [Leakage2,status]=str2num(t);
                    
            [t r] = strtok(r);
            if(~ischar(t))
                f2=1;
                fclose(fid);
                break;
            end
            [Delay2,status]=str2num(t);
            if(status==0)
                f2=1;
                break;
            end
            if(Delay2<=0)
                f2=1;
            end
            
            [t r] = strtok(r);
            if(~ischar(t))
                f2=1;
                fclose(fid);
                break;
            end
            [Energy2,status]=str2num(t);
            if(status==0)
                f2=1;
                break;
            end
            if(Energy2>=0)
                f2=1;
                break;
            end   
            fclose(fid);
            break;
        end
        fclose(fid);
        if(i == 1000)
        disp('can not open result in Xk');
        
        f2=1;
        end
    end
    if(f2==1)
        disp('error in Xk');
        break;
    end
    J(n(k-1)+i,1)=Delay2;
    J(n(k-1)+i,2)=Energy2;
    J(n(k-1)+i,3)=n(k-1)+i;
    X(1:7,n(k-1)+i)=Xk(1:7,i);
end

n(k)=n(k-1)+nk;

J=sortrows(1);
i=2;
while(i<=n(k))
    if(J(i,2)>J(i-1,2))
        J(i,:)=[];
        n(k)=n(k)-1;
        continue;
    end
    i=i+1;
end
Xtemp=zeros(1:7,n(k));
for (i=1:n(k))
    Xtemp(1:7,i)=X(1:7,J(i,3));
end

X(1:7,1:n(k))=Xtemp;
X(:,n(k)+1:n(k-1)+nk)=[];

end




        
