clear;
load('Design_information.mat');

n_vdd=12;
L_vdd=0.5;
optimized_stage=optimizing_stage;
n_stage=length(optimized_stage);
%%%%%%%%


%%%%%%%%%%

%filename=['final_45nm_0.01_1_TFET.txt'];
filename=['final_',num2str(1e9*L),'nm','_',num2str(activity),'_1_',devicename,'.txt'];


%%%%%%%%%%%%%%%%%%%%%%
spname=['scale.sp'];
resultname=['scale.mt0'];
logname=['scale.log'];
hspicerun=['hspice -i ',spname,' > ',logname];

n_failure_DVFS=0;
Data=dlmread(filename);
for i_stage=1:length(optimized_stage)
    for j=1:2*optimized_stage(i_stage)
        wrong_c=find(Data(:,4+2*i_stage+sum(2*optimized_stage(1:i_stage-1))+j)<0);
        Data(wrong_c,:)=[];
    end
end
i=length(Data(1,:));
while(i>0)
    if(Data(:,i)>0)
        break;
    end
    i=i-1;
end
if(i<length(Data(1,:)))
    Data(:,i+1:length(Data(1,:)))=[];
end
n=length(Data(1,:))-5;
edge=['rise'];


for jj=1:length(Data(:,1))
    processing=['Processing ',num2str(jj),'/',num2str(length(Data(:,1))),'\n'];
    disp(processing);
    f=0;
    vdd3=[];
    power3=[];
    leakage3=[];
    delay3=[];
    if(flag_wire)
        for i_stage=1:length(optimizing_stage)
            Xc(1:2+2*optimizing_stage(i_stage),i_stage)=Data(jj,4+2*(i_stage-1)+sum(optimizing_stage(1:i_stage-1))*2+1:4+2*(i_stage-1)+sum(optimizing_stage(1:i_stage-1))*2+2+optimizing_stage(i_stage)*2);
        end
        [R,C0]=interconnect_model( devicemodel_allocation, area_model,Xc,optimizing_stage,optimizing_stage_weight,input_total_area,Ri,Ci);
    else
        C0=Ci;
        R=Ri;
    end
    
    for i_stage=1:length(optimized_stage)
        % choose model for this stage
        cmd = ['rm ',resultname];
        unix (cmd);
        error_detect = 1;
        for r_allocation = 1: length(devicemodel_allocation(:,1))
            if( length( find (devicemodel_allocation(r_allocation,:) == i_stage ) ) == 1 )
                subcktname = devicemodel(r_allocation).subcktname;
                error_detect = 0;
                break;
            end
        end
        if( error_detect)
            print('no model found for this bin stage');
            break;
        end
    
        n=optimized_stage(i_stage)*2;
        C_vdd=Data(jj,4+2*(i_stage-1)+sum(optimized_stage(1:i_stage-1))*2+1);
        X(1:n+2,1)=Data(jj,4+2*(i_stage-1)+sum(optimized_stage(1:i_stage-1))*2+1:4+2*(i_stage-1)+sum(optimized_stage(1:i_stage-1))*2+2+n);
%%%%%%%%%%%%%%%%%%%%%%%%Delay initial testing
        
        
        fid=fopen(spname,'w');
        fprintf(fid,'\n.inc ''%s'' \n',subcktname);
        fprintf(fid,'\n.option converge=0 cptime=360\n');
        fprintf(fid,'.param l=%d clock=%4.4fn cl=%d vd=%d vshift=%d rl=%d fanout=%3.2f ',L,min(100000,500*10^Data(jj,1)/delay_weight*1e9),C0,X(1,1),X(2,1),R,fanout-1);
        for i=1:n
            fprintf(fid,'w%i=%d ',i,X(2+i,1));
        end
        fprintf(fid,'\n.data sweepvd\nvd');
        for sweep_vdd = C_vdd: -(C_vdd-L_vdd)/n_vdd:L_vdd
            fprintf(fid,'\n %d',sweep_vdd);
        end
        fprintf(fid,'\n.enddata\n');
        if(flag_var)
            fprintf(fid,'.subckt inv1_s 1 2 3 dvt=0 w=1u\nXn1 7 4 0 0 ntype Wid_ps=''2*w'' Len_ps=l\nXn2 2 8 7 0 ntype Wid_ps=''2*w'' Len_ps=l\nXp1 2 9 3 3 ptype Wid_ps=w Len_ps=l\nXp2 2 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 ''dvt+vshift''\nVtp 5 1 ''-dvt-vshift'' \nVtno 8 3 ''dvt+vshift'' \nVtpo 9 3 ''-dvt-vshift''\n.ends\n');
            fprintf(fid,'.subckt inv2_s 1 2 3 dvt=0 w=1u\nXn 6 4 0 0 ntype Wid_ps=w Len_ps=l\nXp 6 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 ''dvt+vshift''\nVtp 5 1 ''-dvt-vshift'' \nRl 6 2 rl\nCl 2 0 cl\n.ends\n');
            fprintf(fid,'xinv100_s 100_s 1_s vdr_s inv2_s w=''w1-%4.4f'' dvt=%3.3f\n',dw1,dvt);
            for i=1:1:n
                if(mod(i,2))
                    fprintf(fid,'xinv%i_s %i_s %i_s vdd_s inv1_s w=''w%i-%4.4f'' dvt=%3.3f\n',i,i,i+1,i,dw1,dvt);
                else
                    fprintf(fid,'xinv%i_s %i_s %i_s vdd_s inv2_s w=''w%i-%4.4f'' dvt=%3.3f\n',i,i,i+1,i,dw1,dvt);
                    if(i<n)
                        fprintf(fid,'xinv%i_s %i_s %i_s vdr_s inv1_s w=''fanout*w%i-fanout*%4.4f'' dvt=%3.3f\n',100+i-1,i+1,200+i,i-1,dw1,dvt);
                    else
                        fprintf(fid,'xinv%i_s %i_s %i_S vdr_s inv1_s w=''fanout*w%i+w%i-%4.4f-fanout*%4.4f'' dvt=%3.3f\n',100+i-1,i+1,200+i,i-1,i-1,dw1,dw1,dvt);
                    end         
                end
            end
            fprintf(fid,'Vdr_s vdr_s 0 DC=''vd*%2.2f''\nVd_s vdd_s 0 DC=''vd*%2.2f''\nVpulse_s 100_s 0 PULSE(0,''vd*%2.2f'',10n,10p,10p,''clock/2'',clock)\n.tran ''clock/100000'' ''clock*3+10n'' sweep data=sweepvd \n',p_slow,p_slow,p_slow);
        else
            fprintf(fid,'.subckt inv1 1 2 3 w=1u\nXn1 7 4 0 0 ntype Wid_ps=''2*w'' Len_ps=l\nXn2 2 8 7 0 ntype Wid_ps=''2*w'' Len_ps=l\nXp1 2 9 3 3 ptype Wid_ps=w Len_ps=l\nXp2 2 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nVtno 8 3 vshift \nVtpo 9 3 ''-vshift''\n.ends\n');
            fprintf(fid,'.subckt inv2 1 2 3 w=1u\nXn 6 4 0 0 ntype Wid_ps=w Len_ps=l\nXp 6 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nRl 6 2 rl\nCl 2 0 cl\n.ends\n');
            fprintf(fid,'xinv100 100 1 vdr inv2 w=w1\n');
            for i=1:1:n
                if(mod(i,2))
                    fprintf(fid,'xinv%i %i %i vdd inv1 w=w%i\n',i,i,i+1,i);
                else
                    fprintf(fid,'xinv%i %i %i vdd inv2 w=w%i\n',i,i,i+1,i);
                    if(i<n)
                        fprintf(fid,'xinv%i %i %i vdr inv1 w=''fanout*w%i''\n',100+i-1,i+1,200+i,i-1);
                    else
                        fprintf(fid,'xinv%i %i %i vdr inv1 w=''fanout*w%i+w%i''\n',100+i-1,i+1,200+i,i-1,i-1);
                    end
                end
            end
            fprintf(fid,'Vdr vdr 0 DC vd\nVd vdd 0 DC vd\nVpulse 100 0 PULSE(0,vd,10n,10p,10p,''clock/2'',clock)\n.tran ''clock/10000'' ''clock*3+10n'' sweep data=sweepvd \n');
        end

        if(flag_var)
            fprintf(fid,'.measure tran t1 trig V(1_s) val=''%2.2f*vd/2'' TD=''10n+clock/4'' rise=2 targ V(%i_s) val=''%2.2f*vd/2'' TD=''10n+clock/4'' %s=2\n',p_slow,n+1,p_slow,edge);
        else
            fprintf(fid,'.measure tran t1 trig V(1) val=''vd/2'' TD=''10n+clock/4'' rise=2 targ V(%i) val=''vd/2'' TD=''10n+clock/4'' %s=2\n',n+1,edge);
        end
        fprintf(fid,'.ic ');
        if(flag_var)
            fprintf(fid,'v(100_s)=0 ');
            for i=1:n
                if(mod(i,2)==0)
                    fprintf(fid,'v(%i_s)=0 ',i);
                else
                    fprintf(fid,'v(%i_s)=''vd*%2.2f'' ',i,p_slow);
                end
            end
        else
            fprintf(fid,'v(100)=0 ');
            for i=1:n
                if(mod(i,2)==0)
                    fprintf(fid,'v(%i)=0 ',i);
                else
                    fprintf(fid,'v(%i)=''vd'' ',i);
                end
            end
        end

        fprintf(fid,'\n');
        fprintf(fid,'.end');
        fclose(fid);
        unix(hspicerun);
    
        fid=fopen(resultname, 'r');
        p=1;
        
        if(fid==-1)
            f=1;
            break;
        end
        x = [];
        vdd2=[];
        delay2=[];
        for j=1:4
            tline=fgetl(fid);
        end
        if(tline~=-1)	
            for j=1:n_vdd
                tline=fgetl(fid);
                [t r] = strtok(tline);
                [t r] = strtok(r);
                if(t==-1)
                    tline=fgetl(fid);
                    continue;
                end
                [vdd1,status]=str2num(t);
                if(status==0)
                    tline=fgetl(fid);
                    continue;
                end
                [t r] = strtok(r);
                [Delay1,status]=str2num(t);
                if( ((status==0)|| Delay1>1e-4) || (Delay1<0) )
                    tline=fgetl(fid);
                    continue;
                end
                i=length(vdd2);
                i=i+1;
                vdd2(i)=vdd1;
                delay2(i)=Delay1;
                tline=fgetl(fid);
            end
        end
        fclose(fid);
        vdd3(i_stage,1:length(vdd2))=vdd2;
        delay3(i_stage,1:length(delay2))=delay2;
%         if(length(vdd2)==0)
%             Scaling(jj).Vdd(1)=C_vdd;
%             Scaling(jj).Power(1)=-1;
%             Scaling(jj).Leakage=-1;
%             Scaling.(jj).Delay=10^Data(jj,1);
%         end
    end
    
    for i_stage=1:length(optimized_stage)
        cmd = ['rm ',logname];
        unix (cmd);
        if( f == 1)
            break;
        end
        % choose model for this stage
        error_detect = 1;
        for r_allocation = 1: length(devicemodel_allocation(:,1))
            if( length( find (devicemodel_allocation(r_allocation,:) == i_stage ) ) == 1 )
                subcktname = devicemodel(r_allocation).subcktname;
                error_detect = 0;
                break;
            end
        end
        if( error_detect)
            print('no model found for this bin stage');
            break;
        end
%%%%%%%%%%%%%%%%%%%%Leakage evaluation
        n=optimized_stage(i_stage)*2;
        C_vdd=Data(jj,4+2*(i_stage-1)+sum(optimized_stage(1:i_stage-1))*2+1);
        X(1:n+2,1)=Data(jj,4+2*(i_stage-1)+sum(optimized_stage(1:i_stage-1))*2+1:4+2*(i_stage-1)+sum(optimized_stage(1:i_stage-1))*2+2+n);
        vdd2=[];
        delay2=[];
        vdd2=vdd3(i_stage,1:length(find(vdd3(i_stage,:)>0)));
        delay2=delay3(i_stage,1:length(find(delay3(i_stage,:)>0)));
        if(length(delay2)==0)
            f=1;
            break;
        end
        fid=fopen(spname,'w');
        fprintf(fid,'\n.inc ''%s'' \n',subcktname);
        fprintf(fid,'.option converge=0\n');
        fprintf(fid,'.param l=%d pulse=%4.4fn clock=%4.4fn cl=%d vd=%d vshift=%d rl=%d fanout=%3.2f ',L,delay2(1)*3e9,delay2(1)*6e9/activity,C0,X(1,1),X(2,1),R,fanout-1);
        for i=1:n
            fprintf(fid,'w%i=%d ',i,X(2+i,1));
        end
        fprintf(fid,'\n');
        fprintf(fid,'\n.data cv\nvd\n');
        for i=1:length(vdd2)
            fprintf(fid,'%4.4f\n',vdd2(i));
        end
        fprintf(fid,'\n.enddata\n');

        fprintf(fid,'.subckt inv1 1 2 3 w=1u\nXn1 7 4 0 0 ntype Wid_ps=''2*w'' Len_ps=l\nXn2 2 8 7 0 ntype Wid_ps=''2*w'' Len_ps=l\nXp1 2 9 3 3 ptype Wid_ps=w Len_ps=l\nXp2 2 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nVtno 8 3 vshift \nVtpo 9 3 ''-vshift''\n.ends\n');
        fprintf(fid,'.subckt inv2 1 2 3 w=1u\nXn 6 4 0 0 ntype Wid_ps=w Len_ps=l\nXp 6 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nRl 6 2 rl\nCl 2 0 cl\n.ends\n');
 
        fprintf(fid,'xinv100 100 1 vdr inv2 w=w1\n');
        for i=1:1:n
            if(mod(i,2))
                fprintf(fid,'xinv%i %i %i vdd inv1 w=w%i\n',i,i,i+1,i);
            else
                fprintf(fid,'xinv%i %i %i vdd inv2 w=w%i\n',i,i,i+1,i);
                if(i<n)
                    fprintf(fid,'xinv%i %i %i vdr inv1 w=''fanout*w%i''\n',100+i-1,i+1,200+i,i-1);
                else
                    fprintf(fid,'xinv%i %i %i vdr inv1 w=''fanout*w%i+w%i''\n',100+i-1,i+1,200+i,i-1,i-1);
                end
            end
        end


        fprintf(fid,'Vdr vdr 0 DC vd\nVd vdd 0 DC vd\nVin 100 0 DC 0V\n');
        fprintf(fid,'.DC sweep data=cv\n');
        fprintf(fid,'.option ingold=1 brief=1 \n');
        fprintf(fid,'.print par''V(vdd)*I(Vd)'' \n');
        fprintf(fid,'.end');
        fclose(fid);
        unix(hspicerun);
    
    
        leakage2=[];
        fid=fopen(logname,'r');
        if(fid==-1)
            f=1;
            break;
        end
        while(~feof(fid))
            tline=fgetl(fid);
            [t r]=strtok(tline);
            if(strcmp(t,'v(vdd)*i(vd)'))
                for i=1:length(vdd2)
                    tline=fgetl(fid);
                    [t r]=strtok(tline);
                    [t r]=strtok(r);
                    [x status]=str2num(t);
                    if(status~=0)
                        leakage2(i)=-x;
                    else
                        leakage2(i)=-1;
                    end
                end
                break;
            end
        end
        fclose(fid);
        i=1;
        if(length(leakage2)==0)
            Scaling_VDD(1,jj)=C_vdd;
            Scaling_Power(1,jj)=10^Data(jj,2);
            Scaling_Leakage(1,jj)=10^Data(jj,3);
            Scaling_Delay(1,jj)=10^Data(jj,1);
            f=1;
            break;
        end
            
        while(i<=length(vdd2))
            if(leakage2(i)<0)
                leakage2(i)=[];
                vdd2(i)=[];
                delay2(i)=[];
            else
                i=i+1;
            end
        end
    if(length(vdd2)==0)
        Scaling_VDD(1,jj)=C_vdd;
        Scaling_Power(1,jj)=10^Data(jj,2);
        Scaling_Leakage(1,jj)=10^Data(jj,3);
        Scaling_Delay(1,jj)=10^Data(jj,1);
        f=1;
        break;
    end
        cmd = ['rm ',resultname];
        unix (cmd);
    %%%%%%%%%%%%%%%%%%%%%%Power,delay evaluation versus vdd
        fid=fopen(spname,'w');
        fprintf(fid,'\n.inc ''%s'' \n',subcktname);
        fprintf(fid,'.option converge=0 cputime=360\n');
        fprintf(fid,'.param l=%d pulse=%4.4fn clock=%4.4fn cl=%d vd=%d vshift=%d rl=%d fanout=%3.2f ',L,delay2(1)*3e9,delay2(1)*6e9,C0,X(1,1),X(2,1),R,fanout-1);
        for i=1:n
            fprintf(fid,'w%i=%d ',i,X(2+i,1));
        end
        fprintf(fid,'\n');
        fprintf(fid,'\n.data cv\nvd clock\n');
        for i=1:length(vdd2)
            fprintf(fid,'%4.4f %d\n',vdd2(i),delay2(i)*6);
        end
        fprintf(fid,'\n.enddata\n');

        fprintf(fid,'.subckt inv1 1 2 3 w=1u\nXn1 7 4 0 0 ntype Wid_ps=''2*w'' Len_ps=l\nXn2 2 8 7 0 ntype Wid_ps=''2*w'' Len_ps=l\nXp1 2 9 3 3 ptype Wid_ps=w Len_ps=l\nXp2 2 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nVtno 8 3 vshift \nVtpo 9 3 ''-vshift''\n.ends\n');
        fprintf(fid,'.subckt inv2 1 2 3 w=1u\nXn 6 4 0 0 ntype Wid_ps=w Len_ps=l\nXp 6 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 vshift\nVtp 5 1 ''-vshift'' \nRl 6 2 rl\nCl 2 0 cl\n.ends\n'); 
        fprintf(fid,'xinv100 100 1 vdr inv2 w=w1\n');
        for i=1:1:n
            if(mod(i,2))
                fprintf(fid,'xinv%i %i %i vdd inv1 w=w%i\n',i,i,i+1,i);
            else
                fprintf(fid,'xinv%i %i %i vdd inv2 w=w%i\n',i,i,i+1,i);
                if(i<n)
                    fprintf(fid,'xinv%i %i %i vdr inv1 w=''fanout*w%i''\n',100+i-1,i+1,200+i,i-1);
                else
                    fprintf(fid,'xinv%i %i %i vdr inv1 w=''fanout*w%i+w%i''\n',100+i-1,i+1,200+i,i-1,i-1);
                end
            end
        end

        if(flag_var)
            fprintf(fid,'.subckt inv1_s 1 2 3 dvt=0 w=1u\nXn1 7 4 0 0 ntype Wid_ps=''2*w'' Len_ps=l\nXn2 2 8 7 0 ntype Wid_ps=''2*w'' Len_ps=l\nXp1 2 9 3 3 ptype Wid_ps=w Len_ps=l\nXp2 2 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 ''dvt+vshift''\nVtp 5 1 ''-dvt-vshift'' \nVtno 8 3 ''dvt+vshift'' \nVtpo 9 3 ''-dvt-vshift''\n.ends\n');
            fprintf(fid,'.subckt inv2_s 1 2 3 dvt=0 w=1u\nXn 6 4 0 0 ntype Wid_ps=w Len_ps=l\nXp 6 5 3 3 ptype Wid_ps=w Len_ps=l\nVtn 4 1 ''dvt+vshift''\nVtp 5 1 ''-dvt-vshift'' \nRl 6 2 rl\nCl 2 0 cl\n.ends\n');
            fprintf(fid,'xinv100_s 100_s 1_s vdr_s inv2_s w=''w1-%4.4f'' dvt=%3.3f\n',dw1,dvt);
            for i=1:1:n
                if(mod(i,2))
                    fprintf(fid,'xinv%i_s %i_s %i_s vdd_s inv1_s w=''w%i-%4.4f'' dvt=%3.3f\n',i,i,i+1,i,dw1,dvt);
                else
                    fprintf(fid,'xinv%i_s %i_s %i_s vdd_s inv2_s w=''w%i-%4.4f'' dvt=%3.3f\n',i,i,i+1,i,dw1,dvt);
                    if(i<n)
                        fprintf(fid,'xinv%i_s %i_s %i_s vdr_s inv1_s w=''fanout*w%i-fanout*%4.4f'' dvt=%3.3f\n',100+i-1,i+1,200+i,i-1,dw1,dvt);
                    else
                        fprintf(fid,'xinv%i_s %i_s %i_S vdr_s inv1_s w=''fanout*w%i+w%i-%4.4f-fanout*%4.4f'' dvt=%3.3f\n',100+i-1,i+1,200+i,i-1,i-1,dw1,dw1,dvt);
                    end
                end
            end
            fprintf(fid,'Vdr_s vdr_s 0 DC=''vd*%2.2f''\nVd_s vdd_s 0 DC=''vd*%2.2f''\nVpulse_s 100_s 0 PULSE(0,''vd*%2.2f'',10n,10p,10p,''clock/2'',clock)\n',p_slow,p_slow,p_slow);
        end

        fprintf(fid,'Vdr vdr 0 DC vd\nVd vdd 0 DC vd\nVpulse 100 0 PULSE(0,vd,10n,10p,10p,''clock/2'',clock)\n.tran ''clock/1000'' ''clock*3+10n'' sweep data=cv\n');
        if(flag_var)
            fprintf(fid,'.measure tran t1 trig V(1_s) val=''%2.2f*vd/2'' TD=''10n+clock/4'' rise=2 targ V(%i_s) val=''%2.2f*vd/2'' TD=''10n+clock/4'' %s=2\n',p_slow,n+1,p_slow,edge);
        else
            fprintf(fid,'.measure tran t1 trig V(1) val=''vd/2'' TD=''10n+clock/4'' rise=2 targ V(%i) val=''vd/2'' TD=''10n+clock/4'' %s=2\n',n+1,edge);
        end

        fprintf(fid,'\n.measure tran avgpower avg par''p(Vd)+p(Vpulse)'' FROM=''clock*0.3+10n'' TO=''clock*2.3+10n''\n');
        fprintf(fid,'.measure tran leakpower avg par''p(Vd)+p(Vpulse)'' FROM=''clock*1.3+10n+10p'' TO=''clock*1.4+10n+10p''\n');
        fprintf(fid,'.ic ');
        fprintf(fid,'v(100)=0 ');
        for i=1:n
            if(mod(i,2)==0)
                fprintf(fid,'v(%i)=0 ',i);
            else
                fprintf(fid,'v(%i)=''vd'' ',i);
            end
        end
        if(flag_var)
            fprintf(fid,'v(100_s)=0 ');
            for i=1:n
                if(mod(i,2)==0)
                    fprintf(fid,'v(%i_s)=0 ',i);
                else
                    fprintf(fid,'v(%i_s)=''vd*%2.2f'' ',i,p_slow);
                end
            end
        end
        fprintf(fid,'\n');
        fprintf(fid,'.end');
        fclose(fid);
        unix(hspicerun);
    
        power2=[];
        fid=fopen(resultname, 'r');
        if(fid==-1)
            f=1;
            break;
        end
        if (fid ~= -1)
            x = [];
            for (j=1:5)
                tline=fgetl(fid);
            end
            for i=1:length(vdd2)
                tline=fgetl(fid);
                [t r] = strtok(tline);
                [t r]= strtok(r);
                [t r]= strtok(r);
                [t r]= strtok(r);
                if(~ischar(t))
                    Delay2=-38;
                else
                    [Delay2,status]=str2num(t);
                end
                if(status==0)
                    Delay2=-38;
                end
                delay2(i)=Delay2;
                tline=fgetl(fid);
                [t r] = strtok(tline);
                if(~ischar(t))
                    Energy2=38*2;
                else
                    [Energy2,status]=str2num(t);
                end
                if(status==0)
                    Energy2=38*2;
                end
                if(-Energy2>leakage2(i))
                    power2(i)=(-Energy2-leakage2(i))*delay2(i)*6/2;
                else
                    if(-Energy2*1.5>leakage2(i))
                        power2(i)=0;
                    else
                        power2(i)=-38;
                    end
                end
                tline=fgetl(fid);
            end
            i=1;
            while(i<=length(vdd2))
                if(power2(i)<0||delay2(i)<0)
                    power2(i)=[];
                    delay2(i)=[];
                    leakage2(i)=[];
                    vdd2(i)=[];
                else
                    i=i+1;
                end
            end       
        
        
        end
        if(length(vdd2)==0)
            f=1;
            break;
        end
        vdd3(i_stage,:)=0;
        vdd3(i_stage,1:length(vdd2))=vdd2;
        power3(i_stage,1:length(power2))=power2;
        delay3(i_stage,:)=0;
        delay3(i_stage,1:length(delay2))=delay2;
        leakage3(i_stage,1:length(leakage2))=leakage2;
        fclose(fid);
    end
    if(f)
        Scaling(jj).f=1;
        n_failure_DVFS=n_failure_DVFS+1;
        Scaling_VDD(1,jj)=C_vdd;
            Scaling_Power(1,jj)=10^Data(jj,2);
            Scaling_Leakage(1,jj)=10^Data(jj,3);
            Scaling_Delay(1,jj)=10^Data(jj,1);
        continue;
    else
        Scaling(jj).f=0;
    end
    Scaling(jj).VDD=vdd3;
    Scaling(jj).Power=power3;
    Scaling(jj).Leakage=leakage3;
    Scaling(jj).Delay=delay3;
    save('Temp_Scaling_results.mat','Scaling');
end

for jj=1:length(Data(:,1))
    Scaling(jj).origin_delay=Data(jj,1);
    Scaling(jj).origin_power=Data(jj,2);
    Scaling(jj).origin_leakage=Data(jj,3);
end
save('Scaling_results.mat','Scaling');  
