clear;
curr_directory = pwd;
cd('/w/ee.00/puneet/liangzhe/cvx/cvx');
cvx_setup;
cd(curr_directory);
load('fitting_model.mat');
load('Design_information.mat');
d_fit=Scaling(1).delay_fit;
p_fit=Scaling(1).power_fit;
n_vdd=length(vdd_allocation(:,1));
n_stage=3;

Curr_delay=10^Scaling(1).origin_delay;
c_delay=2*Curr_delay;
Curr_power=10^Scaling(1).origin_power;
t_p=0.8;
for i_stage=1:n_stage
    min_vdd(i_stage)=min(Scaling(1).VDD(i_stage,find(Scaling(1).VDD(i_stage,:)>0)));
    max_vdd(i_stage)=max(Scaling(1).VDD(i_stage,:));
end
cvx_begin 
    variable v(n_vdd)
    variable t
    variable p(n_stage)
    variable k(1)
    variable x 
    subject to
        k>=1
        for i = 1:n_vdd
            v(i)>=max(min_vdd(vdd_allocation(i,find(vdd_allocation(i,:)>0))));
            v(i)<=min(max_vdd(vdd_allocation(i,find(vdd_allocation(i,:)>0))));
            for i_s=1:length(find(vdd_allocation(i,:)>0))
                d_fit(vdd_allocation(i,i_s),1)+d_fit(vdd_allocation(i,i_s),2)*v(i)+d_fit(vdd_allocation(i,i_s),3)*pow_abs(v(i),2)+d_fit(vdd_allocation(i,i_s),4)*inv_pos(v(i))<=t;
                p_fit(vdd_allocation(i,i_s),2)*v(i)+p_fit(vdd_allocation(i,i_s),3)*pow_abs(v(i),2)+p_fit(vdd_allocation(i,i_s),4)*pow_abs(v(i),3)+p_fit(vdd_allocation(i,i_s),5)*pow_abs(v(i),4)+p_fit(vdd_allocation(i,i_s),1)<=p(vdd_allocation(i,i_s));
            end
        end
        inv_pos(delay_weight*t)+(k-1)/Curr_delay==k/c_delay
        optimizing_stage_weight*p+(k-1)*Curr_power<=t_p*k;       
  cvx_end
        
        