clear;
load('fitting_model.mat');
load('Design_information.mat');
Th_put=[0.01 0.1 0.5 0.8];
n_vdd=length(vdd_allocation(:,1));
i_vpp=0;
act = 0:0.001:1;
f_DVFS = 1;
Throuput = 1/10^Scaling(1).origin_delay * 0.005;
for i_act = 1:length(act)
    p_overhead (i_act) = P_SwtichVsAct ( act(i_act));
end
% plot(act,p_overhead);


for i_pp=1:length(Scaling)

    neg_error=0;
    if(Scaling(i_pp).f_fit)
        DVDS(i_pp).f_fit=1;
        continue;
    end
    Peak_TP=1/10^Scaling(i_pp).origin_delay;
    Peak_P=10^Scaling(i_pp).origin_power;
%     Th_put = 0.1;
    if ( Th_put > 1)
            continue;
    end
    i_vpp=i_vpp+1;
    d_fit=Scaling(i_pp).delay_fit;
    p_fit=Scaling(i_pp).power_fit;
    l_fit=Scaling(i_pp).leakage_fit;
    for i_tp=1:length(Th_put)
        
        min_power(i_vpp,i_tp)=inf;
        if(f_DVFS)
        for f1=0:0.01:Th_put(i_tp)
            for f2=Th_put(i_tp)-f1:0.01:1-f1
                Demond_delay=(f2+P_SwtichVsAct(f2))/(Th_put(i_tp)*Peak_TP-(f1+P_SwtichVsAct(f1))*Peak_TP)/delay_weight;
                for i_stage=1:length(optimizing_stage)
                    min_vdd=min(Scaling(i_pp).VDD(i_stage,find(Scaling(i_pp).VDD(i_stage,:)>0)));
                    max_vdd=max(Scaling(i_pp).VDD(i_stage,:));
                    while(max_vdd-min_vdd>0.0001)
                        bisearch_vdd=(min_vdd+max_vdd)/2;
                        if(Delay_fun(d_fit(i_stage,:),bisearch_vdd)>Demond_delay)
                            min_vdd=bisearch_vdd;
                        else
                            max_vdd=bisearch_vdd;
                        end
                    end
                    Demond_vdd(i_stage)=bisearch_vdd;
                end         
                for i_vdd=1:n_vdd
                    Demond_vdd(vdd_allocation(i_vdd,find(vdd_allocation(i_vdd,:)>0)))=max(Demond_vdd(vdd_allocation(i_vdd,find(vdd_allocation(i_vdd,:)>0))));
                end
                for i_stage=1:length(optimizing_stage)
                    This_delay(i_stage)=Delay_fun(d_fit(i_stage,:),Demond_vdd(i_stage));
                    This_power(i_stage)=Power_fun(p_fit(i_stage,:),Demond_vdd(i_stage));
                    This_leakage(i_stage)=Leakage_fun(l_fit(i_stage,:),Demond_vdd(i_stage));
                end
                if(max(This_delay)>1.05*Demond_delay)
%                      disp('bisearch''s precision needs to be increased');
                    continue;
                end
                real_power=activity * This_power/(max(This_delay)*delay_weight)+This_leakage;
                total_power = optimizing_stage_weight*real_power'* (f2 + P_SwtichVsAct( f2)) + Peak_P* (f1 +  P_SwtichVsAct( f1));
               
                if(min_power(i_vpp,i_tp)>total_power)
                    min_power(i_vpp,i_tp)= total_power;
                    if(min_power(i_vpp,i_tp)<0)
                       neg_error=1;
                       display('error: found negative power');
                       break;
                    end
                    temp_VDD=Demond_vdd;
                    temp_f1=f1;
                    temp_f2=f2;
                    temp_delay=Demond_delay*delay_weight;
                end
            end
            if(neg_error)
                
                break;
            end
        end
        else
            f1 = Th_put(i_tp);
            temp_f1=f1;
            temp_f2=0;
            total_power =  Peak_P*f1 + P_SwtichVsAct( f1, Peak_P,10^Scaling(i_pp).origin_leakage);
            temp_delay = inf;
        end
        if(neg_error)
            i_vpp=i_vpp-1;
            break;
        end
        Related_Throughput(i_vpp,i_tp)=Peak_TP*Th_put(i_tp);
        fraction1(i_vpp,i_tp)=temp_f1;
        fraction2(i_vpp,i_tp)=temp_f2;
        DVDS(i_pp).VDD1(i_tp,:)=max(Scaling(i_pp).VDD);
        DVDS(i_pp).VDD2(i_tp,:)=temp_VDD;
        DVDS(i_pp).min_power(i_tp)=min_power(i_vpp,i_tp);
        DVDS(i_pp).Throughput(i_tp)=Th_put(i_tp);
        DVDS(i_pp).fraction(i_tp,1)=temp_f1;
        DVDS(i_pp).fraction(i_tp,2)=temp_f2;
        DVDS(i_pp).second_delay(i_tp)=temp_delay;
        DVDS(i_pp).first_delay(i_tp)=10^Scaling(i_pp).origin_delay;
        DVDS(i_pp).first_power(i_tp)=10^Scaling(i_pp).origin_power;
    end
    if(neg_error==0)
        Peak_Throught(i_vpp)=Peak_TP;
        Peak_Power(i_vpp)=Peak_P;
    end
end
save('DVDS','Scaling','DVDS');
for i_tp=1:length(Th_put)
    final_result(2:length(Peak_Throught)+1,2*i_tp-1)=Peak_Throught;
    final_result(2:length(Peak_Throught)+1,2*i_tp)=min_power(1:length(Peak_Throught),i_tp);
    final_result(1,2*i_tp-1)=Th_put(i_tp);
end
figure;
loglog(Peak_Throught,Peak_Power);
for i_tp=1:length(Th_put)
    hold on;
    loglog(Peak_Throught,min_power(1:length(Peak_Throught),i_tp),'--','Linewidth',3);
end

dlmwrite('DVFS.txt',final_result,' ');
                
                
            
            
        
    
    
