//************************************************************************
//Functions to monitor performance and memory usage of code
//***********************************************************************
#include<cassert>
#include<time.h>
#include <sys/resource.h>
#include<limits>
#include<stdio.h>
#include<stdlib.h> 
#include<omp.h>
#include<string.h>
#include<vector>
#include<algorithm>
#include "MeasureCodePerf.h"
#define STOPWATCH_OPTION_SET    (0)
#define STOPWATCH_OPTION_RESET  (1)

using namespace std;

//***************************************************************************************
//StopWatch()
//This function calculates the time taken by a part of program to run
//**************************************************************************************
double MeasureCodePerf::StopWatch(int iOption)
{

        static  rusage prev_ru;
        switch(iOption) {
        case STOPWATCH_OPTION_SET:
                {
                        rusage  curr_ru;
                        getrusage(RUSAGE_SELF,&curr_ru);

                        return  (curr_ru.ru_utime.tv_sec+1e-6*curr_ru.ru_utime.tv_usec
                        -prev_ru.ru_utime.tv_sec+1e-6*prev_ru.ru_utime.tv_usec);        //thyeros: sec [10/30/2005]
                }
        case STOPWATCH_OPTION_RESET:
                getrusage(RUSAGE_SELF,&prev_ru);
                return  0;
        default:
                assert(0);
                break;
        }

}

//***************************************************************************************
//StopWatch()
//This function calculates the time taken by a part of program to run
//**************************************************************************************
double MeasureCodePerf::StopWatch_parallel(int iOption){
static double start;
switch (iOption){
	case STOPWATCH_OPTION_SET:
	{	
		double end;
		end = omp_get_wtime();
		double delta = end - start;
		return delta;
	}
        case STOPWATCH_OPTION_RESET:
		start = omp_get_wtime();
		return 0;
	default:
		assert(0);
		break;
}


}
//*********************************************************************************************
//GetMemory()
// function to get memory usage
//*********************************************************************************************

int     MeasureCodePerf::GetMemory()
{
        int             iVMem   =       0;

        char    cBuffer[256];
        sprintf(cBuffer,"/proc/%d/status",getpid());

        FILE*   pFile   =       fopen(cBuffer,"rt");
        while(fgets(cBuffer,sizeof(cBuffer),pFile))
        {
                char*   pToken  =       strtok(cBuffer," \t\n");
                if(strcasecmp(pToken,"VmSize:")==0)
                {
                        pToken  =       strtok(NULL," \t\n");
                        iVMem   =       atoi(pToken);

                        pToken  =       strtok(NULL," \t\n");

                        if(strcasecmp(pToken,"KB")==0)                          ;
                        else if(strcasecmp(pToken, "MB")==0)    iVMem*=1024;
                        else if(strcasecmp(pToken, "GB")==0)    iVMem*=(1024*1024);
                        else if(strcasecmp(pToken, "B")==0)             iVMem/=1024;
                        else                                                                    iVMem*=-1;
                        break;
                }
        }

        fclose(pFile);

        // in KB unit [2/10/2007 thyeros]
        return  iVMem;
}


//**********************************************************
//Returns runtime of a sample operation in parallel. All jobs will be wrt to this value
//*********************************************************

float MeasureCodePerf::normalizedTime(){

float start = omp_get_wtime();
#pragma parallel omp for
for (int i = 0; i < 2048; i++){
	vector<int> Test(20000);
	for (int j = 0; j < 20000; j++) Test[j] = j%7;
	sort(Test.begin(), Test.end());
}
float end = omp_get_wtime();
float time = end - start;
return time;

}


