
import argparse
import os
import subprocess

parser = argparse.ArgumentParser()
parser.add_argument('-model', dest="modelFile", type=str, action="store", required=True, 
		    help='Model file used for testing')
parser.add_argument('-design', dest="designPath", type=str, action="store", required=True,
		    help='Path to OA database of EUV layout')
parser.add_argument('-cell', dest="cellName", type=str,action="store", required=True,
		    help='Cell name of EUV layout for which mask yield must be computed')


parser.add_argument('-cdTolerance', dest="CDtol", type=float, action="store", required=True,
		    help='Maximum CD change due to EUV mask defect that is acceptable (in nm)')
parser.add_argument('-manfFile', dest="manfFile", type=str, action="store", required=True,
		    help='File with EUV mask manufacturing parameters like defect size and maximum allowed pattern shift')
parser.add_argument('-layer', dest="layerName", type=str, action="store", required=True,
		    help='Layer name to analyze')
parser.add_argument('-o', dest="outFileName", type=str, action="store", required=True,
		    help='CSV file name to store mask yield result')

args = parser.parse_args() 

designName = os.path.basename(args.designPath)

print "Design name is " + designName

print "bin/test " + args.modelFile + " " + args.designPath + " " + designName + " " + args.cellName + " " + str(args.CDtol) + " " + args.manfFile + " " + args.layerName + " 0 " + args.outFileName 


binFolder = os.path.dirname(os.path.abspath(__file__))

processArgs = (os.path.join(binFolder, "test"), args.modelFile, args.designPath, designName, args.cellName, str(args.CDtol), args.manfFile, args.layerName, "0", args.outFileName)

popen = subprocess.Popen(processArgs, stdout=subprocess.PIPE)
popen.wait()
output = popen.stdout.read()
print output

