//******************************************************************************
//This class gets the prohibited regions of a layout
//Written by Abde Ali
//*****************************************************************************

#ifndef FINDPB_H
#define FINDPB_H

#include<iostream>
#include<vector>
#include<list>
#include<string>
#include "oaDesignDB.h"
#include <boost/polygon/polygon.hpp>
typedef boost::polygon::polygon_90_with_holes_data<double> boostPolygon;
typedef std::list<boostPolygon>  boostPolygonSet;


#include "defectType.h"

class findProhibitedRects {
	private:
	float CDtolerance;
	bool PBmode;
	
	void displayBoostPolygon(const boostPolygon &polygon) const;

	void RunOneDefectSize(boostPolygonSet &allShapes, const float &defectHeight, const float &defectFWHM, std::list<boostPolygon> &prohibitedRegions) const;

	void getAllDefectTypes(const std::string &distType, const std::vector<float> &heightSet, const std::vector<float> &fwhmSet, std::vector<defectType> &allDefects) const;

	public:

	findProhibitedRects(const float &CDtol, const bool &mode);

	bool findLayers(oa::oaTech *techFile, const std::string &layerName, oa::oaLayerNum &layerNum, oa::oaPurposeNum &purpNum) const;
	void Run(boostPolygonSet &allShapes, const std::string &distType, const std::vector<float> &heightSet, const std::vector<float> &fwhmSet, std::vector<defectType> &allDefects) const;
};
#endif
