
//******************************************************************************
//This class contains code to parse the manufacturing config file and return the relevant defect information
//Written by Abde Ali
//*****************************************************************************

#ifndef MANFPARAM_H
#define MANFPARAM_H

#include<iostream>
#include<string>
#include<vector> 

class ManufacturingParams {
	int shiftX;
	int shiftY;
	std::string defectSizeDist;
	std::vector<float> defectHeight;
	std::vector<float> defectFWHM;
	int defectUncertainty; 	
	public:
	explicit ManufacturingParams(const std::string &manfFile);		
	static void getWords(std::string line, std::vector<std::string> &words, const std::string &del);
	int GetShiftX() const;
	int GetShiftY() const;
	std::string GetDefectSizeDist() const;
	std::vector<float> GetDefectHeight() const;
	std::vector<float> GetDefectFWHM() const;
	int GetDefectUncertainty() const;
};
#endif
