## To write out netlist from netlist.info file
## > tclsh generate_netlist.tcl netlist.info sample.v

#mesh width
set ss 0
set npo 0
set npi 0

set netlistInfo [lindex $argv 0]
set IN [open "$netlistInfo" r]

while {[gets $IN line] >= 0} {

if {[regexp "PO" $line]} {
incr npo
}
if {[regexp "PI" $line]} {
incr npi
}

	if {![regexp "STAR" $line]} {
		set chain [lindex [split $line :] 1]

		if {  [lindex  [split [lindex $chain 0] -] 0]  > $ss} {
			set ss [lindex [split [lindex $chain 0] -] 0]
		}

		
		for {set cntr 0} {$cntr < [llength $chain]} {incr cntr} {
			if {[lindex [split [lindex $chain $cntr] -] 0] > $ss} {
				set ss [lindex [split [lindex $chain $cntr] -] 0]
			}
		}
	}


}

puts $ss

close $IN

#set max_sizes [exec grep INV lib.info | wc -l]

# For each mesh stage
set num_cells [expr [expr ($ss / 2) + 1] * [expr ($ss / 2) + 1]]
set num_invs [expr ((($ss / 2) + 1) * 2) -1 ]
set num_nand [ expr $num_cells - $num_invs]

set outfile [lindex $argv 1]
set OUT [open "$outfile" w]

# need to automate this below string
set firstLine "module eyeChart("

for {set i 1} {$i <= $npi} {incr i} {
set firstLine [concat $firstLine "pi_${i}, "]
}

for {set i 1} {$i <= $npo} {incr i} {
	if {$i != $npo} {
	set firstLine [concat $firstLine "po_${i}, "]
	} else {
	set firstLine [concat $firstLine "po_${i});"]
	}
}
puts $OUT $firstLine
set pinetstring "input "
set ponetstring "output "
for {set i 1} {$i <= $npi} {incr i} {

	if {$i != $npi} {
		set pinetstring [concat $pinetstring "pi_${i}, "]
	} else {
		set pinetstring [concat $pinetstring "pi_${i};"]
	}
}
puts $OUT $pinetstring
for {set i 1} {$i <= $npo} {incr i} {

        if {$i != $npo} { 
                set ponetstring [concat $ponetstring "po_${i}, "]
        } else {
                set ponetstring [concat $ponetstring "po_${i};"]
        }       
}

puts $OUT $ponetstring
puts $OUT [concat "wire " [string trimright [string trimleft $pinetstring "input"] ";"] "," [string trimright [string trimleft $ponetstring "output"] ";"] ";"] 


## write global wire statement

set IN [open "$netlistInfo" r]
set netctr 0;

while {[gets $IN line] >= 0} {
	set chainstring [lindex [split $line :] 1]
	set newchainstring ""	
	for {set i 0} {$i < [llength $chainstring]} {incr i} {
		lappend newchainstring [lindex [split [lindex $chainstring $i] -] 0]
	}

	set chainstring $newchainstring

	set nummeshes [regexp -all "$ss" $chainstring]
	set numinvs [regexp -all "0" $chainstring]
	
	#puts "\nNum meshes: $nummeshes, Num INVs: $numinvs"
	set netctr [expr $netctr + $num_cells*$nummeshes + $numinvs]
	#puts $netctr
}

close $IN
# plus 1 because of center cell
set totalGates [expr $netctr+1]

set netctr [expr $netctr - $npo +1]
puts "nets: $netctr"
puts "gates: $totalGates"


set global_wires ""
for {set ctr 1} {$ctr <= $netctr} {incr ctr} {
	if {$ctr != [expr $netctr]} {
	set temp_str [concat $global_wires "g_${ctr},"]
	} else {
	set temp_str [concat $global_wires "g_${ctr};"]
	}
set global_wires $temp_str
}
puts $OUT "wire $global_wires"
puts $OUT "\n"

## write main segment
set netctr 0
set is_start 0
set curr_pi 0
set curr_po 0
#special net is the fanout net of the star cell
set special_net ""
set star_fanin ""

set IN [open "$netlistInfo" r]
while {[gets $IN line] >= 0} {

# expected order is 1. PI lines 2. STAR node 3. PO lines

	if {[regexp "PI" $line]} {
		incr curr_pi

	} elseif {[regexp "STAR" $line]} {
		if {$curr_pi == $npi && $curr_po == 0} {

			if {$npi == 4} {

                        set i1 [lindex $star_fanin 0]
                        set i2 [lindex $star_fanin 1]
                        set i3 [lindex $star_fanin 2]
                        set i4 [lindex $star_fanin 3]
                        
                        incr netctr
                        lappend special_net $netctr
			set star_size [lindex [split [lindex [split [lindex [split [lindex [split $line :] 1] -] 1] )] 0] (] 1]
				
                        puts $OUT "AOI211_BZ_X${star_size}  starCell_${netctr}(.A(g_${i1}), .B(g_${i2}), .C1(g_${i3}), .C2(g_${i4}), .ZN(g_${special_net}));"

			} elseif {$npi == 5} {

			set i1 [lindex $star_fanin 0]
                        set i2 [lindex $star_fanin 1]
                        set i3 [lindex $star_fanin 2]
                        set i4 [lindex $star_fanin 3]
                        set i5 [lindex $star_fanin 4]

                        incr netctr
                        lappend special_net $netctr
                        set star_size [lindex [split [lindex [split [lindex [split [lindex [split $line :] 1] -] 1] )] 0] (] 1]

                        puts $OUT "AOI221_BZ_X${star_size}  starCell_${netctr}(.A(g_${i1}), .B1(g_${i2}), .B2(g_${i3}), .C1(g_${i4}), .C2(g_${i5}), .ZN(g_${special_net}));"

			} elseif {$npi ==6} {
			set i1 [lindex $star_fanin 0]
                        set i2 [lindex $star_fanin 1]
                        set i3 [lindex $star_fanin 2]
                        set i4 [lindex $star_fanin 3]
                        set i5 [lindex $star_fanin 4]
                        set i6 [lindex $star_fanin 5]

                        incr netctr
                        lappend special_net $netctr
                        set star_size [lindex [split [lindex [split [lindex [split [lindex [split $line :] 1] -] 1] )] 0] (] 1]


                        puts $OUT "AOI222_BZ_X${star_size}  starCell_${netctr}(.A1(g_${i1}), .A2(g_${i2}), .B1(g_${i3}), .B2(g_${i4}), .C1(g_${i5}), .C2(g_${i6}), .ZN(g_${special_net}));"

			} elseif {$npi == 3} {

			
			} elseif {$npi == 2} {


			} else {

			}

                } else {
			puts $OUT "\nERROR: REACHED STAR NODE, BUT OUT OF ORDER\n"
		}

	} else {
		incr curr_po
	}

	set chainstring [lindex [split $line :] 1]

        set chainlength [llength $chainstring]

	for {set ctr 0} {$ctr < $chainlength} {incr ctr} {

		set prev_vector ""
                set current_vector ""
			
		#0 or 1 or 2 ...
		set stageID [lindex [split [lindex $chainstring $ctr] -] 0]

		# sizeVector has comma seperated sizes 
		set sizeVector [lindex [split [lindex [split [lindex [split [lindex $chainstring $ctr] -] 1] )] 0] (] 1]

		if {$stageID == 0} {
			
			set gateSize $sizeVector
			if {$ctr == 0} {
				if {$curr_po == 0} {
                        		lappend prev_vector "pi_${curr_pi}"
                        		incr netctr
                        		lappend current_vector $netctr
				} else {
					lappend prev_vector $special_net
					incr netctr
					lappend current_vector $netctr
				}
				if {$chainlength == 1 && $curr_po == 0} {
					lappend star_fanin $netctr
				}

                        } elseif {$ctr == [expr $chainlength-1]} {
				if {$curr_po == 0} {
                                        lappend prev_vector $netctr
                                        incr netctr
                                        lappend current_vector $netctr
                                        lappend star_fanin $netctr

                                } else {
                                        lappend prev_vector $netctr
                                        lappend current_vector "po_${curr_po}"
                                }

			} else {
				lappend prev_vector $netctr
                        	incr netctr
                        	lappend current_vector $netctr
			}

			set gate_number [lindex $current_vector 0]
                        set input_number [lindex $prev_vector 0]

			if {[regexp "pi" $input_number]} {
                        puts $OUT "INV_BZ_X${gateSize} inv_${gate_number}(.A ($input_number), .ZN (g_${gate_number}));"
                        } elseif {[regexp "po" $gate_number]} {
                        puts $OUT "INV_BZ_X${gateSize} inv_${gate_number}(.A (g_${input_number}), .ZN ($gate_number));"
			} else {
                        puts $OUT "INV_BZ_X${gateSize} inv_${gate_number}(.A (g_${input_number}), .ZN (g_${gate_number}));"
                        }


		} else {

			set substage $stageID

			# For first half of substages   
                        if {$substage <= [expr $ss/2 +1]} {
				set substage_cells $substage
				# find current and previous stage vectors
                                if {$substage == 1} {

					if {$ctr == 0} {
						if {$curr_po == 0} {
                                        		lappend prev_vector "pi_${curr_pi}"
                                        		incr netctr
                                        		lappend current_vector $netctr
						} else {
							lappend prev_vector $special_net
							incr netctr
                                                	lappend current_vector $netctr
						}
					} else {
						lappend prev_vector $netctr
                                        	incr netctr 
                                        	lappend current_vector $netctr
					}

                                } else {
					set sizeVector [split $sizeVector ,]

                                        for {set myctr 1} {$myctr <= [expr $substage_cells - 1]} {incr myctr} {
                                                lappend prev_vector [expr $netctr - $substage_cells +1 + $myctr]
                                        }

                                        for {set myctr 1} {$myctr <=  $substage_cells} {incr myctr} {
                                                incr netctr
                                                lappend current_vector $netctr
                                        }
                                }

				#find number of invs and nands of current stage
                                if {$substage == 1} {
                                        set ninv 1
                                        set nnand 0
                                } else {
                                        set ninv 2
                                        set nnand [expr $substage_cells - 2]
                                                if {$nnand <= 0} {
                                                set nnand 0
                                                }
                                }

				# print gate statements

                                if {$ninv == 1} {
				set gateSize $sizeVector
                                set gate_number [lindex $current_vector 0]
                                set input_number [lindex $prev_vector 0]
					if {[regexp "pi" $input_number]} {
                	                puts $OUT "INV_BZ_X${gateSize} inv_${gate_number}(.A ($input_number), .ZN (g_${gate_number}));"
					} else {
					puts $OUT "INV_BZ_X${gateSize} inv_${gate_number}(.A (g_${input_number}), .ZN (g_${gate_number}));"
					}
                                } else {
				set gateSize1 [lindex $sizeVector 0]
				set gateSize2 [lindex $sizeVector end]
                                        set gate_number [lindex $current_vector 0]
                                        set input_number [lindex $prev_vector 0]
                                        puts $OUT "INV_BZ_X${gateSize1} inv_${gate_number}(.A (g_${input_number}), .ZN (g_${gate_number}));"
                                        set gate_number [lindex $current_vector end]
                                        set input_number [lindex $prev_vector end]
                                        puts $OUT "INV_BZ_X${gateSize2} inv_${gate_number}(.A (g_${input_number}), .ZN (g_${gate_number}));"
                                }

                                for {set myctr 0} {$myctr < $nnand} {incr myctr} {
				set gateSize [lindex $sizeVector [expr $myctr+1]]
                                set gate_number [lindex $current_vector [expr $myctr + 1]]
                                set input_numberone [lindex $prev_vector $myctr]
                                set input_numbertwo [lindex $prev_vector [expr $myctr + 1]]

                                puts $OUT "NAND_BZ_X${gateSize} nand_${gate_number}(.A1 (g_${input_numberone}), .A2 (g_${input_numbertwo}), .ZN (g_${gate_number}));"
                                }

			# for stages after middle of mesh starts here
			} else {

				set substage_cells [expr $ss+1 -$substage]
				for {set myctr 1} {$myctr <= [expr $substage_cells + 1]} {incr myctr} {
                                lappend prev_vector [expr $netctr - $substage_cells -1 + $myctr]
                                }

				if {$substage == $ss} {
				
					if {$ctr == [expr $chainlength -1]} {
						if {$curr_po == 0} {
							incr netctr
							lappend star_fanin $netctr
							lappend current_vector $netctr
						} else {
							lappend current_vector "po_${curr_po}"
						}
					} else {
						incr netctr
						lappend current_vector $netctr
					}
				} else {
					set sizeVector [split $sizeVector ,]

					for {set myctr 1} {$myctr <= $substage_cells} {incr myctr} {
                                                incr netctr
                                                lappend current_vector $netctr
                                        }
				}

				set ninv 0
                                set nnand $substage_cells

				if {$substage == $ss} {
					set gateSize $sizeVector
					set gate_number [lindex $current_vector 0]
                                	set input_numberone [lindex $prev_vector 0]
                                	set input_numbertwo [lindex $prev_vector 1]

					if {[regexp "po" $gate_number]} {
						puts $OUT "NAND_BZ_X${gateSize} nand_${gate_number}(.A1 (g_${input_numberone}), .A2 (g_${input_numbertwo}), .ZN ($gate_number));"
					} else {
						puts $OUT "NAND_BZ_X${gateSize} nand_${gate_number}(.A1 (g_${input_numberone}), .A2 (g_${input_numbertwo}), .ZN (g_${gate_number}));"
					}

				} else {

					for {set myctr 0} {$myctr < $nnand} {incr myctr} {
						set gateSize [lindex $sizeVector $myctr]
                                		set gate_number [lindex $current_vector $myctr]
                                		set input_numberone [lindex $prev_vector $myctr]
                                		set input_numbertwo [lindex $prev_vector [expr $myctr + 1]]
                                		puts $OUT "NAND_BZ_X${gateSize} nand_${gate_number}(.A1 (g_${input_numberone}), .A2 (g_${input_numbertwo}), .ZN (g_${gate_number}));"
                                	}

				}

			#else case for substages after middle of mesh ends here
			}

		#else case for mesh stage ends here
		}

	#for each stage of chain ends here
	} 
	
}



puts $OUT "endmodule\n"
close $OUT
close $IN





