proc replace_rows {table_type REF TMP slew_table delay_table ctr length } {

	if {$table_type == "delay"} {
		for {set cntr 0} {$cntr < $length} { incr cntr} {

			set nocomma [lindex $delay_table $cntr]
			set withcomma ""
			set it 0
			while {$it < [expr [llength $nocomma]-1]} {
				lappend withcomma [lindex $nocomma $it],
				incr it
			}
			lappend withcomma [lindex $nocomma $it]
	
			if {$cntr == 0} {
				puts $TMP "                             values (\"$withcomma\", \\"
			} elseif {$cntr == [expr $length -1]} {
				puts $TMP "                                        \"$withcomma\");"
			} else {
				puts $TMP "                                        \"$withcomma\", \\"
			}
		
		} 
	} else {
	
		for {set cntr 0} {$cntr < $length} { incr cntr} {

			set nocomma [lindex $slew_table 0]
                        set withcomma ""
                        set it 0
                        while {$it < [expr [llength $nocomma]-1]} {
                                lappend withcomma [lindex $nocomma $it],
                                incr it
                        }
                        lappend withcomma [lindex $nocomma $it]

		        if {$cntr == 0} { 
		        puts $TMP "                             values (\"$withcomma\", \\"
		        } elseif {$cntr == [expr $length -1]} {
		         
		        puts $TMP "                                        \"$withcomma\");"
		        } else { 
		         
		        puts $TMP "                                        \"$withcomma\", \\"
		        }
		 
		}
	}
	                        set local 0
				# 7 is because REF lib has 8 slews
				while {$local < 7} {
					incr local
					gets $REF l
					incr ctr
				}
	return $ctr
}
#here cell_delay is actual internal power which is zero
proc replace_rows_power {REF TMP cell_delay ctr length cap_length} {
			set power_string ""
			for {set cntr 1} {$cntr < $cap_length} { incr cntr} {
				set commastr ","
				lappend power_string $cell_delay$commastr
			}
				lappend power_string $cell_delay

			for {set cntr 0} {$cntr < $length} {incr cntr} {
				if {$cntr == 0} {
                        	puts $TMP "                             values (\"$power_string\", \\"
                        	} elseif {$cntr == [expr $length -1]} {

                        	puts $TMP "                                        \"$power_string\");"
                        	} else {

                        	puts $TMP "                                        \"$power_string\", \\"
                        	}			

			}

                        set local 0
			while {$local < 7} {
                                incr local
                                gets $REF l
                                incr ctr
                        }
return $ctr
}



proc add_one_cell {cellname cell_size ninputs cell_power cap REF TMP max_cap max_slew delay_table slew_table length cap_length} {

	set max_local_slew [lindex [lindex $slew_table 0] 0]
	
	for {set cntr 0} {$cntr < [llength [lindex $slew_table 0]]} {incr cntr} {
	
		if {[lindex [lindex $slew_table 0] $cntr] > $max_local_slew} {
		
		set max_local_slew [lindex [lindex $slew_table 0] $cntr]
		
		}
	}
		
	set ctr 0
	while {[gets $REF l]>= 0} {
		
		#ctr basically is the current line number
		incr ctr
		
		if {$ctr == 1} {
        	#set cellname $cellname$ninputs
        	set cellname $cellname
        	set cellname ${cellname}_BZ_X
        	set cellname $cellname$cell_size

        	puts $TMP "cell ($cellname) \{"
        	} elseif {$ctr == 5} {

        	puts $TMP "        cell_leakage_power      : $cell_power;"

        	} elseif {$ctr == 9 || $ctr == 13} {
        	puts $TMP "                value           : $cell_power;"
        	} elseif {$ctr == 19} {
		puts $TMP "                capacitance             : $cap;"
		} elseif {$ctr == 20} {
		puts $TMP "                fall_capacitance        : $cap;"
		} elseif {$ctr == 21} {
		puts $TMP "                rise_capacitance        : $cap;"
		} elseif {$ctr == 22} {
		puts $TMP "                fall_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 23} {
		puts $TMP "                rise_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 24} {
		puts $TMP "                max_transition          : $max_slew;"
		} elseif {$ctr == 30} {
		puts $TMP "                max_capacitance         : $max_cap;"
		} elseif {$ctr == 31} {
		puts $TMP "                max_transition          : $max_local_slew;"
		} elseif {$ctr == 40 || $ctr == 50} {
        	set ctr [replace_rows "delay" $REF $TMP $slew_table $delay_table $ctr $length]
		} elseif {$ctr == 60 || $ctr == 70} {
		set ctr [replace_rows "slew" $REF $TMP $slew_table $delay_table $ctr $length]
        	} elseif {$ctr == 85 || $ctr == 95} {
        	set ctr [replace_rows_power $REF $TMP "0.0" $ctr $length $cap_length]
        	} else {
        	puts $TMP $l
        	}

	}

}

proc add_two_cell {cellname cell_size ninputs cell_power cap REF TMP max_cap max_slew delay_table slew_table length cap_length} {

        set max_local_slew [lindex [lindex $slew_table 0] 0]

        for {set cntr 0} {$cntr < [llength [lindex $slew_table 0]]} {incr cntr} {
                if {[lindex [lindex $slew_table 0] $cntr] > $max_local_slew} {
                set max_local_slew [lindex [lindex $slew_table 0] $cntr]
                }
        }

	set hidden_power ""
	for {set cntr 1} {$cntr < $length} {incr cntr} {
		lappend hidden_power "0.0, "
	}
	lappend hidden_power "0.0"

	set ctr 0
        while {[gets $REF l]>= 0} {
                incr ctr

                if {$ctr == 1} {
                set cellname $cellname
                #set cellname $cellname$ninputs
                set cellname ${cellname}_BZ_X
                set cellname $cellname$cell_size

                puts $TMP "cell ($cellname) \{"
                } elseif {$ctr == 5} {

                puts $TMP "        cell_leakage_power      : $cell_power;"

                } elseif {$ctr == 9 || $ctr == 13 || $ctr == 17 || $ctr == 21} {
                puts $TMP "                value           : $cell_power;"
		} elseif {$ctr == 27 || $ctr == 48} {
		puts $TMP "                capacitance             : $cap;"
		} elseif {$ctr == 28 || $ctr == 49} {
		puts $TMP "                fall_capacitance        : $cap;"
		} elseif {$ctr == 29 || $ctr == 50} {
		puts $TMP "                rise_capacitance        : $cap;"
		} elseif {$ctr == 30 || $ctr == 51} {
		puts $TMP "                fall_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 31 || $ctr == 52} {
		puts $TMP "                rise_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 32 || $ctr == 53} {
		puts $TMP "                max_transition          : $max_slew;"
		} elseif {$ctr == 39 || $ctr == 60} {
			puts $TMP "                                values (\"$hidden_power\");"
		# this is according to the number of slews
                } elseif {$ctr == 69} {
		puts $TMP "                 max_capacitance         : $max_cap;"
		} elseif {$ctr == 70} {
		puts $TMP "                max_transition          : $max_local_slew;"
		} elseif {$ctr == 79 || $ctr == 89 || $ctr == 126 || $ctr == 136 } {
                set ctr [replace_rows "delay" $REF $TMP $slew_table $delay_table $ctr $length]
                } elseif {$ctr == 99 || $ctr == 109 || $ctr == 146 || $ctr == 156} {
                set ctr [replace_rows "slew" $REF $TMP $slew_table $delay_table $ctr $length]
                } elseif {$ctr == 171 || $ctr == 181 || $ctr == 196 || $ctr == 206} {
                set ctr [replace_rows_power $REF $TMP "0.0" $ctr $length $cap_length]
                } else {
                puts $TMP $l
                }

	}

 
}

proc add_three_cell {cellname cell_size ninputs cell_power cap REF TMP max_cap max_slew delay_table slew_table length cap_length} {
 
        set max_local_slew [lindex [lindex $slew_table 0] 0]
        for {set cntr 0} {$cntr < [llength [lindex $slew_table 0]]} {incr cntr} {
                if {[lindex [lindex $slew_table 0] $cntr] > $max_local_slew} {
                set max_local_slew [lindex [lindex $slew_table 0] $cntr]
                } 
        }

        set hidden_power ""
        for {set cntr 1} {$cntr < $length} {incr cntr} {
                lappend hidden_power "0.0, "
        }
        lappend hidden_power "0.0"

        set ctr 0
        while {[gets $REF l]>= 0} {
                incr ctr

                if {$ctr == 1} {
                #set cellname $cellname$ninputs
                set cellname $cellname
                set cellname ${cellname}_BZ_X
                set cellname $cellname$cell_size

                puts $TMP "cell ($cellname) \{"
                } elseif {$ctr == 5} {

                puts $TMP "        cell_leakage_power      : $cell_power;"

                } elseif {$ctr == 9||$ctr == 13 || $ctr == 17 || $ctr == 21 | $ctr == 25 || $ctr == 29 || $ctr == 33 || $ctr == 37} {
                puts $TMP "                value           : $cell_power;"
		} elseif {$ctr == 43 || $ctr == 64 || $ctr == 105} {
                puts $TMP "                capacitance             : $cap;"
                } elseif {$ctr == 44 || $ctr == 65 || $ctr == 106} {
                puts $TMP "                fall_capacitance        : $cap;"
                } elseif {$ctr == 45|| $ctr == 66 || $ctr == 107} {
                puts $TMP "                rise_capacitance        : $cap;"
		} elseif {$ctr == 46 || $ctr == 67 || $ctr == 108} {
		puts $TMP "                 fall_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 47 || $ctr == 68 || $ctr == 109} {
		puts $TMP "                rise_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 48 || $ctr == 69 || $ctr == 110} {
		puts $TMP "               max_transition          : $max_slew;"
		} elseif {$ctr == 55 || $ctr == 76 || $ctr == 86 || $ctr == 96 || $ctr == 117 || $ctr == 127 || $ctr == 137 } {
		puts $TMP "                                values (\"$hidden_power\");"
		} elseif {$ctr == 146} {
		puts $TMP "                 max_capacitance         : $max_cap;"
		} elseif {$ctr == 147} {
		puts $TMP "                max_transition          : $max_local_slew;"
		} elseif {$ctr == 158 || $ctr == 168 || $ctr == 207 ||$ctr == 217 || $ctr == 256 || $ctr == 266 || $ctr == 303 || $ctr == 313 || $ctr == 350 || $ctr == 360 } {
                set ctr [replace_rows "delay" $REF $TMP $slew_table $delay_table $ctr $length]
                } elseif {$ctr == 178 || $ctr == 188 || $ctr == 227 ||$ctr == 237 || $ctr == 276 || $ctr == 286 || $ctr == 323 || $ctr == 333 || $ctr == 370 || $ctr == 380 } {
                set ctr [replace_rows "slew" $REF $TMP $slew_table $delay_table $ctr $length]
                } elseif {$ctr == 397 || $ctr == 407 || $ctr == 424 || $ctr == 434 || $ctr == 451|| $ctr == 461 || $ctr == 476 || $ctr == 486 || $ctr == 501 || $ctr == 511} {
                set ctr [replace_rows_power $REF $TMP "0.0" $ctr $length $cap_length]
                } else {
		puts $TMP $l
		}
 
 	}
 
}


proc add_four_cell {cellname cell_size ninputs cell_power cap REF TMP max_cap max_slew delay_table slew_table length cap_length} {
 
        set max_local_slew [lindex [lindex $slew_table 0] 0]
        for {set cntr 0} {$cntr < [llength [lindex $slew_table 0]]} {incr cntr} {
                if {[lindex [lindex $slew_table 0] $cntr] > $max_local_slew} {
                set max_local_slew [lindex [lindex $slew_table 0] $cntr]
                } 
        }

        set hidden_power ""
        for {set cntr 1} {$cntr < $length} {incr cntr} {
                lappend hidden_power "0.0, "
        }
        lappend hidden_power "0.0"

        set ctr 0
        while {[gets $REF l]>= 0} {
                incr ctr

                if {$ctr == 1} {
                #set cellname $cellname$ninputs
                set cellname $cellname
                set cellname ${cellname}_BZ_X
                set cellname $cellname$cell_size

                puts $TMP "cell ($cellname) \{"
                } elseif {$ctr == 5} {

                puts $TMP "        cell_leakage_power      : $cell_power;"

                } elseif {$ctr == 9||$ctr == 13 || $ctr == 17 || $ctr == 21 || $ctr == 25 || $ctr == 29 || $ctr == 33 || $ctr == 37 || $ctr == 41 ||$ctr == 45 || $ctr == 49 || $ctr == 53 || $ctr == 57 ||$ctr == 61 || $ctr == 65 || $ctr == 69} {
                puts $TMP "                value           : $cell_power;"
		} elseif {$ctr == 75 || $ctr == 136 || $ctr == 197 || $ctr == 278} {
                puts $TMP "                capacitance             : $cap;"
                } elseif {$ctr == 76 || $ctr == 137 || $ctr == 198 || $ctr == 279} {
                puts $TMP "                fall_capacitance        : $cap;"
                } elseif {$ctr == 77 || $ctr == 138 || $ctr == 199 || $ctr == 280} {
                puts $TMP "                rise_capacitance        : $cap;"
		} elseif {$ctr == 78 || $ctr == 139 || $ctr == 200 || $ctr == 281} {
		puts $TMP "                 fall_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 79 || $ctr == 140 || $ctr == 201 || $ctr == 282} {
		puts $TMP "                rise_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 80 || $ctr == 141 || $ctr == 202 || $ctr == 283} {
		puts $TMP "               max_transition          : $max_slew;"
		} elseif {$ctr == 87 || $ctr == 97 || $ctr == 107 || $ctr == 117 || $ctr == 127 || $ctr == 148 || $ctr == 158 || $ctr == 168 || $ctr == 178 || $ctr == 188 || $ctr == 209 || $ctr == 219 || $ctr == 229 || $ctr == 239 || $ctr == 249 || $ctr == 259 || $ctr == 269 || $ctr == 290 || $ctr == 300 || $ctr == 310 || $ctr == 320 || $ctr == 330 || $ctr == 340 || $ctr == 350} {
		puts $TMP "                                values (\"$hidden_power\");"
		} elseif {$ctr == 359} {
		puts $TMP "                 max_capacitance         : $max_cap;"
		} elseif {$ctr == 360} {
		puts $TMP "                max_transition          : $max_local_slew;"
		} elseif {$ctr == 371 || $ctr == 381 || $ctr == 420 ||$ctr == 430 || $ctr == 469 || $ctr == 479 || $ctr == 518 || $ctr == 528 || $ctr == 567 || $ctr == 577 || $ctr == 616 || $ctr == 626 || $ctr == 663 || $ctr == 673 || $ctr == 710 || $ctr == 720 } {
                set ctr [replace_rows "delay" $REF $TMP $slew_table $delay_table $ctr $length]
                } elseif {$ctr == 391 || $ctr == 401 || $ctr == 440 ||$ctr == 450 || $ctr == 489 || $ctr == 499 || $ctr == 538 || $ctr == 548 || $ctr == 587 || $ctr == 597 || $ctr == 636 || $ctr == 646 || $ctr == 683 || $ctr == 693 || $ctr == 730 || $ctr == 740} {
                set ctr [replace_rows "slew" $REF $TMP $slew_table $delay_table $ctr $length]
                } elseif {$ctr == 757 || $ctr == 767 || $ctr == 784 || $ctr == 794 || $ctr == 811|| $ctr == 821 || $ctr == 838 || $ctr == 848 || $ctr == 865 || $ctr == 875 || $ctr == 892 || $ctr == 902 || $ctr == 917 || $ctr == 927 || $ctr == 942 || $ctr == 952} {
                set ctr [replace_rows_power $REF $TMP "0.0" $ctr $length $cap_length]
                } else {
		puts $TMP $l
		}
 
 	}
 
}



proc add_six_cell {cellname cell_size ninputs cell_power cap REF TMP max_cap max_slew delay_table slew_table length cap_length} {
 
        set max_local_slew [lindex [lindex $slew_table 0] 0]
        for {set cntr 0} {$cntr < [llength [lindex $slew_table 0]]} {incr cntr} {
                if {[lindex [lindex $slew_table 0] $cntr] > $max_local_slew} {
                set max_local_slew [lindex [lindex $slew_table 0] $cntr]
                } 
        }

        set hidden_power ""
        for {set cntr 1} {$cntr < $length} {incr cntr} {
                lappend hidden_power "0.0, "
        }
        lappend hidden_power "0.0"

        set ctr 0
        while {[gets $REF l]>= 0} {
                incr ctr

                if {$ctr == 1} {
                #set cellname $cellname$ninputs
                set cellname $cellname
                set cellname ${cellname}_BZ_X
                set cellname $cellname$cell_size

                puts $TMP "cell ($cellname) \{"
                } elseif {$ctr == 5} {
                puts $TMP "        cell_leakage_power      : $cell_power;"

		} elseif {$ctr == 9||$ctr == 13 || $ctr == 17 || $ctr == 21 || $ctr == 25 || $ctr == 29 || $ctr == 33 || $ctr == 37 || $ctr == 41 ||$ctr == 45 || $ctr == 49 || $ctr == 53 | $ctr == 57 ||$ctr == 61 || $ctr == 65 || $ctr == 69 || $ctr == 73||$ctr == 77 || $ctr == 81 || $ctr == 85 || $ctr == 89 || $ctr == 93 || $ctr == 97 || $ctr == 101 || $ctr == 105 ||$ctr == 109 || $ctr == 113 || $ctr == 117 || $ctr == 121 ||$ctr == 125 || $ctr == 129 || $ctr == 133 || $ctr == 137||$ctr == 141 || $ctr == 145 || $ctr == 149 || $ctr == 153 || $ctr == 157 || $ctr == 161 || $ctr == 165 || $ctr == 169 ||$ctr == 173 || $ctr == 177 || $ctr == 181 | $ctr == 185 ||$ctr == 189 || $ctr == 193 || $ctr == 197 || $ctr == 201 ||$ctr == 205 || $ctr == 209 || $ctr == 213 || $ctr == 217 || $ctr == 221 || $ctr == 225 || $ctr == 229 || $ctr == 233 ||$ctr == 237 || $ctr == 241 || $ctr == 245 || $ctr == 249 ||$ctr == 253 || $ctr == 257 || $ctr == 261 } {
		puts $TMP "                value           : $cell_power;"

		} elseif {$ctr == 267 || $ctr == 286 || $ctr == 305 || $ctr == 324 || $ctr == 343 || $ctr == 362} {
                puts $TMP "                capacitance             : $cap;"
                } elseif {$ctr == 268 || $ctr == 287 || $ctr == 306 || $ctr == 325 || $ctr == 344 || $ctr == 363} {
                puts $TMP "                fall_capacitance        : $cap;"
                } elseif {$ctr == 269 || $ctr == 288 || $ctr == 307 || $ctr == 326 || $ctr == 345 || $ctr == 364} {
                puts $TMP "                rise_capacitance        : $cap;"
		} elseif {$ctr == 270 || $ctr == 289 || $ctr == 308 || $ctr == 327 || $ctr == 346 || $ctr == 365} {
		puts $TMP "                 fall_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 271 || $ctr == 290 || $ctr == 309 || $ctr == 328 || $ctr == 347 || $ctr == 366} {
		puts $TMP "                rise_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 272 || $ctr == 291 || $ctr == 310 || $ctr == 329 || $ctr == 348 || $ctr == 367} {
		puts $TMP "               max_transition          : $max_slew;"
		} elseif {$ctr == 277 || $ctr == 296 || $ctr == 315 || $ctr == 334 || $ctr == 353 || $ctr == 372} {
		puts $TMP "                                values (\"$hidden_power\");"
		} elseif {$ctr == 381} {
		puts $TMP "                 max_capacitance         : $max_cap;"
		} elseif {$ctr == 382} {
		puts $TMP "                max_transition          : $max_local_slew;"
                } elseif {$ctr == 391 || $ctr == 401 || $ctr == 440 ||$ctr == 450 || $ctr == 489 || $ctr == 499 || $ctr == 538|| $ctr == 548 || $ctr == 587 || $ctr == 597 || $ctr == 634 || $ctr == 644 || $ctr == 683|| $ctr == 693 || $ctr == 732 || $ctr == 742 || $ctr == 781 || $ctr == 791 || $ctr == 830 || $ctr == 840 || $ctr == 877 || $ctr == 887 || $ctr == 926 || $ctr == 936 ||$ctr == 975 || $ctr == 985 || $ctr == 1024 || $ctr == 1034 || $ctr == 1071 || $ctr == 1081 || $ctr == 1120 || $ctr == 1130 || $ctr == 1169 || $ctr == 1179 || $ctr == 1218 || $ctr == 1228 || $ctr == 1267 || $ctr == 1277 || $ctr == 1314 || $ctr == 1324 || $ctr == 1363 || $ctr == 1373 || $ctr == 1412 || $ctr == 1422 || $ctr == 1461 || $ctr == 1471 || $ctr == 1510 || $ctr == 1520 || $ctr == 1557 || $ctr == 1567 || $ctr == 1606 || $ctr == 1616 || $ctr == 1655 || $ctr == 1665 || $ctr == 1704 || $ctr == 1714} {
                set ctr [replace_rows "delay" $REF $TMP $slew_table $delay_table $ctr $length]


		} elseif {$ctr == 411 || $ctr == 421 || $ctr == 460 ||$ctr == 470 || $ctr == 509 || $ctr == 519 || $ctr == 558 || $ctr == 568 || $ctr == 607 || $ctr == 617 || $ctr == 654 || $ctr == 664 || $ctr == 703 || $ctr == 713 || $ctr == 752 || $ctr == 762 || $ctr == 801 || $ctr == 811 || $ctr == 850 || $ctr == 860 || $ctr == 897 || $ctr == 907 || $ctr == 946 || $ctr == 956 || $ctr == 995 || $ctr == 1005 || $ctr == 1044 || $ctr == 1054 || $ctr == 1091 || $ctr == 1101 || $ctr == 1140 || $ctr == 1150 || $ctr == 1189 || $ctr == 1199 || $ctr == 1238 || $ctr == 1248 || $ctr == 1287 || $ctr == 1297 || $ctr == 1334 || $ctr == 1344 || $ctr == 1383 || $ctr == 1393 || $ctr == 1432 || $ctr == 1442 || $ctr == 14681 || $ctr == 1491 || $ctr == 1530 || $ctr == 1540 || $ctr == 1577 || $ctr == 1587 || $ctr == 1626|| $ctr == 1636 ||$ctr == 1675 || $ctr == 1685 || $ctr == 1724 || $ctr == 1734} {

                set ctr [replace_rows "slew" $REF $TMP $slew_table $delay_table $ctr $length]

		} elseif {$ctr == 1749 || $ctr == 1759 || $ctr == 1776 || $ctr == 1786 || $ctr == 1803 || $ctr == 1813 || $ctr == 1830 || $ctr == 1840 || $ctr == 1857 || $ctr == 1867 || $ctr == 1882 || $ctr == 1892 || $ctr == 1909 || $ctr == 1919 || $ctr == 1936 || $ctr == 1946 || $ctr == 1963 || $ctr == 1973 || $ctr == 1990 || $ctr == 2000 || $ctr == 2015 || $ctr == 2025 || $ctr == 2042 || $ctr == 2052 || $ctr == 2069|| $ctr == 2079 ||$ctr == 2096 || $ctr == 2106 || $ctr == 2121 || $ctr == 2131 || $ctr == 2148 || $ctr == 2158 || $ctr == 2175 || $ctr == 2185 || $ctr == 2202 || $ctr == 2212 || $ctr == 2229 || $ctr == 2239 || $ctr == 2254 || $ctr == 2264 || $ctr == 2281 || $ctr == 2291 || $ctr == 2308 || $ctr == 2318 || $ctr == 2335 || $ctr == 2345 || $ctr == 2362 || $ctr == 2372 || $ctr == 2387 || $ctr == 2397 || $ctr == 2414 || $ctr == 2424 || $ctr == 2441 || $ctr == 2451 || $ctr == 2468 || $ctr == 2478} {
                set ctr [replace_rows_power $REF $TMP "0.0" $ctr $length $cap_length]


		} else {
		puts $TMP $l
		}
 
 	}
 
}


proc add_five_cell {cellname cell_size ninputs cell_power cap REF TMP max_cap max_slew delay_table slew_table length cap_length} {
 
        set max_local_slew [lindex [lindex $slew_table 0] 0]
        for {set cntr 0} {$cntr < [llength [lindex $slew_table 0]]} {incr cntr} {
                if {[lindex [lindex $slew_table 0] $cntr] > $max_local_slew} {
                set max_local_slew [lindex [lindex $slew_table 0] $cntr]
                } 
        }

        set hidden_power ""
        for {set cntr 1} {$cntr < $length} {incr cntr} {
                lappend hidden_power "0.0, "
        }
        lappend hidden_power "0.0"

        set ctr 0
        while {[gets $REF l]>= 0} {
                incr ctr

                if {$ctr == 1} {
                #set cellname $cellname$ninputs
                set cellname $cellname
                set cellname ${cellname}_BZ_X
                set cellname $cellname$cell_size

                puts $TMP "cell ($cellname) \{"
                } elseif {$ctr == 5} {

                puts $TMP "        cell_leakage_power      : $cell_power;"

                } elseif {$ctr == 9||$ctr == 13 || $ctr == 17 || $ctr == 21 | $ctr == 25 || $ctr == 29 || $ctr == 33 || $ctr == 37 || $ctr == 41 ||$ctr == 45 || $ctr == 49 || $ctr == 53 | $ctr == 57 ||$ctr == 61 || $ctr == 65 || $ctr == 69} {
                puts $TMP "                value           : $cell_power;"
		} elseif {$ctr == 75 || $ctr == 136 || $ctr == 197 || $ctr == 278} {
                puts $TMP "                capacitance             : $cap;"
                } elseif {$ctr == 76 || $ctr == 137 || $ctr == 198 || $ctr == 279} {
                puts $TMP "                fall_capacitance        : $cap;"
                } elseif {$ctr == 77 || $ctr == 138 || $ctr == 199 || $ctr == 280} {
                puts $TMP "                rise_capacitance        : $cap;"
		} elseif {$ctr == 78 || $ctr == 139 || $ctr == 200 || $ctr == 281} {
		puts $TMP "                 fall_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 79 || $ctr == 140 || $ctr == 201 || $ctr == 282} {
		puts $TMP "                rise_capacitance_range          ($cap, $cap);"
		} elseif {$ctr == 80 || $ctr == 141 || $ctr == 202 || $ctr == 283} {
		puts $TMP "               max_transition          : $max_slew;"
		} elseif {$ctr == 87 || $ctr == 97 || $ctr == 107 || $ctr == 117 || $ctr == 127 || $ctr == 148 || $ctr == 158 || $ctr == 168 || $ctr == 178 || $ctr == 188 || $ctr == 209 || $ctr == 219 || $ctr == 229 || $ctr == 239 || $ctr == 249 || $ctr == 259 || $ctr == 269 || $ctr == 290 || $ctr == 300 || $ctr == 310 || $ctr == 320 || $ctr == 330 || $ctr == 340 || $ctr == 350} {
		puts $TMP "                                values (\"$hidden_power\");"
		} elseif {$ctr == 359} {
		puts $TMP "                 max_capacitance         : $max_cap;"
		} elseif {$ctr == 360} {
		puts $TMP "                max_transition          : $max_local_slew;"
		} elseif {$ctr == 371 || $ctr == 381 || $ctr == 420 ||$ctr == 430 || $ctr == 469 || $ctr == 479 || $ctr == 518 || $ctr == 528 || $ctr == 567 || $ctr == 577 || $ctr == 616 || $ctr == 626 || $ctr == 663 || $ctr == 673 || $ctr == 710 || $ctr == 720 } {
                set ctr [replace_rows "delay" $REF $TMP $slew_table $delay_table $ctr $length]
                } elseif {$ctr == 391 || $ctr == 401 || $ctr == 440 ||$ctr == 450 || $ctr == 489 || $ctr == 499 || $ctr == 538 || $ctr == 548 || $ctr == 587 || $ctr == 597 || $ctr == 636 || $ctr == 646 || $ctr == 683 || $ctr == 693 || $ctr == 730 || $ctr == 740} {
                set ctr [replace_rows "slew" $REF $TMP $slew_table $delay_table $ctr $length]
                } elseif {$ctr == 757 || $ctr == 767 || $ctr == 784 || $ctr == 794 || $ctr == 811|| $ctr == 821 || $ctr == 838 || $ctr == 848 || $ctr == 865 || $ctr == 875 || $ctr == 892 || $ctr == 902 || $ctr == 917 || $ctr == 927 || $ctr == 942 || $ctr == 952} {
                set ctr [replace_rows_power $REF $TMP "0.0" $ctr $length $cap_length]
                } else {
		puts $TMP $l
		}
 
 	}
 
}


# for INV, NAND AOI21 AOI211 AOI221 AOI222
set num_inputs "1 2 3 4 5 6"


set one "onecell.lib"
set two "twocell.lib"
set three "threecell.lib"
set four "fourcell.lib"
set five "fivecell.lib"
set six "sixcell.lib"

set outfile [lindex $argv 0]
set IN [open "lib.info" r]

set cap_list [lindex [split [exec grep CAP_VECTOR lib.info] ":"] 1]
set max_cap [lindex $cap_list 0]
set min_cap $max_cap
for {set i 0} {$i < [llength $cap_list]} {incr i} {
	if {[lindex $cap_list $i] > $max_cap} {
		set max_cap [lindex $cap_list $i]
	}
	if {[lindex $cap_list $i] < $min_cap} {
                set min_cap [lindex $cap_list $i]
        }
}

puts $max_cap
puts $min_cap

#replace slew list by actual slew lsit for slew dependent case
#set slew_list "0.099 0.099 0.099 0.099 0.099 0.099" 
set slew_list "0.007 0.014 0.021 0.028 0.035 0.042"

set max_slew [lindex $slew_list 0]
set min_slew $max_slew
for {set i 0} {$i < [llength $slew_list]} {incr i} {
        if {[lindex $slew_list $i] > $max_slew} {
                set max_slew [lindex $slew_list $i]
        }
        if {[lindex $slew_list $i] < $min_slew} {
                set min_slew [lindex $slew_list $i]
        }
}
set dummy_slew_table ""
set slew_incr [expr ($max_slew - $min_slew)/([llength $cap_list])]

for {set i 0} {$i < [llength $cap_list]} {incr i} {
	#set dummy_slew [expr $min_slew + [expr $i*$slew_incr]]
	set dummy_slew [expr $min_slew + $i*0.001]
	
	if {$dummy_slew >= $max_slew} {
		set dummy_slew $max_slew
	}
	
	lappend dummy_slew_table $dummy_slew

}

#puts $dummy_slew_table

set max_size [exec grep INV lib.info | wc -l]

#parse header.lib and fix the things
exec cp header.lib $outfile

#exec cat $outfile | sed 's/index_1 (\"0.007 0.014 0.021 0.028 0.035 0.042\")/index_1 (\"$slew_list\")/' > scratch
set OUT [open "$outfile" a]

puts $OUT "\n"

for {set i 1} {$i <= $max_size} {incr i} {

puts $OUT "  lu_table_template (Timing_X${i}) {"
puts $OUT "        variable_1 : input_net_transition;"
puts $OUT "        variable_2 : total_output_net_capacitance;"
puts $OUT "        index_1 (\"$slew_list\")"
puts $OUT "        index_2 (\"$cap_list\")"
puts $OUT "  }"

puts $OUT "  power_lut_template (Power_X${i}) {"
puts $OUT "        variable_1 : input_transition_time;"
puts $OUT "        variable_2 : total_output_net_capacitance;"
puts $OUT "        index_1 (\"$slew_list\")"
puts $OUT "        index_2 (\"$cap_list\")"
puts $OUT "  }"

}

close $OUT


while {[gets $IN line] >= 0} {
if {[regexp "CELL" $line]} {


	set cellname [lindex [split [lindex [split $line ":"] 1] "\t"] 0]

        set cell_size [lindex [split  [lindex [split $line ":"] 2] "\t"] 0]

        set cap [lindex [split  [lindex [split $line ":"] 3] "\t"] 0]

        set cell_power [lindex [split  [lindex [split $line ":"] 4] "\t"] 0]

	while {![regexp "^DELAY:" $line]} {
        	gets $IN line
        }

	#puts $line
	set line [lindex [split $line ":"] 1]
	
	set delay_table ""

	for {set cntr 0} {$cntr < [llength $slew_list]} {incr cntr} {
		lappend delay_table $line
	}

	#puts $delay_table
	set slew_table ""
	lappend slew_table $dummy_slew_table

	set TMP [open "temp" w]


	if {$cellname == "INV"} {
                set ninputs [lindex $num_inputs 0]
                set REF [open $one r]
		puts $TMP "\n"
                add_one_cell $cellname $cell_size $ninputs $cell_power $cap $REF $TMP $max_cap $max_slew $delay_table $slew_table [llength $slew_list] [llength $cap_list]
		puts $TMP "\n"
                close $REF

        } elseif {$cellname == "NAND"} {
                set ninputs [lindex $num_inputs 1]
                set REF [open $two r]
                add_two_cell $cellname $cell_size $ninputs $cell_power $cap $REF $TMP $max_cap $max_slew $delay_table $slew_table [llength $slew_list] [llength $cap_list]
                close $REF

        } elseif {$cellname == "AOI21"} {
		set ninputs [lindex $num_inputs 2]
                set REF [open $three r] 
                add_three_cell $cellname $cell_size $ninputs $cell_power $cap $REF $TMP $max_cap $max_slew $delay_table $slew_table [llength $slew_list] [llength $cap_list]
                close $REF

	} elseif {$cellname == "AOI211"} {
		set ninputs [lindex $num_inputs 3]
                set REF [open $four r]
                add_four_cell $cellname $cell_size $ninputs $cell_power $cap $REF $TMP $max_cap $max_slew $delay_table $slew_table [llength $slew_list] [llength $cap_list]
                close $REF 

	} elseif {$cellname == "AOI221"} {
		set ninputs [lindex $num_inputs 4]
                set REF [open $five r]
                add_five_cell $cellname $cell_size $ninputs $cell_power $cap $REF $TMP $max_cap         $max_slew $delay_table $slew_table [llength $slew_list] [llength $cap_list]
		close $REF

	} elseif {$cellname == "AOI222"} {
		set ninputs [lindex $num_inputs 5]
                set REF [open $six r]
                add_six_cell $cellname $cell_size $ninputs $cell_power $cap $REF $TMP $max_cap $max_slew $delay_table $slew_table [llength $slew_list] [llength $cap_list]
                close $REF
	} else {

	}

	close $TMP

	## now concatenate the temp with header
               exec cat $outfile temp > new_temp
               exec mv new_temp $outfile
               exec rm temp

}
}

close $IN

set NEW [open "$outfile" a]
puts $NEW "}"
close $NEW

