#include <iostream>
#include <vector>
#include <algorithm>
#include <numeric>
#include <iterator>
#include <fstream>
#include <math.h>
#include <assert.h>
#include <map>


#include "./sizing.h"
#include "./define.h"

using namespace std;



template<class T>
T maxVector(const vector<T> &vec) {

	T init; init = vec[0];
	for(int i=0; i<vec.size(); i++)
	{
		if(vec[i] > init)
			init = vec[i];
	}
return init;

}

template<class T>
T minVector(const vector<T> &vec) {

	T init; init = vec[0];
	for(int i=0; i<vec.size(); i++)
	{
		if(vec[i] < init)
			init = vec[i];
	}

return init;
}



int main () {


time_t time1, time2; time1 = time(NULL);

unsigned int numGates=0; // number of gates you want in the design. Could be modified slightly to accommodate chains.
unsigned int minNumGates=0; // min  # of gates 

fstream library;
fstream netlist;
fstream logfile;
fstream stateLogFile;

library.open("lib.info", ios::out);
netlist.open("netlist.info", ios::out);
logfile.open("log", ios::out);

//if(PRINT_STATE_LOG_INFO)
//{
stateLogFile.open("state_log.info", ios::out);
//}

printMinGates(minNumGates);

do {
cout << "Enter the size of design: ";
logfile << "Enter the size of design: ";
cin >> numGates;
logfile << numGates << endl;
} while (numGates < minNumGates);

// Form eyechart structure
EYE_CHART eyeChart;

formEye(eyeChart, numGates);
printEye(eyeChart,netlist);


logfile << "*********** Eychart Statistics *******" << endl;
logfile << "\nGenerating Eyechart logic depth:" << eyeChart.logic_depth  <<  " and with num of gates: " << numGates << endl;
for(int i =0 ; i < eyeChart.numPiStages.size(); i++) {
	logfile << "PI Arm " << i+1 << " - " << eyeChart.numPiStages[i] << " stages, " << eyeChart.numPiChainMeshes[i] << " " << MESH_WIDTH << "-meshes, " << eyeChart.numPiChainChains[i] << "inverters" << endl;
}
for(int i=0; i < eyeChart.numPoStages.size(); i++) {
	logfile << "PO Arm " << i+1 << " - " << eyeChart.numPoStages[i] << " stages, " << eyeChart.numPoChainMeshes[i] << " " << MESH_WIDTH << "-meshes" << endl;
}
logfile << endl << endl;

// form libs

vector<short int> capVector;

createCapVector(capVector);

library << "CAP_VECTOR:";

for(int i=0; i < capVector.size(); i++) {
library << (float)capVector[i]/1000 << " "; // for pico farad conversion
}

library << endl;

map<unsigned short int, LIB_CELL> invLibs, nandLibs, thirdLibs;

createLibsInv(invLibs);
createLibsNand(nandLibs);
createLibsThird(thirdLibs);

//library << " ************* INVERTER LIBS **************" << endl;

for(map<unsigned short int, LIB_CELL>::iterator iter = invLibs.begin(); iter != invLibs.end(); iter++)
        iter->second.printLibCell(library);
//library << " ************* NAND LIBS **************" << endl;


for(map<unsigned short int, LIB_CELL>::iterator iter = nandLibs.begin(); iter != nandLibs.end(); iter++)
        iter->second.printLibCell(library);
//library << " ************* THIRD LIBS **************" << endl;

for(map<unsigned short int, LIB_CELL>::iterator iter = thirdLibs.begin(); iter != thirdLibs.end(); iter++)
        iter->second.printLibCell(library);

// Build composite cells
map<short int, COMP_CELL> compCells;

buildCompositeCells(compCells, invLibs, nandLibs);

printCompositeCells(compCells, logfile);

// Get Dmax estimate

short int globalMin, globalMax;

map<unsigned short int, LIB_CELL>::iterator libIter;

libIter = invLibs.begin();

globalMin = libIter->second.getMinDelay();
globalMax = libIter->second.getMaxDelay();

//cout << "\nGLOBAL MIN:" << globalMin << " GLOBAL MAX:" << globalMax << endl;
while(libIter != invLibs.end()) {
//cout << libIter->second.getMinDelay() << " " << libIter->second.getMaxDelay() << endl;
if(libIter->second.getMinDelay() < globalMin) globalMin = libIter->second.getMinDelay();
if(libIter->second.getMaxDelay() > globalMax) globalMax = libIter->second.getMaxDelay();
libIter++;
}
//cout << "\nGLOBAL MIN:" << globalMin << " GLOBAL MAX:" << globalMax << endl;
libIter = nandLibs.begin();

while(libIter != nandLibs.end()) {
//cout << libIter->second.getMinDelay() << " " << libIter->second.getMaxDelay() << endl;
if(libIter->second.getMinDelay() < globalMin) globalMin = libIter->second.getMinDelay();
if(libIter->second.getMaxDelay() > globalMax) globalMax = libIter->second.getMaxDelay();
libIter++;
}

//cout << "\nGLOBAL MIN:" << globalMin << " GLOBAL MAX:" << globalMax << endl;
libIter = thirdLibs.begin();

while(libIter != thirdLibs.end()) {
//cout << libIter->second.getMinDelay() << " " << libIter->second.getMaxDelay() << endl;
if(libIter->second.getMinDelay() < globalMin) globalMin = libIter->second.getMinDelay();
if(libIter->second.getMaxDelay() > globalMax) globalMax = libIter->second.getMaxDelay();
libIter++;
}

//cout << "\nGLOBAL MIN:" << globalMin << " GLOBAL MAX:" << globalMax << endl;
vector<unsigned int> dmax; // absolute max delay of the eyeChart

int divFactor = 10;

cout << "\nGLOBAL MIN:" << globalMin << " GLOBAL MAX:" << globalMax<< "**** Predicted input DMAX range:" << (globalMax - globalMin)*eyeChart.logic_depth/divFactor << " to " << globalMax*eyeChart.logic_depth << endl;
logfile << "\nGLOBAL MIN:" << globalMin << " GLOBAL MAX:" << globalMax<< "**** Predicted input DMAX range:" << (globalMax - globalMin)*eyeChart.logic_depth/divFactor << " to " << globalMax*eyeChart.logic_depth << endl;

unsigned int tempDmax = 0;

if(BATCH_MODE) {
	do {
	cout << "Enter MAX delay constraint:"; cin >> tempDmax;
	logfile << "Enter MAX delay constraint:"; logfile << tempDmax << endl;
	
	if((tempDmax < (globalMax - globalMin)*eyeChart.logic_depth/divFactor || tempDmax > globalMax*eyeChart.logic_depth) && tempDmax != 0) {
		cout << "Entered value not in the range, please enter again" << endl;
		logfile<< "Entered value not in the range, please enter again" << endl;
		continue;
	}
	
	if (tempDmax != 0) // accept only non-zero constraints
	dmax.push_back(tempDmax);
	
	} while (tempDmax != 0);
} else {

cout << "HERE" << endl;
	do {
	cout << "Enter MAX delay constraint:";cin >> tempDmax;
	logfile << "Enter MAX delay constraint:"; logfile << tempDmax << endl; 
	} while(tempDmax < (globalMax - globalMin)*eyeChart.logic_depth/divFactor || tempDmax > globalMax*eyeChart.logic_depth);
	dmax.push_back(tempDmax);

}
cout << "Solving eyechart for the constraints:";
for(int cntr=0; cntr < dmax.size(); cntr++)
	cout << " " << dmax[cntr];
cout << endl;

// ***************************** Build state tables according to eyeChart formation

FULL_TABLE fullTable;


// First build all state tables for all PI arms

for(int piChain = 0; piChain < eyeChart.piChainInfo.size(); piChain++)
{

PI_ARM tempPiArm;

//cout << " Building table for PI Arm:" << piChain+1 << endl;

for(int stage =0 ; stage < eyeChart.piChainInfo[piChain].size(); stage++)
{

//cout << " Building table for Arm: " << piChain+1 << " 	Stage: "<< stage+1 << endl;

map<short int, STATE_TABLE> sstTemp; // stage's state table, int is the next stage's size index

vector<short int> nextStageSizes;
int stageId = eyeChart.piChainInfo[piChain][stage];

	if(stage == 0) {

		if(stageId == 0 || stageId == MESH_WIDTH) { // since in the current setup these are load by only INVs
			map<unsigned short int, LIB_CELL>::iterator iter;
			for(iter = invLibs.begin(); iter != invLibs.end(); iter++)
				nextStageSizes.push_back(iter->first);	
		} else {
			map<short int, vector<TUPLE_COMP_CELL> >::iterator iter; iter = compCells[stageId].loadCompCells.begin();
			while(iter != compCells[stageId].loadCompCells.end()) {
				nextStageSizes.push_back(iter->first);
				iter++;
			}
		}

		cout << "Building table for Arm: " << piChain+1 << "   Stage: " << stage+1 << " ID:" << stageId << endl;
		for(int nssIndex = 0; nssIndex < nextStageSizes.size(); nssIndex++) { // nss - next stage size

//		cout << "Building table for Arm: " << piChain+1 << "   Stage: " << stage+1 << " ID:" << stageId << "Next stage  Size: " << nextStageSizes[nssIndex] << endl;


			STATE_TABLE stTemp;		
			unsigned int currMax, currMin;
			short int nextStageSize = nextStageSizes[nssIndex];

			if(stageId == 0 || stageId == MESH_WIDTH) { // if the stage is inverter or the nand of last stage of mesh

				short int outputCap = invLibs[nextStageSize].getInputCap(); 

				map<unsigned short int,LIB_CELL>::iterator iter,endIter; 
				if(stageId == 0) {
					iter = invLibs.begin(); endIter = invLibs.end();
				}
				else {
					iter = nandLibs.begin(); endIter = nandLibs.end();
				}

				currMax = iter->second.getDelay(outputCap);
				currMin = currMax;
				
				while(iter != endIter) {
					short int currDelay = iter->second.getDelay(outputCap);
					if( currDelay < currMin )
						currMin = currDelay;
					if( currDelay > currMax )
                        	                currMax = currDelay;
					iter++;
				}

				for(unsigned int state = currMin; state <= currMax; state++) {

					map<unsigned short int, LIB_CELL>::reverse_iterator iter, endIter;

					if(stageId == 0) {
                                        	iter = invLibs.rbegin(); endIter = invLibs.rend();
					}
					else {
						iter = nandLibs.rbegin(); endIter = nandLibs.rend();
					}
                                        
					short int sizeTemp = iter->first;
                                        float leakageTemp = iter->second.getLeakage();
                                        short int delayTemp = iter->second.getDelay(outputCap);	

					while(iter != endIter) {
						if(iter->second.getDelay(outputCap) <= state && iter->second.getLeakage() < leakageTemp) {
							sizeTemp = iter->first;
							float leakageTemp = iter->second.getLeakage();
							short int delayTemp = iter->second.getDelay(outputCap);
						}
					}

					stTemp.addState(state, delayTemp, sizeTemp, leakageTemp);

                        	}

			} else { // if the stage is a composite cell

				currMax = compCells[stageId].loadCompCells[nextStageSize][0].delay;
				currMin = currMax;

				for(int i=0; i < compCells[stageId].loadCompCells[nextStageSize].size(); i++) {
					short int currDelay = compCells[stageId].loadCompCells[nextStageSize][i].delay;
					if( currDelay < currMin )
                                                        currMin = currDelay;
                                        if( currDelay > currMax )
                                                        currMax = currDelay;
				}


				for(unsigned int state = currMin; state <= currMax; state++) {

					TUPLE_COMP_CELL tempCompCellTuple = compCells[stageId].loadCompCells[nextStageSize][compCells[stageId].loadCompCells[nextStageSize].size()-1];
					short int sizeTemp = tempCompCellTuple.size;
					short int delayTemp = tempCompCellTuple.delay; float leakageTemp = tempCompCellTuple.power;

					for(int i = compCells[stageId].loadCompCells[nextStageSize].size()-1; i >= 0; i--) {
						
						TUPLE_COMP_CELL currCompCellTuple = compCells[stageId].loadCompCells[nextStageSize][i];
						short int currDelay = currCompCellTuple.delay; float currLeakage = currCompCellTuple.power;

						if(currDelay <= state && currLeakage < leakageTemp) {
							sizeTemp = currCompCellTuple.size; leakageTemp = currLeakage;
							delayTemp = currDelay;
						}

					}
					stTemp.addState(state, delayTemp, sizeTemp, leakageTemp);				
					
				}

			} // else for the composite cell case ends here

		sstTemp[nextStageSize] = stTemp; // add the state table corresponding to current output size

		} // for each next stage size ends here


	} else if (stage == eyeChart.piChainInfo[piChain].size()-1) {  // now the next stage is going to be the center cell
		
		//cout << "#########Final Stage of Arm: " << piChain+1 << endl;

		map<unsigned short int, LIB_CELL>::iterator thirdIter;
                for(thirdIter = thirdLibs.begin(); thirdIter != thirdLibs.end(); thirdIter++)
                	nextStageSizes.push_back(thirdIter->first);

		//find prev min and prev max
                unsigned int prevMin, prevMax;
                map<short int,STATE_TABLE>::iterator iter;

                iter = tempPiArm.piArm[(short int)stage-1].begin();
                prevMin = iter->second.minState(); prevMax = iter->second.maxState();

                while(iter != tempPiArm.piArm[(short int)stage-1].end()) {

                        unsigned int tempCurrMin = iter->second.minState(); unsigned int tempCurrMax = iter->second.maxState();
                        if(tempCurrMin < prevMin) prevMin = tempCurrMin;
                        if(tempCurrMax > prevMax) prevMax = tempCurrMax;
			iter++;
                }
		cout << "Building table for Arm: " << piChain+1 << "   Stage: " << stage+1 << " ID:" << stageId << " prev min: " << prevMin << "max: " << prevMax << endl;

		for(int nssIndex = 0; nssIndex < nextStageSizes.size(); nssIndex++) { // nss - next stage size
			
		//cout << "Building table for Arm: " << piChain+1 << "   Stage: " << stage+1 << " ID:" << stageId << "Next stage  Size: " << nextStageSizes[nssIndex] << endl;

			STATE_TABLE stTemp; short int currMax, currMin; short int nextStageSize = nextStageSizes[nssIndex];

			//based on the fact that the stage before star node can be only a 0 or MESH_WIDTH

			short int outputCap = thirdLibs[nextStageSize].getInputCap();
			map<unsigned short int,LIB_CELL>::iterator iter,endIter;
                        if(stageId == 0) {
                                iter = invLibs.begin(); endIter = invLibs.end();
                        }
                        else {
                                iter = nandLibs.begin(); endIter = nandLibs.end();
                        }

                        currMax = iter->second.getDelay(outputCap);
                        currMin = currMax;

			int count = 0;
			while(iter != endIter) {
                        	short int currDelay = iter->second.getDelay(outputCap);
                        	if(currDelay < currMin) currMin = currDelay;
                        	if(currDelay > currMax) currMax = currDelay;
                        	iter++;
                	}

                	//start the state iteration
                	for(unsigned int state = currMin + prevMin; state <= currMax+prevMax; state++) {

                        	map<float, STATE_TRIPLET> tempRev;

                        	map<unsigned short int,LIB_CELL>::reverse_iterator iter,endIter;
                        	if(stageId == 0) {
                        	        iter = invLibs.rbegin(); endIter = invLibs.rend();
                        	}
                        	else {
                        	        iter = nandLibs.rbegin(); endIter = nandLibs.rend();
                        	}

                        	while(iter != endIter) {

                        	        short int currDelay = iter->second.getDelay(outputCap); unsigned int prevState;

                        	        if(currDelay >= state) { iter++; continue;}
                        	        prevState = state-currDelay;
                        	        if(prevState <= 0) { iter++; continue;}

                        	        bool isOverRange;
                        	        if(tempPiArm.piArm[stage-1][iter->first].isStateAvailable(prevState, isOverRange)) {
                        	                float rev = iter->second.getLeakage() + tempPiArm.piArm[stage-1][iter->first].getLeakage(prevState,isOverRange);
                        	                STATE_TRIPLET currTriplet(currDelay, iter->first, rev);
                        	                tempRev[rev] = currTriplet;
                        	        }

				iter++;
                        	} // for each size iteration ends here

                        	if(!tempRev.empty()) {
                        	        map<float, STATE_TRIPLET>::iterator it; it = tempRev.begin();
                        	        stTemp.addState(state, it->second.delay_cost, it->second.size, it->second.leakage);

                        	} else {
                        	        if(PRINT_STATE_NOT_INFO)
                        	                stateLogFile << "NOT added state:"<< state << " for next stage size:" << nextStageSize <<" for stage:" << stage+1 << endl;
                        	}
                	}// for each state ends here

		sstTemp[nextStageSize] = stTemp; // add the state table corresponding to current output size

		} // for each next stage size ends here


	} else { // for all  other non-first non end stages of a PI arm

                if(stageId == 0 || stageId == MESH_WIDTH) { // since in the current setup these are load by only INVs
                        map<unsigned short int, LIB_CELL>::iterator iter;
                        for(iter = invLibs.begin(); iter != invLibs.end(); iter++)
                                nextStageSizes.push_back(iter->first);  
                } else {
                        map<short int, vector<TUPLE_COMP_CELL> >::iterator iter; iter = compCells[stageId].loadCompCells.begin();
                        while(iter != compCells[stageId].loadCompCells.end()) {
                                nextStageSizes.push_back(iter->first);
                                iter++;
                        }
                }
		//find prev min and prev max
		unsigned int prevMin, prevMax;
		map<short int,STATE_TABLE>::iterator iter;

		iter = tempPiArm.piArm[stage-1].begin();
		prevMin = iter->second.minState(); prevMax = iter->second.maxState();
		
		while(iter != tempPiArm.piArm[stage-1].end()) {

		//cout << "REACHED HRERE:"<< cntr++  << endl;
			unsigned int tempCurrMin = iter->second.minState(); unsigned int tempCurrMax = iter->second.maxState();
			if(tempCurrMin < prevMin) prevMin = tempCurrMin;
			if(tempCurrMax > prevMax) prevMax = tempCurrMax;
			iter++;
		}
		cout << "Building table for Arm: " << piChain+1 << "   Stage: " << stage+1 << " ID:" << stageId << " prev min: " << prevMin << "max: " << prevMax << endl;

		// iterate for each next stage size 
		for(int nssIndex = 0; nssIndex < nextStageSizes.size(); nssIndex++) { // nss - next stage size
		
		//cout << "Building table for Arm: " << piChain+1 << "   Stage: " << stage+1 << " ID:" << stageId << "Next stage  Size: " << nextStageSizes[nssIndex] << endl;

                        STATE_TABLE stTemp; short int currMax, currMin; short int nextStageSize = nextStageSizes[nssIndex];

			if(stageId == 0 || stageId == MESH_WIDTH) { // if the stage is inverter or the nand of last stage of mesh
                                short int outputCap = invLibs[nextStageSize].getInputCap();

                                map<unsigned short int,LIB_CELL>::iterator iter, endIter;
                                if(stageId == 0) {
                                        iter = invLibs.begin(); endIter = invLibs.end();
                                }
                                else {
                                        iter = nandLibs.begin(); endIter = nandLibs.end();
                                }

                                currMax = iter->second.getDelay(outputCap);
                                currMin = currMax;

                                while(iter != endIter) {
                                        short int currDelay = iter->second.getDelay(outputCap);
                                        if(currDelay < currMin)
                                                currMin = currDelay;
                                        if(currDelay > currMax)
                                                currMax = currDelay;
                                        iter++;
                                }

				//start the state iteration
				for(unsigned int state = currMin + prevMin; state <= currMax+prevMax; state++) {

					map<float, STATE_TRIPLET> tempRev;

					map<unsigned short int,LIB_CELL>::reverse_iterator iter,endIter;
					if(stageId == 0) {
                                        	iter = invLibs.rbegin(); endIter = invLibs.rend();
                                	}
                                	else {
                                        	iter = nandLibs.rbegin(); endIter = nandLibs.rend();
                                	}

					while(iter != endIter) {

						short int currDelay = iter->second.getDelay(outputCap); unsigned int prevState;

						if(currDelay >= state) { iter++; continue;}
							prevState = state-currDelay;
						if(prevState <= 0) { iter++; continue;}

						bool isOverRange;
						if(tempPiArm.piArm[stage-1][iter->first].isStateAvailable(prevState, isOverRange)) {
							float rev = iter->second.getLeakage() + tempPiArm.piArm[stage-1][iter->first].getLeakage(prevState,isOverRange);
							STATE_TRIPLET currTriplet(currDelay, iter->first, rev);
							tempRev[rev] = currTriplet;
						}
					iter++;
					} // for each size iteration ends here

					if(!tempRev.empty()) {
						map<float, STATE_TRIPLET>::iterator it; it = tempRev.begin();
						stTemp.addState(state, it->second.delay_cost, it->second.size, it->second.leakage);

					} else {
						if(PRINT_STATE_NOT_INFO)
							stateLogFile << "NOT added state:"<< state << " for next stage size:" << nextStageSize <<" for stage:" << stage+1 << endl;
					}
				}// for each state ends here

			} else {

				currMax = compCells[stageId].loadCompCells[nextStageSize][0].delay;
                                currMin = currMax;

                                for(int i=0; i < compCells[stageId].loadCompCells[nextStageSize].size(); i++) {
                                        short int currDelay = compCells[stageId].loadCompCells[nextStageSize][i].delay;
                                        if( currDelay < currMin )
                                        currMin = currDelay;
                                        if( currDelay > currMax )
                                        currMax = currDelay;
                                }

				// start the state iteration
				for(unsigned int state = currMin + prevMin; state <= currMax + prevMax; state++) {

					map<float, STATE_TRIPLET> tempRev;

					for(int i = compCells[stageId].loadCompCells[nextStageSize].size()-1; i >= 0; i--) {

						TUPLE_COMP_CELL tempTupleCompCell = compCells[stageId].loadCompCells[nextStageSize][i];
						short int currDelay = tempTupleCompCell.delay; unsigned int prevState;

						if(currDelay >= state) continue;
                                                        prevState = state-currDelay;
                                                if(prevState <= 0) continue;
						
						bool isOverRange;
						if(tempPiArm.piArm[stage-1][tempTupleCompCell.size].isStateAvailable(prevState, isOverRange)) {
							float rev = tempTupleCompCell.power + tempPiArm.piArm[stage-1][tempTupleCompCell.size].getLeakage(prevState,isOverRange);
							STATE_TRIPLET currTriplet(currDelay, tempTupleCompCell.size, rev);
							tempRev[rev] = currTriplet;
						}
					} // for each size iteration ends here

					if(!tempRev.empty()) {
                                                map<float, STATE_TRIPLET>::iterator it; it = tempRev.begin();
                                                stTemp.addState(state, it->second.delay_cost, it->second.size, it->second.leakage);
 
                                        } else { 
                                                if(PRINT_STATE_NOT_INFO)
                                                        stateLogFile << "NOT added state:"<< state << " for next stage size:" << nextStageSize <<" for stage:" << stage+1 << endl;
                                        }
				}// for each state ends here
			} // composite cell case ends here

		sstTemp[nextStageSize] = stTemp; // add the state table corresponding to current output size
		} // for each next stage size ends here

	} // all other stage's ends here


//cout << "\n ************pushing sst on to arm:" << piChain+1 << "and stage : " << stage+1 << endl << endl;
tempPiArm.piArm.push_back(sstTemp);

} // for each stage of a piChain ends here
		

fullTable.piArmVector.push_back(tempPiArm);

} // for each piChain ends here



//************************************* Now build PI composite Arm

//PI_COMP_ARM piCompArm;

vector<short int> nextStageSizes; 

map<unsigned short int, LIB_CELL>::iterator thirdIter;
for(thirdIter = thirdLibs.begin(); thirdIter != thirdLibs.end(); thirdIter++)
        nextStageSizes.push_back(thirdIter->first);


for(int nssIndex = 0 ; nssIndex < nextStageSizes.size(); nssIndex++) {
	short int nextStageSize = nextStageSizes[nssIndex];
	STATE_TABLE tempCompST; 

	unsigned int minState, maxState;
	minState = fullTable.piArmVector[0].piArm[fullTable.piArmVector[0].piArm.size()-1][nextStageSize].minState();
	maxState = fullTable.piArmVector[0].piArm[fullTable.piArmVector[0].piArm.size()-1][nextStageSize].maxState();

	
	for(int i=0; i < fullTable.piArmVector.size(); i++) {
		if(fullTable.piArmVector[i].piArm[fullTable.piArmVector[i].piArm.size()-1][nextStageSize].minState() > minState)
			minState = fullTable.piArmVector[i].piArm[fullTable.piArmVector[i].piArm.size()-1][nextStageSize].minState();

		if(fullTable.piArmVector[i].piArm[fullTable.piArmVector[i].piArm.size()-1][nextStageSize].maxState() > maxState)
                        maxState = fullTable.piArmVector[i].piArm[fullTable.piArmVector[i].piArm.size()-1][nextStageSize].maxState();
	}

//cout << "Next State size: " << nextStageSize << "min: " << minState << "max: " << maxState << endl;

	for(unsigned int state = minState; state <= maxState; state++) {

		float tempPower = 0;

		for(int i =0 ; i < fullTable.piArmVector.size(); i++) {
			bool isOverRange;
			if(fullTable.piArmVector[i].piArm[fullTable.piArmVector[i].piArm.size()-1][nextStageSize].isStateAvailable(state,isOverRange))
				tempPower += fullTable.piArmVector[i].piArm[fullTable.piArmVector[i].piArm.size()-1][nextStageSize].getLeakage(state,isOverRange);
		}
		
		tempCompST.addState(state,0,0,tempPower);

	}

	fullTable.piCompArm[nextStageSize] = tempCompST;

}

// ******************************** Now build center cell's state table

map<unsigned short int, LIB_CELL>::iterator libiIter;
for(libIter = invLibs.begin(); libIter != invLibs.end(); libIter++) // center cell can only be loaded by invs
	nextStageSizes.push_back(libIter->first);

//find prev min and prev max

unsigned int prevMin, prevMax;
map<short int,STATE_TABLE>::iterator iter;

iter = fullTable.piCompArm.begin();
prevMin = iter->second.minState(); prevMax = iter->second.maxState();

while(iter != fullTable.piCompArm.end()) {
        unsigned int tempCurrMin = iter->second.minState();unsigned int tempCurrMax = iter->second.maxState();
        if(tempCurrMin < prevMin) prevMin = tempCurrMin;
        if(tempCurrMax > prevMax) prevMax = tempCurrMax;
        iter++;
}

cout << "Building table for Center Cell  Stage ID:" << STAR_CELL_ID << " prev min: " << prevMin << "max: " << prevMax << endl;

for(int nssIndex = 0; nssIndex < nextStageSizes.size(); nssIndex++) { // nss - next stage size

STATE_TABLE stTemp; short int currMax, currMin; short int nextStageSize = nextStageSizes[nssIndex];

        short int outputCap = STAR_FANOUT*(invLibs[nextStageSize].getInputCap());

        map<unsigned short int,LIB_CELL>::iterator iter;
                iter = thirdLibs.begin();

        currMax = iter->second.getDelay(outputCap);
        currMin = currMax;

        while(iter != thirdLibs.end()) {
                short int currDelay = iter->second.getDelay(outputCap);
                if(currDelay < currMin)
                        currMin = currDelay;
                if(currDelay > currMax)
                        currMax = currDelay;
                iter++;
        }

//start the state iteration
	for(unsigned int state = currMin + prevMin; state <= currMax+prevMax; state++) {
	
	        map<float, STATE_TRIPLET> tempRev;
	        map<unsigned short int,LIB_CELL>::reverse_iterator iter;
		iter = thirdLibs.rbegin();
	
	        while(iter != thirdLibs.rend()) {
	                short int currDelay = iter->second.getDelay(outputCap); unsigned int prevState;
	                if(currDelay >= state) {iter++; continue;}
	                        prevState = state-currDelay;
	                if(prevState <= 0) {iter++; continue;}
	
	                bool isOverRange;
	                if(fullTable.piCompArm[iter->first].isStateAvailable(prevState, isOverRange)) {
	                        float rev = iter->second.getLeakage() + fullTable.piCompArm[iter->first].getLeakage(prevState,isOverRange);
	                        STATE_TRIPLET currTriplet(currDelay, iter->first, rev);
	                        tempRev[rev] = currTriplet;
	                }
	        iter++;
	        } // for each size iteration ends here
	
	        if(!tempRev.empty()) {
	                map<float, STATE_TRIPLET>::iterator it; it = tempRev.begin();
	                stTemp.addState(state, it->second.delay_cost, it->second.size, it->second.leakage);
	
	        } else {
	                if(PRINT_STATE_NOT_INFO)
	                        stateLogFile << "NOT added state:"<< state << " for next stage size:" << nextStageSize <<" for Center Cell stage" << endl;
	        }
	}// for each state ends here

fullTable.centerCellTable[nextStageSize] = stTemp;

}

// ************************** Now build state tables for all PO arm stages (code similar to PI side)

if(IS_PO_CHAIN_SYMMETRIC) {
for(int stage =0 ; stage < eyeChart.poChainInfo[0].size(); stage++) // since all po chains are symmetric
{

map<short int, STATE_TABLE> sstTemp; // stage's state table, int is the next stage's size index
vector<short int> nextStageSizes;
int stageId = eyeChart.poChainInfo[0][stage];

	// ################## FIRST STAGE CASE #############

        if(stage == 0) {

                if(stageId == 0 || stageId == MESH_WIDTH) { // since in the current setup these are load by only INVs
                        map<unsigned short int, LIB_CELL>::iterator iter;
                        for(iter = invLibs.begin(); iter != invLibs.end(); iter++)
                                nextStageSizes.push_back(iter->first);
                } else {
                        map<short int, vector<TUPLE_COMP_CELL> >::iterator iter; iter = compCells[stageId].loadCompCells.begin();
                        while(iter != compCells[stageId].loadCompCells.end()) {
                                nextStageSizes.push_back(iter->first);
                                iter++;
                        }
                }
                //find prev min and prev max
                unsigned int prevMin, prevMax;
                map<short int,STATE_TABLE>::iterator iter;

                iter = fullTable.centerCellTable.begin();
                prevMin = iter->second.minState(); prevMax = iter->second.maxState();

                while(iter != fullTable.centerCellTable.end()) {

                //cout << "REACHED HRERE:"<< cntr++  << endl;
                        unsigned int tempCurrMin = iter->second.minState(); unsigned int tempCurrMax = iter->second.maxState();
                        if(tempCurrMin < prevMin) prevMin = tempCurrMin;
                        if(tempCurrMax > prevMax) prevMax = tempCurrMax;
                        iter++;
                }
                cout << "Building table for PO Arm Stage: " << stage+1 << " ID:" << stageId << " prev min: " << prevMin << "max: " << prevMax << endl;
                // iterate for each next stage size 
                for(int nssIndex = 0; nssIndex < nextStageSizes.size(); nssIndex++) { // nss - next stage size

                        STATE_TABLE stTemp; short int currMax, currMin; short int nextStageSize = nextStageSizes[nssIndex];

                        if(stageId == 0 || stageId == MESH_WIDTH) { // if the stage is inverter or the nand of last stage of mesh

                                short int outputCap = invLibs[nextStageSize].getInputCap();

                                map<unsigned short int,LIB_CELL>::iterator iter, endIter;
                                if(stageId == 0) {
                                        iter = invLibs.begin(); endIter = invLibs.end();
                                }
                                else {
                                        iter = nandLibs.begin(); endIter = nandLibs.end();
                                }

                                currMax = iter->second.getDelay(outputCap);
                                currMin = currMax;

                                while(iter != endIter) {
                                        short int currDelay = iter->second.getDelay(outputCap);
                                        if(currDelay < currMin)
                                                currMin = currDelay;
                                        if(currDelay > currMax)
                                                currMax = currDelay;
                                        iter++;
                                }
                                //start the state iteration
                                for(unsigned int state = currMin + prevMin; state <= currMax+prevMax; state++) {
                                        
					map<float, STATE_TRIPLET> tempRev;
                                        map<unsigned short int,LIB_CELL>::reverse_iterator iter,endIter;
                                        if(stageId == 0) {
                                                iter = invLibs.rbegin(); endIter = invLibs.rend();
                                        }
                                        else {
                                                iter = nandLibs.rbegin(); endIter = nandLibs.rend();
                                        }

                                        while(iter != endIter) {

                                                short int currDelay = iter->second.getDelay(outputCap); unsigned int prevState;

                                                if(currDelay >= state) {iter++; continue;}
                                                        prevState = state-currDelay;
                                                if(prevState <= 0) {iter++; continue;}

                                                bool isOverRange;
                                                if(fullTable.centerCellTable[iter->first].isStateAvailable(prevState, isOverRange)) {
                                                        float rev = STAR_FANOUT*iter->second.getLeakage() + fullTable.centerCellTable[iter->first].getLeakage(prevState,isOverRange);
                                                        STATE_TRIPLET currTriplet(currDelay, iter->first, rev);
                                                        tempRev[rev] = currTriplet;
                                                }
                                        iter++;
                                        } // for each size iteration ends here

                                        if(!tempRev.empty()) {
                                                map<float, STATE_TRIPLET>::iterator it; it = tempRev.begin();
                                                stTemp.addState(state, it->second.delay_cost, it->second.size, it->second.leakage);

                                        } else {
                                                if(PRINT_STATE_NOT_INFO)
                                                        stateLogFile << "NOT added state:"<< state << " for next stage size:" << nextStageSize <<" for stage:" << stage+1 << endl;
                                        }
                                }// for each state ends here

                        } else {

                                currMax = compCells[stageId].loadCompCells[nextStageSize][0].delay;
                                currMin = currMax;

                                for(int i=0; i < compCells[stageId].loadCompCells[nextStageSize].size(); i++) {
                                        short int currDelay = compCells[stageId].loadCompCells[nextStageSize][i].delay;
                                        if( currDelay < currMin )
                                        currMin = currDelay;
                                        if( currDelay > currMax )
                                        currMax = currDelay;
                                }

                                // start the state iteration
                                for(unsigned int state = currMin + prevMin; state <= currMax + prevMax; state++) {

                                        map<float, STATE_TRIPLET> tempRev;

                                        for(int i = compCells[stageId].loadCompCells[nextStageSize].size()-1; i >= 0; i--) {

                                                TUPLE_COMP_CELL tempTupleCompCell = compCells[stageId].loadCompCells[nextStageSize][i];
                                                short int currDelay = tempTupleCompCell.delay; unsigned int prevState;

                                                if(currDelay >= state) continue;
                                                        prevState = state-currDelay;
                                                if(prevState <= 0) continue;

                                                bool isOverRange;
                                                if(fullTable.piCompArm[tempTupleCompCell.size].isStateAvailable(prevState, isOverRange)) { 
                                                        float rev = STAR_FANOUT*tempTupleCompCell.power + fullTable.piCompArm[tempTupleCompCell.size].getLeakage(prevState,isOverRange);
                                                        STATE_TRIPLET currTriplet(currDelay, tempTupleCompCell.size, rev);
                                                        tempRev[rev] = currTriplet;
                                                }
                                        } // for each size iteration ends here

                                        if(!tempRev.empty()) {
                                                map<float, STATE_TRIPLET>::iterator it; it = tempRev.begin();
                                                stTemp.addState(state, it->second.delay_cost, it->second.size, it->second.leakage);

                                        } else {
                                                if(PRINT_STATE_NOT_INFO)
                                                        stateLogFile << "NOT added state:"<< state << " for next stage size:" << nextStageSize <<" for stage:" << stage+1 << endl;
                                        }
                                }// for each state ends here
                        } // composite cell case ends here

                sstTemp[nextStageSize] = stTemp; // add the state table corresponding to current output size
                } // for each next stage size ends here

	// ################## LAST STAGE CASE ############################################


	} else if(stage == eyeChart.poChainInfo[0].size()-1 ) { // last stage of the  PO arm, could only be 0 or MESH_WIDTH

		short int outputCap = LOAD_CAP; STATE_TABLE stTemp;

		for(int stateIndx = 0; stateIndx < dmax.size(); stateIndx++) { 
			unsigned int state = dmax[stateIndx];


			map<float, STATE_TRIPLET> tempRev;
                	map<unsigned short int,LIB_CELL>::reverse_iterator iter,endIter;
                	if(stageId == 0) {
                	        iter = invLibs.rbegin(); endIter = invLibs.rend();
                	}
                	else {
                	        iter = nandLibs.rbegin(); endIter = nandLibs.rend();
                	}


			while(iter != endIter) {
			
			        short int currDelay = iter->second.getDelay(outputCap); unsigned int prevState;
			
			        if(currDelay >= state) {iter++; continue;}
			                prevState = state-currDelay;
			        if(prevState <= 0) {iter++; continue;}
			
			        bool isOverRange;
			        if(fullTable.poArm.piArm[stage-1][iter->first].isStateAvailable(prevState, isOverRange)) {
			                float rev = STAR_FANOUT*iter->second.getLeakage() + fullTable.poArm.piArm[stage-1][iter->first].getLeakage(prevState,isOverRange);
			                STATE_TRIPLET currTriplet(currDelay, iter->first, rev);
			                tempRev[rev] = currTriplet;
			        }
			iter++;
			} // for each size iteration ends here
			
			if(!tempRev.empty()) {
			        map<float, STATE_TRIPLET>::iterator it; it = tempRev.begin();
			        stTemp.addState(state, it->second.delay_cost, it->second.size, it->second.leakage);
			
			} else {
			        if(PRINT_STATE_TABLE_INFO)
			                stateLogFile << "\n *********ERROR: STATE " << state  << " IS NOT ENOUGH TO ACCOMODATE SIZES" << endl;
			                cout << "\n *********ERROR: STATE " << state  << " IS NOT ENOUGH TO ACCOMODATE SIZES" << endl;
			}
		}
		
		sstTemp[outputCap] = stTemp;

	// ################## INTERMEDIATE STAGE CASE ############################################

	} else {

                if(stageId == 0 || stageId == MESH_WIDTH) { // since in the current setup these are load by only INVs
                        map<unsigned short int, LIB_CELL>::iterator iter;
                        for(iter = invLibs.begin(); iter != invLibs.end(); iter++)
                                nextStageSizes.push_back(iter->first);
                } else {
                        map<short int, vector<TUPLE_COMP_CELL> >::iterator iter; iter = compCells[stageId].loadCompCells.begin();
                        while(iter != compCells[stageId].loadCompCells.end()) {
                                nextStageSizes.push_back(iter->first);
                                iter++; 
                        }
                }
                //find prev min and prev max
                unsigned int prevMin, prevMax;
                map<short int,STATE_TABLE>::iterator iter; 

                iter = fullTable.poArm.piArm[stage-1].begin();
                prevMin = iter->second.minState(); prevMax = iter->second.maxState();

                while(iter != fullTable.poArm.piArm[stage-1].end()) {

                //cout << "REACHED HRERE:"<< cntr++  << endl;
                        unsigned int tempCurrMin = iter->second.minState(); unsigned int tempCurrMax = iter->second.maxState();
                        if(tempCurrMin < prevMin) prevMin = tempCurrMin;
                        if(tempCurrMax > prevMax) prevMax = tempCurrMax;
                        iter++;
                }
                cout << "Building table for PO Arm Stage: " << stage+1 << " ID:" << stageId << " prev min: " << prevMin << "max: " << prevMax << endl;
                // iterate for each next stage size 
                for(int nssIndex = 0; nssIndex < nextStageSizes.size(); nssIndex++) { // nss - next stage size

                        STATE_TABLE stTemp; short int currMax, currMin; short int nextStageSize = nextStageSizes[nssIndex];

                        if(stageId == 0 || stageId == MESH_WIDTH) { // if the stage is inverter or the nand of last stage of mesh

                                short int outputCap = invLibs[nextStageSize].getInputCap();

                                map<unsigned short int,LIB_CELL>::iterator iter, endIter;
                                if(stageId == 0) {
                                        iter = invLibs.begin(); endIter = invLibs.end();
                                }
                                else {
                                        iter = nandLibs.begin(); endIter = nandLibs.end();
                                }

                                currMax = iter->second.getDelay(outputCap);
                                currMin = currMax;

                                while(iter != endIter) {
                                        short int currDelay = iter->second.getDelay(outputCap);
                                        if(currDelay < currMin)
                                                currMin = currDelay;
                                        if(currDelay > currMax)
                                                currMax = currDelay;
                                        iter++;
                                }
                                //start the state iteration
                                for(int state = currMin + prevMin; state <= currMax+prevMax; state++) {

                                        map<float, STATE_TRIPLET> tempRev;
                                        map<unsigned short int,LIB_CELL>::reverse_iterator iter,endIter;
                                        if(stageId == 0) {
                                                iter = invLibs.rbegin(); endIter = invLibs.rend();
                                        }
                                        else {
                                                iter = nandLibs.rbegin(); endIter = nandLibs.rend();
                                        }

                                        while(iter != endIter) {

                                                short int currDelay = iter->second.getDelay(outputCap); unsigned int prevState;

                                                if(currDelay >= state) {iter++; continue;}
                                                        prevState = state-currDelay;
                                                if(prevState <= 0) {iter++; continue;}

                                                bool isOverRange;
                                                if(fullTable.poArm.piArm[stage-1][iter->first].isStateAvailable(prevState, isOverRange)) {
                                                        float rev = STAR_FANOUT*iter->second.getLeakage() + fullTable.poArm.piArm[stage-1][iter->first].getLeakage(prevState,isOverRange);
                                                        STATE_TRIPLET currTriplet(currDelay, iter->first, rev);
                                                        tempRev[rev] = currTriplet;
                                                }
                                        iter++;
                                        } // for each size iteration ends here

                                        if(!tempRev.empty()) {
                                                map<float, STATE_TRIPLET>::iterator it; it = tempRev.begin();
                                                stTemp.addState(state, it->second.delay_cost, it->second.size, it->second.leakage);

                                        } else {
                                                if(PRINT_STATE_NOT_INFO)
                                                        stateLogFile << "NOT added state:"<< state << " for next stage size:" << nextStageSize <<" for stage:" << stage+1 << endl;
                                        }
                                }// for each state ends here
                        } else {

                                currMax = compCells[stageId].loadCompCells[nextStageSize][0].delay;
                                currMin = currMax;

                                for(int i=0; i < compCells[stageId].loadCompCells[nextStageSize].size(); i++) {
                                        short int currDelay = compCells[stageId].loadCompCells[nextStageSize][i].delay;
                                        if( currDelay < currMin )
                                        currMin = currDelay;
                                        if( currDelay > currMax )
                                        currMax = currDelay;
                                }

                                // start the state iteration
                                for(unsigned int state = currMin + prevMin; state <= currMax + prevMax; state++) {

                                        map<float, STATE_TRIPLET> tempRev;

                                        for(int i = compCells[stageId].loadCompCells[nextStageSize].size()-1; i >= 0; i--) {

                                                TUPLE_COMP_CELL tempTupleCompCell = compCells[stageId].loadCompCells[nextStageSize][i];
                                                short int currDelay = tempTupleCompCell.delay; unsigned int prevState;

                                                if(currDelay >= state) continue;
                                                        prevState = state-currDelay;
                                                if(prevState <= 0) continue;

                                                bool isOverRange;
                                                if(fullTable.poArm.piArm[stage-1][tempTupleCompCell.size].isStateAvailable(prevState, isOverRange)) {
                                                        float rev = STAR_FANOUT*tempTupleCompCell.power + fullTable.poArm.piArm[stage-1][tempTupleCompCell.size].getLeakage(prevState,isOverRange);
                                                        STATE_TRIPLET currTriplet(currDelay, tempTupleCompCell.size, rev);
                                                        tempRev[rev] = currTriplet;
                                                }
                                        } // for each size iteration ends here

                                        if(!tempRev.empty()) {
                                                map<float, STATE_TRIPLET>::iterator it; it = tempRev.begin();
                                                stTemp.addState(state, it->second.delay_cost, it->second.size, it->second.leakage);

                                        } else {
                                                if(PRINT_STATE_NOT_INFO)
                                                        stateLogFile << "NOT added state:"<< state << " for next stage size:" << nextStageSize <<" for stage:" << stage+1 << endl;
                                        }
                                }// for each state ends here
                        } // composite cell case ends here

                sstTemp[nextStageSize] = stTemp; // add the state table corresponding to current output size
                } // for each next stage size ends here
	} // other stage case ends here

fullTable.poArm.piArm.push_back(sstTemp);

}// for each stage ends
}// if IS_PO_SYMMETRIC ends




// ******************************* Back traverse to find optimals sizes

for(int dmaxIndx = 0; dmaxIndx < dmax.size(); dmaxIndx++) {

unsigned int remBudget = 0; short int passBackSize = 0;
unsigned int currDmax = dmax[dmaxIndx];

//cout << "check:" << currDmax << endl;

//first collect po arm opt sizesa
eyeChart.poOptSizes.push_back( map<int,int>() );

for(int i = fullTable.poArm.piArm.size()-1; i >= 0; i--) {

	map<short int,STATE_TABLE>::iterator iter;

	if(i == fullTable.poArm.piArm.size()-1) {
		
		iter = fullTable.poArm.piArm[i].begin();
		passBackSize = iter->second.getSize(currDmax,false);
		eyeChart.poOptSizes[0][i+1] = passBackSize;
		remBudget = currDmax - iter->second.getDelayCost(currDmax,false);
		cout << "Dmax: " << currDmax << " OPTIMAL POWER: " << iter->second.getLeakage(currDmax,false); 
	} else {

		bool isOverRange;
		fullTable.poArm.piArm[i][passBackSize].isStateAvailable(remBudget,isOverRange);
		short int currDelay = fullTable.poArm.piArm[i][passBackSize].getDelayCost(remBudget,isOverRange);
		passBackSize = fullTable.poArm.piArm[i][passBackSize].getSize(remBudget,isOverRange);
		eyeChart.poOptSizes[0][i+1] = passBackSize;

		remBudget = remBudget - currDelay;

	}
}


// duplicating po arm opt sizes, due to symmetry of PO arms
for(int i = 1; i < STAR_FANOUT; i++) {

eyeChart.poOptSizes.push_back(eyeChart.poOptSizes[0]);

}

//for(int i =0; i < STAR_FANOUT; i++) {
//	cout << "PO ARM:" << i+1 << endl;
//	map<int,int>::iterator siter;
//	siter = eyeChart.poOptSizes[i].begin();
//	cout << "Stage	Size" << endl;
//	while(siter != eyeChart.poOptSizes[i].end()) {
//	cout << siter->first << "\t" << siter->second << endl;
//	siter++;
//	}
//
//}

// now find the optimal size for star node

bool isOverRange;
fullTable.centerCellTable[passBackSize].isStateAvailable(remBudget, isOverRange);
short int currDelay = fullTable.centerCellTable[passBackSize].getDelayCost(remBudget,isOverRange);
passBackSize = fullTable.centerCellTable[passBackSize].getSize(remBudget, isOverRange);
eyeChart.starOptSize = passBackSize;
remBudget = remBudget - currDelay;
eyeChart.centerCellRemBudget = remBudget;

cout << "\nCenter node size: " << eyeChart.starOptSize << endl;;
cout << "Center node pass back budget: " << eyeChart.centerCellRemBudget << endl;;

//now back traverse each of the PI arms
for(int i = 0; i < fullTable.piArmVector.size(); i++) {
eyeChart.piOptSizes.push_back( map<int,int>() );
remBudget = eyeChart.centerCellRemBudget;


	for(int j = fullTable.piArmVector[i].piArm.size()-1; j >= 0; j--) {
	
	
	        if(j == fullTable.piArmVector[i].piArm.size()-1) {
	
			bool isOverRange;
			fullTable.piArmVector[i].piArm[j][eyeChart.starOptSize].isStateAvailable(remBudget, isOverRange);
			short int currDelay = fullTable.piArmVector[i].piArm[j][eyeChart.starOptSize].getDelayCost(remBudget, isOverRange);
	                passBackSize = fullTable.piArmVector[i].piArm[j][eyeChart.starOptSize].getSize(remBudget,isOverRange);
	                eyeChart.piOptSizes[i][j+1] = passBackSize;
	                remBudget = remBudget - currDelay;
			//cout << "PI arm " << i+1 << " stage " << j+1 << "rem budget: " << remBudget << endl;  

	        } else {

			bool isOverRange; 
                        fullTable.piArmVector[i].piArm[j][passBackSize].isStateAvailable(remBudget, isOverRange);
                        short int currDelay = fullTable.piArmVector[i].piArm[j][passBackSize].getDelayCost(remBudget, isOverRange);
                        passBackSize = fullTable.piArmVector[i].piArm[j][passBackSize].getSize(remBudget,isOverRange);
                        eyeChart.piOptSizes[i][j+1] = passBackSize;
                        remBudget = remBudget - currDelay;
	
			//cout << "PI arm " << i+1 << " stage " << j+1 << "rem budget: " << remBudget << endl;  
	
	        }
	}

cout << "Remaining budget for Arm" << i+1 << ":" << remBudget << endl;

}


//for(int i =0; i < fullTable.piArmVector.size(); i++) {
//        cout << "PI ARM:" << i+1 << endl;
//        map<int,int>::iterator siter;
//        siter = eyeChart.piOptSizes[i].begin();
//        cout << "Stage  Size" << endl;
//        while(siter != eyeChart.piOptSizes[i].end()) {
//        cout << siter->first << "\t" << siter->second << endl;
//        siter++;
//        }
//
//}


// **************** Write optimal netlist info

//cout << "HERE" << endl;

string netlistName = "opt_netlist_";
{
ostringstream oss; 
oss << currDmax;

netlistName.append(oss.str());
netlistName.append(".info");
}

fstream optNetlist;
optNetlist.open(netlistName.c_str(), ios::out);

for(int i =0 ; i < eyeChart.piOptSizes.size(); i++) {
string piLine = "PI"; 
ostringstream oss;
oss << i+1;
piLine.append(oss.str()); piLine.append(":");
	map<int,int>::iterator iter;
	for(iter= eyeChart.piOptSizes[i].begin(); iter != eyeChart.piOptSizes[i].end(); iter++) {

		ostringstream oss1, oss2, oss3;
		int stageId = eyeChart.piChainInfo[i][iter->first - 1];
		int optSize = iter->second;
		oss1 << stageId;
		piLine.append(oss1.str()); piLine.append("-(");	
		if(stageId == 1 || stageId == MESH_WIDTH || stageId == 0) {
		oss2 << optSize;
		piLine.append(oss2.str()); piLine.append(") ");
		} else {
			vector<short int> tempOptSizeVector;
			tempOptSizeVector = compCells[(unsigned int)stageId].sizeVectors[optSize-1];
			int k =0; 
			for(; k < tempOptSizeVector.size()-1; k++) {
				ostringstream ossLocal; ossLocal << tempOptSizeVector[k];
				piLine.append(ossLocal.str());
				piLine.append(",");	
			}
			oss3 << tempOptSizeVector[k]; 
			piLine.append(oss3.str()); piLine.append(") ");
		}
	}
optNetlist << piLine << endl;
}

{
ostringstream oss1,oss2;
string starSize; starSize.append("STAR:");
oss1 << STAR_CELL_ID; starSize.append(oss1.str()); starSize.append("-(");
oss2 << eyeChart.starOptSize; starSize.append(oss2.str()); starSize.append(")");

optNetlist << starSize << endl;
}

for(int i =0 ; i < eyeChart.poOptSizes.size(); i++) {
string poLine = "PO";
ostringstream oss;
oss << i+1;
poLine.append(oss.str()); poLine.append(":");
        map<int,int>::iterator iter;
        for(iter= eyeChart.poOptSizes[i].begin(); iter != eyeChart.poOptSizes[i].end(); iter++) {

                ostringstream oss1, oss2, oss3;
                int stageId = eyeChart.poChainInfo[i][iter->first - 1];
                int optSize = iter->second;
                oss1 << stageId;
                poLine.append(oss1.str()); poLine.append("-(");
                if(stageId == 1 || stageId == MESH_WIDTH || stageId == 0) {
                oss2 << optSize;
                poLine.append(oss2.str()); poLine.append(") ");
                } else {
                        vector<short int> tempOptSizeVector;
                        tempOptSizeVector = compCells[(short int)stageId].sizeVectors[optSize-1];
                        int k =0;
                        for(; k < tempOptSizeVector.size()-1; k++) {
                                ostringstream ossLocal; ossLocal << tempOptSizeVector[k];
                                poLine.append(ossLocal.str());
                                poLine.append(",");
                        }
                        oss3 << tempOptSizeVector[k];
                        poLine.append(oss3.str()); poLine.append(") ");
                }
        }
optNetlist << poLine << endl;
}

optNetlist.close();


eyeChart.piOptSizes.clear();
eyeChart.poOptSizes.clear();

}

// ******************************** PRINT STATE TABLES ********************
if(PRINT_STATE_TABLE_INFO)
{

	cout << " #### Writing state tables to the file ####" << endl;
	
	stateLogFile << "\n" << endl;
		
	for(int x = 0; x < fullTable.piArmVector.size(); x++) {
	stateLogFile << "################# STABLES FOR ARM " << x+1 << " ################" << endl;
	 
		for(int i=0; i < fullTable.piArmVector[x].piArm.size(); i++)
		{
		
			map<short int,STATE_TABLE>::iterator iter;
			for(iter = fullTable.piArmVector[x].piArm[i].begin(); iter != fullTable.piArmVector[x].piArm[i].end(); iter++) {
				stateLogFile <<"State table for stage:" << i+1 << "and next stage size:" << iter->first << endl;
				stateLogFile << "State \t Delay_cost \t opt_size \t cum_leakage" << endl;
				iter->second.printst(stateLogFile);
			}
			stateLogFile << "\n" << endl;
		}
	}

	stateLogFile << "############### COMP ARM TABLE ##################" << endl;

	map<short int, STATE_TABLE >::iterator iter1; 

	// print comp Arm
	for(iter1 = fullTable.piCompArm.begin(); iter1 != fullTable.piCompArm.end(); iter1++) {
		
		stateLogFile << "\nComp Arm Table for next stage size: " << iter1->first << endl << endl;
                stateLogFile << "State \t Delay_cost \t opt_size \t cum_leakage" << endl;
		iter1->second.printst(stateLogFile);
	}
	//print center table
	for(iter1 = fullTable.centerCellTable.begin(); iter1 != fullTable.centerCellTable.end(); iter1++) {

                stateLogFile << "\nCenter Cell Table for next stage size: " << iter1->first << endl << endl;
                stateLogFile << "State \t Delay_cost \t opt_size \t cum_leakage" << endl;
                iter1->second.printst(stateLogFile);
        }
	float finalLeakage = 0;
	//print PO arm
	stateLogFile << "\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ PO SIDE STABLES BEGIN @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n" << endl << endl;
	for(int i=0; i < fullTable.poArm.piArm.size(); i++) {
		map<short int,STATE_TABLE>::iterator iter;
		for(iter = fullTable.poArm.piArm[i].begin(); iter != fullTable.poArm.piArm[i].end(); iter++) {
                                stateLogFile <<"State table for PO stage:" << i+1 << "and next stage size:" << iter->first << endl;
                                stateLogFile << "State \t Delay_cost \t opt_size \t cum_leakage" << endl;
                                iter->second.printst(stateLogFile);
                }
		//if(i == fullTable.poArm.piArm.size()-1) {
		//	iter = fullTable.poArm.piArm[i].begin();
//		//	iter->second.getLeakage(dmax,true);
		//	logfile << "Final Stage Optimal leakage Power:" << iter->second.getLeakage(dmax,true) << endl;

		//}

                stateLogFile << "\n" << endl;
	}
}

// print optimized power value
logfile << "****Final stage's state table for batch mode/single mode\n";
for(int i=0; i < fullTable.poArm.piArm.size(); i++) {
	map<short int,STATE_TABLE>::iterator iter;
	if(i == fullTable.poArm.piArm.size()-1) {
                        iter = fullTable.poArm.piArm[i].begin();
			logfile << "State table for PO stage:" << i+1 << "and output cap:" << iter->first << endl;
			logfile << "State \t Delay_cost \t opt_size \t cum_leakage" << endl;
			iter->second.printst(logfile);
                        //logfile << "Final Stage Optimal leakage Power:" << iter->second.getLeakage(dmax,true) << endl;

        }


}


logfile.close();
netlist.close();
library.close();

//if(PRINT_STATE_LOG_INFO)
stateLogFile.close();

time2 = time(NULL);

cout << "TOTAL EXECUTION TIME: " << (time2 - time1)/60 << " MINUTES" << endl;

return 0;

}



