#include <iostream>
#include <string>
#include <vector>
#include <ctime>
#include <cstdlib>
#include <map>
#include <algorithm>
#include <numeric>
#include <fstream>
#include <math.h>
#include <assert.h>
#include <iterator>
#include <time.h>
#include <sstream>
#include <cstring>


using namespace std;

// utility functions - usually don't need any program specific classes/structs

int myrand0 (int s, int n);
int myrand1 (int s, int n);


// classes

struct STATE_TRIPLET
{
short int delay_cost,size; // delay_cost is for current stage, in case of composite cell, size is index
float leakage; // cumulative leakage

	STATE_TRIPLET() { }
	STATE_TRIPLET(short int d,short int s, float l)
	{
		delay_cost = d; leakage = l;size =s;
	}
	void set_triplet(short int d,short int s, float l)
	{
		delay_cost = d; leakage = l;size =s;
	}
};

// This is the absolutely bare version of state table.
//This needs to be extended to an array for output-cap dependency
class STATE_TABLE
{
private:
map<unsigned int,STATE_TRIPLET> st; // int here is budget

public:

STATE_TABLE();
~STATE_TABLE();

unsigned int minState();
unsigned int maxState();
void addState(unsigned int , short int ,short int, float); // (state,delay,size,leakage)
STATE_TRIPLET getTriplet(unsigned int, bool); // returns triplet corresponding to state
short int getDelayCost(unsigned int,bool);
short int getSize(unsigned int,bool);
float getLeakage(unsigned int,bool);
void printst(fstream &logfile);
bool isStateAvailable(unsigned int, bool&); 
void clear();

};

// tuple consists input cap vector, size vector, delay, power
struct	TUPLE_COMP_CELL 
{
short int size;
short int delay;
float power;
		TUPLE_COMP_CELL(short int s, short int d, float p) {
			size = s; delay = d; power = p;
		}
		TUPLE_COMP_CELL() { }

};


// works on the fact that only mesh structure's stages have composite cells
class COMP_CELL {

private:

public:
short int numGates; // number of gates in parallel
short int uniqueNumGates; // number of unique gates in parallel
short int numSizes; // number of sizes/indices of the comp cell, NUM_SIZES^uniqueNumGates

vector< vector<short int> > sizeVectors;
vector< vector<short int> > capVectors;
vector<float> leakages;

map<short int, vector<TUPLE_COMP_CELL> > loadCompCells; // int corresponds to next stage's composite cell's size index 

COMP_CELL(short int a,short int x ,short int y){ numGates = a; uniqueNumGates = x; numSizes = y; }
COMP_CELL(){ }
~COMP_CELL(){ }

short int getDelay(short int size); // size is the size of the output load

};

// holds all the state tables for all the stages of a PI arm
class PI_ARM {

public:
vector< map<short int,STATE_TABLE> > piArm;

};


// Full state table for the whole eyechart

class FULL_TABLE {

public:

vector<PI_ARM> piArmVector;

map<short int, STATE_TABLE > piCompArm; // first int is next stage size, second int is state

map<short int, STATE_TABLE> centerCellTable;

PI_ARM poArm; //only one PO arm because of symmetry of po arms
	      //works only for the option of IS_PO_CHAIN_SYMMETRIC 1 

//vector< map<int,STATE_TABLE> > finalChain;

};

class LIB_CELL
{

private:
string function;
short int fanin;
short int size; // type = inv1_x1,inv2_x1 
short int cap;
float leakage;

short int min_delay,max_delay;

map<short int,short int> delay_table;

public:
LIB_CELL(short int size, string f, float l,short int cap);
~LIB_CELL();
LIB_CELL(){ };

short int get_fainin();
short int get_size();
short int getInputCap();
float getLeakage();
short int getDelay(int cap);
short int getMinDelay();
short int getMaxDelay();

void setDelayTable(short int init_delay, short int finalDelay, bool isNonlin, float jumpCoeff, vector<short int> caps);
void printLibCell(fstream &logfile);
void setMinMaxDelay();

};



// holds topology information
struct EYE_CHART
{
vector<int> numPiStages; // number of stages on each of PI chains
vector<int> numPoStages; // number of stages on each of the PO chains
int logic_depth;	// max number of stages i.e., logic depth = max(numPiStages)+max(numPoStages)+1
vector<int> numPiChainMeshes; // Number of meshes on each of the PI chains
vector<int> numPiChainChains; // Number of chains on each of the PI chains
vector<int> numPoChainMeshes; // PO chains doesn't have chains

vector< vector<int> > piChainInfo; // each PI chain starts with a Mesh and ends with a chain beforee star node
vector< vector<int> > poChainInfo;
//optimal size storage info
int starOptSize;
int centerCellRemBudget; // budget remaining after allotting to centerCell
vector< map<int, int > > piOptSizes; // int is the composite cell size/actual size as applicable
vector< map<int, int > > poOptSizes; // first int is the stage number 


};


void createLibsInv(map<unsigned short int, LIB_CELL> &lib_cell_vector);
void createLibsThird(map<unsigned short int, LIB_CELL> &lib_cell_vector);
void createLibsNand(map<unsigned short int, LIB_CELL> &lib_cell_vector);

void createCapVector(vector<short int> &vec);
void formEye(EYE_CHART &eyeChart, unsigned int &num_gates);
void printMinGates(unsigned int &minNumGates);
void printEye(const EYE_CHART &eyeChart, fstream &logfile);
void buildCompositeCells(map<short int, COMP_CELL> &compCells, map<unsigned short int, LIB_CELL> &invLibs, map<unsigned short int, LIB_CELL> &nandLibs);
void printCompositeCells(map<short int, COMP_CELL> &compCells, fstream &logfile);

