/******************************************************************************
* uclaShape.h
* Developed by: XinHeng Huang email: huangxinheng@gmail.com
* Supervised by: Prof. Puneet Gupta
* Affiliation: University of California, Los Angeles, Department of Electrical
* Engineering
*
* Copyright (c) 2011.
*
******************************************************************************/

#ifndef LOGIC_OPERATION_H
#define LOGIC_OPERATION_H


#include <boost/polygon/polygon.hpp>
#include <vector>
#include <iostream>
#include "oaDesignDB.h"

using namespace boost::polygon::operators;
using namespace boost::polygon;
using namespace oa;
using namespace std;

namespace uclaShape{
	typedef vector<polygon_data<int> > LayoutSet;

	//HELPER FUNCTIONS
	void addPolygonData(LayoutSet &sets,int* points,unsigned int size);
	oaPointArray  getPolygonData(polygon_data<int> group);
	void load_shape(oaShape* shape,LayoutSet &group_1);
	void getResult(vector<oaPointArray> &result,LayoutSet &group_2);

	//OPERATION FUNCTIONS

	// DEFAULT: FLAG=0 -> APPEND MODE
	//   	    FLAG=1 -> OVERWRITE MODE

	//MAKE THE OBJECT EMPTY OF GEOMETRY;
	void clear(oaLPPHeader* lppHeader);
	void clear(oaBlock* block,oaLayerNum layerNum,oaPurposeNum purposeNum);
	
	//LOGIC OPERATION (ABLE TO DO: AND NOT OR XOR);
	oaBoolean logic_operation(oaBlock* block,oaLPPHeader *lppHeader1, oaLPPHeader *lppHeader2,oaLPPHeader *lppHeader3,oaLayerOp op,int flag=0);
	oaBoolean logic_operation(oaBlock* block,oaLPPHeader *lppHeader1, oaLPPHeader *lppHeader2,oaLayerNum layerNum,oaPurposeNum purposeNum,oaLayerOp op,int flag=0);

	//RETURN TRUE IF TWO OBJECTS ARE THE SAME,OTHERWISE FALSE;
	oaBoolean equivalence(oaLPPHeader *lppHeader1, oaLPPHeader *lppHeader2);
	oaBoolean equivalence(oaBlock* block1,oaLayerNum layerNum1,oaPurposeNum purposeNum1,oaBlock* block2,oaLayerNum layerNum2,oaPurposeNum purposeNum2);
	
	//RETURN TRUE IF OBJECT IS EMPTY OF GEOMETRY;
	oaBoolean empty(oaLPPHeader* lppHeader);
	oaBoolean empty(oaBlock* block,oaLayerNum layerNum,oaPurposeNum purposeNum);

	//RETURN THE AREA OF THE OBJECT;
	oaDouble area(oaLPPHeader *lppHeader);
	oaDouble area(oaBlock* block,oaLayerNum layerNum, oaPurposeNum purposeNum);

	//EXPANDING THE OBJECT BY INPUT NUMBER;
	oaBoolean bloat(oaBlock* block,oaLPPHeader* lppHeader,int num,int flag=0);
	oaBoolean bloat(oaBlock* block,oaLPPHeader* lppHeader,oaLayerNum layerNum,oaPurposeNum purposeNum,int num,int flag=0);

	//SHRINKING THE OBJECT BY INPUT NUMBER;
	oaBoolean shrink(oaBlock* block,oaLPPHeader* lppHeader,int num,int flag=0);
	oaBoolean shrink(oaBlock* block,oaLPPHeader* lppHeader,oaLayerNum layerNum,oaPurposeNum purposeNum,int num,int flag=0);

	//SCALING UP THE OBJECT BY INPUT NUMBER;
	oaBoolean scale_up(oaBlock* block,oaLPPHeader* lppHeader,int num,int flag=0);
	oaBoolean scale_up(oaBlock* block,oaLPPHeader* lppHeader,oaLayerNum layerNum,oaPurposeNum purposeNum,int num,int flag=0);

	//SCALING DOWN THE OBEJCT BY INPUT NUMBER;
	oaBoolean scale_down(oaBlock* block,oaLPPHeader* lppHeader,int num,int flag=0);
	oaBoolean scale_down(oaBlock* block,oaLPPHeader* lppHeader,oaLayerNum layerNum,oaPurposeNum purposeNum,int num,int flag=0);
	// KEEP THE AREA THAT SATISFIED THE ARGUEMENTS
	oaBoolean keep(oaBlock* block,oaLPPHeader* lppHeader,oaUInt4 min_area,oaUInt4 max_area,oaUInt4 min_width,oaUInt4 max_width,oaUInt4 min_height,oaUInt4 max_height);
}
#endif
